/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.action;

import com.buzanonline.chaos.action.ActionManager;
import com.buzanonline.chaos.action.IAction;
import com.buzanonline.chaos.preferences.PreferencesService;
import com.thinkbuzan.chaos.internationalization.I18n;
import com.thinkbuzan.chaos.osgiutilities.service.OSGiService;
import com.thinkbuzan.chaos.osgiutilities.service.PendingServiceManager;
import com.thinkbuzan.gaia.action.license.BundleLicenser;
import com.thinkbuzan.gaia.actions.ActionRegistrationManager;
import com.thinkbuzan.gaia.actions.CreateChildMapAction;
import com.thinkbuzan.gaia.actions.InsertSketchAction;
import com.thinkbuzan.gaia.actions.PinBranchAction;
import com.thinkbuzan.gaia.actions.PinBranchAndAncestryAction;
import com.thinkbuzan.gaia.actions.PinBranchAndSubtreeAction;
import com.thinkbuzan.gaia.actions.SetLayoutCondenseFlagsAction;
import com.thinkbuzan.gaia.actions.SetLayoutOrganicLevelAction;
import com.thinkbuzan.gaia.actions.SetLayoutSpacingValueAction;
import com.thinkbuzan.gaia.actions.SetSmartLayoutOnOffAction;
import com.thinkbuzan.gaia.actions.SetupBranchArtPagesAction;
import com.thinkbuzan.gaia.actions.ShowBranchArtDialogAction;
import com.thinkbuzan.gaia.actions.ShowBranchArtPopupAction;
import com.thinkbuzan.gaia.actions.ShowFormatBoundaryDialogAction;
import com.thinkbuzan.gaia.actions.ShowFormatBoundaryDialogDirectAction;
import com.thinkbuzan.gaia.actions.ShowFormatBranchBoxDialogAction;
import com.thinkbuzan.gaia.actions.ShowFormatBranchDialogAction;
import com.thinkbuzan.gaia.actions.ShowFormatDialogAction;
import com.thinkbuzan.gaia.actions.ShowFormatRelationshipDialogAction;
import com.thinkbuzan.gaia.actions.ShowSketchFillColourChooserAction;
import com.thinkbuzan.gaia.actions.ShowSketchStrokeColourChooserAction;
import com.thinkbuzan.gaia.actions.SketchCancelModeAction;
import com.thinkbuzan.gaia.actions.SketchToggleModeAction;
import com.thinkbuzan.gaia.actions.SketchToolChangeAction;
import com.thinkbuzan.gaia.actions.SketchToolChangeBrushAction;
import com.thinkbuzan.gaia.actions.SketchToolChangeEllipseAction;
import com.thinkbuzan.gaia.actions.SketchToolChangeEraserAction;
import com.thinkbuzan.gaia.actions.SketchToolChangeFontFamilyAction;
import com.thinkbuzan.gaia.actions.SketchToolChangeFontSizeAction;
import com.thinkbuzan.gaia.actions.SketchToolChangeFontStyleBoldAction;
import com.thinkbuzan.gaia.actions.SketchToolChangeFontStyleItalicAction;
import com.thinkbuzan.gaia.actions.SketchToolChangeLineAction;
import com.thinkbuzan.gaia.actions.SketchToolChangePencilAction;
import com.thinkbuzan.gaia.actions.SketchToolChangePolygonAction;
import com.thinkbuzan.gaia.actions.SketchToolChangeRectangleAction;
import com.thinkbuzan.gaia.actions.SketchToolChangeSelectAction;
import com.thinkbuzan.gaia.actions.SketchToolChangeSprayCanAction;
import com.thinkbuzan.gaia.actions.SketchToolChangeTextAction;
import com.thinkbuzan.gaia.actions.SketchToolFillColourAction;
import com.thinkbuzan.gaia.actions.SketchToolOpacityAction;
import com.thinkbuzan.gaia.actions.SketchToolStrokeColourAction;
import com.thinkbuzan.gaia.actions.SketchToolWidthAction;
import com.thinkbuzan.gaia.actions.UnPinBranchAction;
import com.thinkbuzan.gaia.actions.UnPinBranchAndAncestryAction;
import com.thinkbuzan.gaia.actions.UnPinBranchAndSubtreeAction;
import com.thinkbuzan.gaia.recentfiles.RecentFiles;
import com.thinkbuzan.gaia.tdviewinterface.TDViewInterface;
import com.thinkbuzan.pascal.services.editor.IEditorManager;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiManager
implements BundleActivator {
    private transient ServiceTracker actionManagerServiceTracker;
    private static ActionManager actionMan;
    private transient ServiceTracker editorManagerServiceTracker;
    private static IEditorManager editorMan;
    private static PreferencesService preferencesService;
    private static PendingServiceManager<TDViewInterface> tdViewInterface;
    private static I18n i18n;
    private static RecentFiles recentFiles;
    private static final String CREATE_UNLICENSED_ACTION_ID = "com.thinkbuzan.gaia.actions.CreateUnlicensedActionAction";

    public final void start(BundleContext context) {
        BundleLicenser.initLicenser(context);
        this.actionManagerServiceTracker = new ServiceTracker(context, ActionManager.class.getName(), null);
        this.actionManagerServiceTracker.open();
        this.editorManagerServiceTracker = new ServiceTracker(context, IEditorManager.class.getName(), null);
        this.editorManagerServiceTracker.open();
        OSGiService prefsService = new OSGiService(context, PreferencesService.class);
        preferencesService = (PreferencesService)prefsService.get();
        prefsService.close();
        OSGiService i18nService = new OSGiService(context, I18n.class);
        i18n = (I18n)i18nService.get();
        i18nService.close();
        OSGiService recentFilesService = new OSGiService(context, RecentFiles.class);
        recentFiles = (RecentFiles)recentFilesService.get();
        recentFilesService.close();
        tdViewInterface = new PendingServiceManager(new OSGiService(context, TDViewInterface.class));
        this.registerActions(context);
    }

    private void registerActions(BundleContext context) {
        IEditorManager editorManager;
        ActionManager actionManager;
        actionMan = actionManager = (ActionManager)this.actionManagerServiceTracker.getService();
        editorMan = editorManager = (IEditorManager)this.editorManagerServiceTracker.getService();
        ActionRegistrationManager.registerActionsWithActionManager(actionManager, context);
        this.registerLicensedActions(context, actionManager);
    }

    private void registerLicensedActions(BundleContext context, ActionManager actionManager) {
        if (BundleLicenser.isChildMapsLicensed()) {
            actionManager.addAction((IAction)new CreateChildMapAction(context));
        } else {
            actionManager.runAction(CREATE_UNLICENSED_ACTION_ID, new Object[]{"com.thinkbuzan.gaia.actions.CreateChildMapAction"});
        }
        if (BundleLicenser.isBranchPinningLicensed()) {
            actionManager.addAction((IAction)new PinBranchAction(context));
            actionManager.addAction((IAction)new PinBranchAndAncestryAction(context));
            actionManager.addAction((IAction)new PinBranchAndSubtreeAction(context));
            actionManager.addAction((IAction)new UnPinBranchAction(context));
            actionManager.addAction((IAction)new UnPinBranchAndAncestryAction(context));
            actionManager.addAction((IAction)new UnPinBranchAndSubtreeAction(context));
        } else {
            actionManager.runAction(CREATE_UNLICENSED_ACTION_ID, new Object[]{new PinBranchAction(context).getId()});
            actionManager.runAction(CREATE_UNLICENSED_ACTION_ID, new Object[]{new PinBranchAndAncestryAction(context).getId()});
            actionManager.runAction(CREATE_UNLICENSED_ACTION_ID, new Object[]{new PinBranchAndSubtreeAction(context).getId()});
            actionManager.runAction(CREATE_UNLICENSED_ACTION_ID, new Object[]{new UnPinBranchAction(context).getId()});
            actionManager.runAction(CREATE_UNLICENSED_ACTION_ID, new Object[]{new UnPinBranchAndAncestryAction(context).getId()});
            actionManager.runAction(CREATE_UNLICENSED_ACTION_ID, new Object[]{new UnPinBranchAndSubtreeAction(context).getId()});
        }
        boolean formatDialogLicensed = BundleLicenser.isFormatDialogLicensed();
        if (formatDialogLicensed) {
            actionManager.addAction((IAction)new ShowFormatDialogAction(context));
            actionManager.addAction((IAction)new ShowFormatBranchDialogAction(context));
            actionManager.addAction((IAction)new ShowFormatBranchBoxDialogAction(context));
        } else {
            actionManager.runAction(CREATE_UNLICENSED_ACTION_ID, new Object[]{new ShowFormatDialogAction(context).getId()});
            actionManager.runAction(CREATE_UNLICENSED_ACTION_ID, new Object[]{new ShowFormatBranchDialogAction(context).getId()});
            actionManager.runAction(CREATE_UNLICENSED_ACTION_ID, new Object[]{new ShowFormatBranchBoxDialogAction(context).getId()});
        }
        actionManager.addAction((IAction)new ShowFormatRelationshipDialogAction(context, formatDialogLicensed));
        actionManager.addAction((IAction)new ShowFormatBoundaryDialogAction(context, formatDialogLicensed));
        actionManager.addAction((IAction)new ShowFormatBoundaryDialogDirectAction(context, formatDialogLicensed));
        if (BundleLicenser.isSmartLayoutLicensed()) {
            actionManager.addAction((IAction)new SetSmartLayoutOnOffAction(context));
            actionManager.addAction((IAction)new SetLayoutOrganicLevelAction(context));
            actionManager.addAction((IAction)new SetLayoutSpacingValueAction(context));
            actionManager.addAction((IAction)new SetLayoutCondenseFlagsAction(context));
        } else {
            actionManager.runAction(CREATE_UNLICENSED_ACTION_ID, new Object[]{new SetSmartLayoutOnOffAction(context).getId()});
            actionManager.runAction(CREATE_UNLICENSED_ACTION_ID, new Object[]{new SetLayoutOrganicLevelAction(context).getId()});
            actionManager.runAction(CREATE_UNLICENSED_ACTION_ID, new Object[]{new SetLayoutSpacingValueAction(context).getId()});
            actionManager.runAction(CREATE_UNLICENSED_ACTION_ID, new Object[]{new SetLayoutCondenseFlagsAction(context).getId()});
        }
        if (BundleLicenser.isBranchArtLicensed()) {
            actionManager.addAction((IAction)new ShowBranchArtDialogAction(context));
            actionManager.addAction((IAction)new ShowBranchArtPopupAction(context));
            actionManager.addAction((IAction)new SetupBranchArtPagesAction(context));
        } else {
            actionManager.runAction(CREATE_UNLICENSED_ACTION_ID, new Object[]{new ShowBranchArtDialogAction(context).getId()});
            actionManager.runAction(CREATE_UNLICENSED_ACTION_ID, new Object[]{new ShowBranchArtPopupAction(context).getId()});
            actionManager.runAction(CREATE_UNLICENSED_ACTION_ID, new Object[]{new SetupBranchArtPagesAction(context).getId()});
        }
        if (BundleLicenser.isSketchOnCanvasLicensed()) {
            actionManager.addAction((IAction)new InsertSketchAction(context));
            actionManager.addAction((IAction)new SketchToggleModeAction(context));
            actionManager.addAction((IAction)new SketchCancelModeAction(context));
            actionManager.addAction((IAction)new SketchToolChangeAction(context));
            actionManager.addAction((IAction)new SketchToolChangeSelectAction(context));
            actionManager.addAction((IAction)new SketchToolChangePencilAction(context));
            actionManager.addAction((IAction)new SketchToolChangeBrushAction(context));
            actionManager.addAction((IAction)new SketchToolChangeSprayCanAction(context));
            actionManager.addAction((IAction)new SketchToolChangeEraserAction(context));
            actionManager.addAction((IAction)new SketchToolChangeRectangleAction(context));
            actionManager.addAction((IAction)new SketchToolChangeEllipseAction(context));
            actionManager.addAction((IAction)new SketchToolChangePolygonAction(context));
            actionManager.addAction((IAction)new SketchToolChangeLineAction(context));
            actionManager.addAction((IAction)new SketchToolWidthAction(context));
            actionManager.addAction((IAction)new SketchToolFillColourAction(context));
            actionManager.addAction((IAction)new SketchToolStrokeColourAction(context));
            actionManager.addAction((IAction)new SketchToolOpacityAction(context));
            actionManager.addAction((IAction)new SketchToolChangeTextAction(context));
            actionManager.addAction((IAction)new SketchToolChangeFontFamilyAction(context));
            actionManager.addAction((IAction)new SketchToolChangeFontSizeAction(context));
            actionManager.addAction((IAction)new SketchToolChangeFontStyleBoldAction(context));
            actionManager.addAction((IAction)new SketchToolChangeFontStyleItalicAction(context));
            actionManager.addAction((IAction)new ShowSketchFillColourChooserAction(context));
            actionManager.addAction((IAction)new ShowSketchStrokeColourChooserAction(context));
        } else {
            actionManager.runAction(CREATE_UNLICENSED_ACTION_ID, new Object[]{new InsertSketchAction(context).getId()});
            actionManager.runAction(CREATE_UNLICENSED_ACTION_ID, new Object[]{new SketchToggleModeAction(context).getId()});
            actionManager.runAction(CREATE_UNLICENSED_ACTION_ID, new Object[]{new SketchCancelModeAction(context).getId()});
            actionManager.runAction(CREATE_UNLICENSED_ACTION_ID, new Object[]{new SketchToolChangeAction(context).getId()});
            actionManager.runAction(CREATE_UNLICENSED_ACTION_ID, new Object[]{new SketchToolChangeSelectAction(context).getId()});
            actionManager.runAction(CREATE_UNLICENSED_ACTION_ID, new Object[]{new SketchToolChangePencilAction(context).getId()});
            actionManager.runAction(CREATE_UNLICENSED_ACTION_ID, new Object[]{new SketchToolChangeBrushAction(context).getId()});
            actionManager.runAction(CREATE_UNLICENSED_ACTION_ID, new Object[]{new SketchToolChangeSprayCanAction(context).getId()});
            actionManager.runAction(CREATE_UNLICENSED_ACTION_ID, new Object[]{new SketchToolChangeEraserAction(context).getId()});
            actionManager.runAction(CREATE_UNLICENSED_ACTION_ID, new Object[]{new SketchToolChangeRectangleAction(context).getId()});
            actionManager.runAction(CREATE_UNLICENSED_ACTION_ID, new Object[]{new SketchToolChangeEllipseAction(context).getId()});
            actionManager.runAction(CREATE_UNLICENSED_ACTION_ID, new Object[]{new SketchToolChangePolygonAction(context).getId()});
            actionManager.runAction(CREATE_UNLICENSED_ACTION_ID, new Object[]{new SketchToolChangeLineAction(context).getId()});
            actionManager.runAction(CREATE_UNLICENSED_ACTION_ID, new Object[]{new SketchToolWidthAction(context).getId()});
            actionManager.runAction(CREATE_UNLICENSED_ACTION_ID, new Object[]{new SketchToolFillColourAction(context).getId()});
            actionManager.runAction(CREATE_UNLICENSED_ACTION_ID, new Object[]{new SketchToolStrokeColourAction(context).getId()});
            actionManager.runAction(CREATE_UNLICENSED_ACTION_ID, new Object[]{new SketchToolOpacityAction(context).getId()});
            actionManager.runAction(CREATE_UNLICENSED_ACTION_ID, new Object[]{new SketchToolChangeTextAction(context).getId()});
            actionManager.runAction(CREATE_UNLICENSED_ACTION_ID, new Object[]{new SketchToolChangeFontFamilyAction(context).getId()});
            actionManager.runAction(CREATE_UNLICENSED_ACTION_ID, new Object[]{new SketchToolChangeFontSizeAction(context).getId()});
            actionManager.runAction(CREATE_UNLICENSED_ACTION_ID, new Object[]{new SketchToolChangeFontStyleBoldAction(context).getId()});
            actionManager.runAction(CREATE_UNLICENSED_ACTION_ID, new Object[]{new SketchToolChangeFontStyleItalicAction(context).getId()});
            actionManager.runAction(CREATE_UNLICENSED_ACTION_ID, new Object[]{new ShowSketchFillColourChooserAction(context).getId()});
            actionManager.runAction(CREATE_UNLICENSED_ACTION_ID, new Object[]{new ShowSketchStrokeColourChooserAction(context).getId()});
        }
    }

    public static final RecentFiles getRecentFiles() {
        return recentFiles;
    }

    public static final ActionManager getActionManager() {
        return actionMan;
    }

    public static final IEditorManager getEditorManager() {
        return editorMan;
    }

    public static final PreferencesService getPreferencesService() {
        return preferencesService;
    }

    public static final I18n getI18n() {
        return i18n;
    }

    public static void setI18n(I18n i18nIn) {
        i18n = i18nIn;
    }

    public static PendingServiceManager<TDViewInterface> getPendingTdViewInterface() {
        return tdViewInterface;
    }

    public final void stop(BundleContext context) {
        this.actionManagerServiceTracker.close();
        this.editorManagerServiceTracker.close();
    }
}

