/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.action.license;

import com.thinkbuzan.chaos.osgiutilities.service.OSGiService;
import com.thinkbuzan.phoenix.licensing.LicenseState;
import com.thinkbuzan.phoenix.licensing.PluginLicense;
import com.thinkbuzan.phoenix.licensing.PluginLicenseService;
import org.osgi.framework.BundleContext;

public final class BundleLicenser {
    private static final String CHILDMAPS_LICENSE_ID = "com.thinkbuzan.license.gaia.childmaps";
    private static final String BRANCH_PIN_LICENSE_ID = "com.thinkbuzan.license.gaia.branchfreeze";
    private static final String FORMAT_DIALOG_LICENSE_ID = "com.thinkbuzan.license.phoenix.formatdialog";
    private static final String SMART_LAYOUT_LICENSE_ID = "com.thinkbuzan.license.gaia.smartlayout";
    private static final String BRANCH_ART_LICENSE_ID = "com.thinkbuzan.license.pascal.branchart";
    private static final String SKETCH_ON_CANVAS_LICENSE_ID = "com.thinkbuzan.license.pascal.sketchoncanvas";
    private static final String BRAINSTORM_LICENSE_ID = "com.thinkbuzan.license.view.brainstorm";
    private static final String PRESENTATION_LICENSE_ID = "com.thinkbuzan.license.gaia.presentationview";
    private static final String FAST_CAPTURE_LICENSE_ID = "com.thinkbuzan.license.view.fastcapture";
    private static final String TIMELINE_LICENSE_ID = "com.thinkbuzan.license.view.fastcapture";
    private static transient PluginLicenseService pluginLicenseService;

    private BundleLicenser() {
    }

    public static void initLicenser(BundleContext context) {
        pluginLicenseService = (PluginLicenseService)new OSGiService(context, PluginLicenseService.class).get();
    }

    public static boolean isChildMapsLicensed() {
        return pluginLicenseService != null && BundleLicenser.isLicenseActive(pluginLicenseService.getPluginLicense(CHILDMAPS_LICENSE_ID));
    }

    public static boolean isBranchPinningLicensed() {
        return pluginLicenseService != null && BundleLicenser.isLicenseActive(pluginLicenseService.getPluginLicense(BRANCH_PIN_LICENSE_ID));
    }

    public static boolean isFormatDialogLicensed() {
        return pluginLicenseService != null && BundleLicenser.isLicenseActive(pluginLicenseService.getPluginLicense(FORMAT_DIALOG_LICENSE_ID));
    }

    public static boolean isSmartLayoutLicensed() {
        return pluginLicenseService != null && BundleLicenser.isLicenseActive(pluginLicenseService.getPluginLicense(SMART_LAYOUT_LICENSE_ID));
    }

    public static boolean isBranchArtLicensed() {
        return pluginLicenseService != null && BundleLicenser.isLicenseActive(pluginLicenseService.getPluginLicense(BRANCH_ART_LICENSE_ID));
    }

    public static boolean isSketchOnCanvasLicensed() {
        return pluginLicenseService != null && BundleLicenser.isLicenseActive(pluginLicenseService.getPluginLicense(SKETCH_ON_CANVAS_LICENSE_ID));
    }

    public static boolean isBrainstormLicensed() {
        return pluginLicenseService != null && BundleLicenser.isLicenseActive(pluginLicenseService.getPluginLicense(BRAINSTORM_LICENSE_ID));
    }

    public static boolean isPresentationLicensed() {
        return pluginLicenseService != null && BundleLicenser.isLicenseActive(pluginLicenseService.getPluginLicense(PRESENTATION_LICENSE_ID));
    }

    public static boolean isFastCaptureLicensed() {
        return pluginLicenseService != null && BundleLicenser.isLicenseActive(pluginLicenseService.getPluginLicense("com.thinkbuzan.license.view.fastcapture"));
    }

    public static boolean isTimelineLicensed() {
        return pluginLicenseService != null && BundleLicenser.isLicenseActive(pluginLicenseService.getPluginLicense("com.thinkbuzan.license.view.fastcapture"));
    }

    private static boolean isLicenseActive(PluginLicense pluginLicense) {
        return pluginLicense != null && LicenseState.valid.equals((Object)pluginLicense.getState());
    }
}

