/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.actions;

import com.mxgraph.mindmap.model.mmBranchCell;
import com.mxgraph.mindmap.model.mmCell;
import com.mxgraph.mindmap.view.mmGraph;
import com.thinkbuzan.chaos.utilities.edtutilities.EDTUtilities;
import com.thinkbuzan.gaia.action.AbstractOSGiAction;
import com.thinkbuzan.gaia.editor.BranchType;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.editor.actions.AbstractEditorAction;
import com.thinkbuzan.gaia.editor.actions.ChangeCellTypeAction;
import com.thinkbuzan.gaia.editor.actions.RunHybridLayoutAction;
import com.thinkbuzan.gaia.editor.actions.SetLayoutEnabledAction;
import com.thinkbuzan.gaia.editor.actions.SetSelectionAction;
import com.thinkbuzan.gaia.editor.actionsupport.SelectionSupport;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConvertAction
extends AbstractOSGiAction {
    private final transient SelectionSupport selectionSupport;
    private final transient BranchType branchType;

    public AbstractConvertAction(BundleContext contextIn, BranchType branchTypeIn) {
        super(contextIn);
        this.branchType = branchTypeIn;
        this.changeState(false);
        this.selectionSupport = new SelectionSupport(this.getBundleContext()){

            public void updateState(IEditorComponent editorComponent, List<mmCell> selectionCells) {
                boolean enabled = AbstractConvertAction.this.isEnabled(selectionCells);
                AbstractConvertAction.this.changeState(enabled);
            }
        };
    }

    protected boolean isEnabled(List<mmCell> selectionCells) {
        boolean enabled = false;
        for (mmCell cell : selectionCells) {
            if (!(cell instanceof mmBranchCell)) continue;
            enabled = true;
            break;
        }
        return enabled;
    }

    public final void runAction(Object ... parameters) {
        final IEditorComponent editor = this.selectionSupport.getCurrentEditor();
        final List allSelectionCells = editor.getAllSelectionCells();
        if (!this.isEnabled(allSelectionCells)) {
            throw new IllegalStateException("The action can only be run when it is enabled");
        }
        EDTUtilities.runOnEDT((Runnable)new Runnable(){

            public void run() {
                final ArrayList<Object> selection = new ArrayList<Object>();
                final mmGraph graph = (mmGraph)editor.getGraphComponent().getGraph();
                final boolean layoutEnabled = graph.getLayoutSettings().isLayoutOn();
                editor.runAction((AbstractEditorAction)new SetLayoutEnabledAction(false, false));
                graph.clearSelection();
                graph.getModel().beginUpdate();
                for (mmCell cell : allSelectionCells) {
                    if (cell instanceof mmBranchCell) {
                        mmBranchCell newBranch = (mmBranchCell)editor.runAction((AbstractEditorAction)new ChangeCellTypeAction((mmBranchCell)cell, AbstractConvertAction.this.branchType));
                        if (newBranch == null) {
                            selection.add(cell);
                            continue;
                        }
                        selection.add(newBranch);
                        continue;
                    }
                    selection.add(cell);
                }
                if (layoutEnabled) {
                    ActionListener listener = new ActionListener(){

                        public void actionPerformed(ActionEvent event) {
                            graph.getModel().endUpdate();
                            editor.runAction((AbstractEditorAction)new SetLayoutEnabledAction(layoutEnabled, false));
                            if (!selection.isEmpty()) {
                                editor.runAction((AbstractEditorAction)new SetSelectionAction(selection.toArray()));
                            }
                        }
                    };
                    editor.runAction((AbstractEditorAction)new RunHybridLayoutAction(true, listener, true));
                } else {
                    graph.getModel().endUpdate();
                    editor.runAction((AbstractEditorAction)new SetLayoutEnabledAction(layoutEnabled, false));
                    if (!selection.isEmpty()) {
                        editor.runAction((AbstractEditorAction)new SetSelectionAction(selection.toArray()));
                    }
                }
            }
        });
    }
}

