/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.actions;

import com.buzanonline.chaos.systemstate.ISystemState;
import com.mxgraph.mindmap.model.mmCell;
import com.mxgraph.mindmap.model.mmFloatingIdeaCell;
import com.mxgraph.mindmap.model.mmICell;
import com.mxgraph.mindmap.util.PropertyUtilities;
import com.thinkbuzan.chaos.internationalization.I18n;
import com.thinkbuzan.chaos.osgiutilities.service.OSGiService;
import com.thinkbuzan.gaia.action.AbstractOSGiAction;
import com.thinkbuzan.gaia.dialogs.SpellCheckerDialog;
import com.thinkbuzan.gaia.editor.EditorManager;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.editor.actions.AbstractEditorAction;
import com.thinkbuzan.gaia.editor.actions.SetLabelAction;
import com.thinkbuzan.gaia.editor.actionsupport.ViewTypeSupport;
import com.thinkbuzan.gaia.spellchecker.ISpellingChangeListener;
import com.thinkbuzan.gaia.spellchecker.SpellCheckerException;
import com.thinkbuzan.gaia.spellchecker.SpellCheckerService;
import com.thinkbuzan.gaia.ui.MainFrameUtilities;
import com.thinkbuzan.gaia.ui.v2.factory.UIFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckSpellingAction
extends AbstractOSGiAction
implements ISpellingChangeListener {
    private static final Logger LOGGER = Logger.getLogger(CheckSpellingAction.class);
    private static final String SPELL_KEY = "com.thinkbuzan.gaia.cell.spell";
    private final transient EditorManager editorManager;
    private final transient SpellCheckerService spellChecker;
    private transient SpellCheckerDialog checkerDialog;
    private final transient ViewTypeSupport viewTypeSupport;
    private final transient List<mmICell> cellsToSpellCheck = new ArrayList<mmICell>();
    private transient int cellIndex = 0;
    private final transient I18n i18n;

    public CheckSpellingAction(BundleContext context) {
        super(context);
        this.editorManager = (EditorManager)new OSGiService(this.getBundleContext(), EditorManager.class).get();
        this.spellChecker = (SpellCheckerService)new OSGiService(this.getBundleContext(), SpellCheckerService.class).get();
        this.changeState(false);
        this.viewTypeSupport = new ViewTypeSupport(context){

            public void updateState() {
                CheckSpellingAction.this.changeState(CheckSpellingAction.this.isEnabled());
            }
        };
        OSGiService i18nService = new OSGiService(this.getBundleContext(), I18n.class);
        this.i18n = (I18n)i18nService.get();
    }

    private boolean isEnabled() {
        return this.viewTypeSupport.getViewId() != null;
    }

    public final String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public final void runAction(Object ... parameters) {
        if (this.isEnabled()) {
            if (this.checkerDialog == null) {
                this.checkerDialog = new SpellCheckerDialog((ISpellingChangeListener)this);
            }
            this.checkSpelling();
        } else {
            LOGGER.debug((Object)"Spell checker invoked when action disabled");
        }
    }

    private void checkSpelling() {
        this.cellsToSpellCheck.clear();
        IEditorComponent editorComponent = this.editorManager.getCurrentEditorComponent();
        for (mmFloatingIdeaCell idea : editorComponent.getFloatingIdeas()) {
            this.cellsToSpellCheck.add((mmICell)idea);
            this.cellsToSpellCheck.addAll(idea.getVisibleDescendantsStructures());
        }
        this.cellsToSpellCheck.addAll(editorComponent.getFloatingTexts());
        this.cellsToSpellCheck.addAll(editorComponent.getFlowchartCells());
        this.cellsToSpellCheck.addAll(editorComponent.getFlowchartConnectorCells());
        if (!this.cellsToSpellCheck.isEmpty()) {
            this.cellIndex = 0;
            this.setNextMisspeltWord();
        } else {
            this.showEndOfSpellCheck();
        }
    }

    private void setNextMisspeltWord() {
        if (this.cellIndex < this.cellsToSpellCheck.size()) {
            Map<String, List<String>> wordSuggestionMap = this.getWordSuggestionMap(this.cellsToSpellCheck.get(this.cellIndex));
            if (wordSuggestionMap.isEmpty()) {
                ++this.cellIndex;
                this.setNextMisspeltWord();
            } else {
                if (wordSuggestionMap.size() > 1) {
                    LOGGER.warn((Object)"Map contains too many elements, only 1 will be processed");
                }
                for (Map.Entry<String, List<String>> spellCheckEntry : wordSuggestionMap.entrySet()) {
                    this.checkerDialog.setValues(spellCheckEntry.getKey(), spellCheckEntry.getValue());
                    if (this.checkerDialog.isVisible()) continue;
                    this.checkerDialog.setVisible(true);
                }
            }
        } else {
            this.showEndOfSpellCheck();
        }
    }

    private Map<String, List<String>> getWordSuggestionMap(mmICell cell) {
        String misspeltWord;
        String spellErrorIndexes = PropertyUtilities.getPropertyString((mmICell)cell, (String)SPELL_KEY);
        HashMap<String, List<String>> wordSuggestMap = new HashMap<String, List<String>>();
        if (spellErrorIndexes != null && spellErrorIndexes.length() > 0 && (misspeltWord = this.getMisspeltWord(PropertyUtilities.getText((mmICell)cell), spellErrorIndexes)) != null) {
            wordSuggestMap.put(misspeltWord, this.spellChecker.getSuggestions(misspeltWord));
        }
        return wordSuggestMap;
    }

    private String getMisspeltWord(String sentence, String spellErrorIndexes) {
        StringTokenizer st = new StringTokenizer(spellErrorIndexes, ",");
        int[] errorIndexes = new int[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            try {
                errorIndexes[i++] = Integer.parseInt(token);
            }
            catch (NumberFormatException ex) {
                LOGGER.warn((Object)"Misspelt word index is not a number", (Throwable)ex);
            }
        }
        ArrayList<String> misspellWordList = new ArrayList<String>();
        for (i = 0; i < errorIndexes.length - 1; i += 2) {
            misspellWordList.add(sentence.substring(errorIndexes[i], errorIndexes[i + 1]));
        }
        if (!misspellWordList.isEmpty()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Returning word: " + (String)misspellWordList.get(0)));
            }
            return (String)misspellWordList.get(0);
        }
        return null;
    }

    private void showEndOfSpellCheck() {
        String message = this.i18n.getLocalizedText("com.thinkbuzan.i18n.imindmap.spellCheckComplete");
        int option = UIFactory.showConfirmDialog(MainFrameUtilities.getMainFrame(), this.i18n.getLocalizedText("com.thinkbuzan.i18n.guicommons.spellchecker.title"), message, this.i18n.getLocalizedText("com.thinkbuzan.i18n.common.yes"), this.i18n.getLocalizedText("com.thinkbuzan.i18n.common.no"));
        if (option == 0) {
            this.checkSpelling();
        } else {
            this.checkerDialog.setVisible(false);
            this.checkerDialog.dispose();
        }
    }

    public final void systemStateChanged(ISystemState systemState) {
    }

    public final void changeWord(String misspelledWord, String changeWord) {
        IEditorComponent editorComponent = this.editorManager.getCurrentEditorComponent();
        mmICell cellToChange = this.cellsToSpellCheck.get(this.cellIndex);
        if (cellToChange instanceof mmCell) {
            String currentCellText = PropertyUtilities.getText((mmICell)cellToChange);
            String modifiedCellText = currentCellText.replace(misspelledWord, changeWord);
            editorComponent.runAction((AbstractEditorAction)new SetLabelAction((mmCell)cellToChange, modifiedCellText));
        } else {
            LOGGER.warn((Object)"Cell text not updated as not an mmCell");
        }
        this.refreshView();
        this.setNextMisspeltWord();
    }

    public final void addWord(String ignoreWord) {
        try {
            this.spellChecker.addWordinLexicon(ignoreWord, SpellCheckerService.LexiconAddType.Temporary);
        }
        catch (SpellCheckerException e) {
            LOGGER.error((Object)"Failed to add word to temporary lexicon (ignore)", (Throwable)e);
        }
        this.refreshView();
        this.setNextMisspeltWord();
    }

    public final void ignoreWord(String ignoreWord) {
        try {
            this.spellChecker.addWordinLexicon(ignoreWord, SpellCheckerService.LexiconAddType.Temporary);
        }
        catch (SpellCheckerException e) {
            LOGGER.error((Object)"Failed to add word to permanent lexicon (add)", (Throwable)e);
        }
        this.refreshView();
        this.setNextMisspeltWord();
    }

    private void refreshView() {
        this.editorManager.getCurrentEditorComponent().getGraphComponent().refresh();
    }
}

