/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.actions;

import com.buzanonline.chaos.action.ActionManager;
import com.buzanonline.chaos.systemstate.ISystemState;
import com.mxgraph.mindmap.model.mmBranchCell;
import com.mxgraph.mindmap.model.mmCell;
import com.mxgraph.mindmap.model.mmFloatingIdeaCell;
import com.mxgraph.mindmap.model.mmICell;
import com.mxgraph.mindmap.model.mmIStructureCell;
import com.mxgraph.mindmap.model.mmImageCell;
import com.mxgraph.mindmap.model.mmPluginCell;
import com.mxgraph.mindmap.swing.mmGraphComponent;
import com.mxgraph.mindmap.swing.util.mmGraphTransferable;
import com.mxgraph.mindmap.util.PropertyUtilities;
import com.mxgraph.mindmap.util.ThemeSettings;
import com.mxgraph.mindmap.util.mmUtils;
import com.mxgraph.mindmap.view.mmGraph;
import com.mxgraph.model.mxICell;
import com.thinkbuzan.chaos.internationalization.I18n;
import com.thinkbuzan.chaos.osgiutilities.service.IServiceListener;
import com.thinkbuzan.chaos.osgiutilities.service.OSGiService;
import com.thinkbuzan.chaos.osgiutilities.service.ServiceAdapter;
import com.thinkbuzan.chaos.utilities.io.RelativeFileUtilities;
import com.thinkbuzan.gaia.action.AbstractOSGiAction;
import com.thinkbuzan.gaia.actions.resources.ResourceManager;
import com.thinkbuzan.gaia.editor.EditorManager;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.editor.actions.AbstractEditorAction;
import com.thinkbuzan.gaia.editor.actions.AddFloatingIdeaAction;
import com.thinkbuzan.gaia.editor.actions.AddHyperLinkAction;
import com.thinkbuzan.gaia.editor.actions.CondenseMapAction;
import com.thinkbuzan.gaia.editor.actions.RemoveCellAndSubTreeAction;
import com.thinkbuzan.gaia.editor.actions.RunImportLayoutAction;
import com.thinkbuzan.gaia.editor.actions.ScrollToPositionAction;
import com.thinkbuzan.gaia.editor.actionsupport.SelectionSupport;
import com.thinkbuzan.gaia.entities.HyperLink;
import com.thinkbuzan.gaia.entities.HyperLinkType;
import com.thinkbuzan.gaia.entities.MindMapImage;
import com.thinkbuzan.gaia.onlineaccountaccessclient.OnlineAccountAccessClient;
import com.thinkbuzan.gaia.onlinemaps.information.OnlineMapsInformation;
import com.thinkbuzan.gaia.onlinemaps.saver.OnlineMapsSaver;
import com.thinkbuzan.gaia.ui.MainFrameUtilities;
import com.thinkbuzan.gaia.ui.v2.factory.UIFactory;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CreateChildMapAction
extends AbstractOSGiAction {
    private final transient SelectionSupport selectionSupport;
    private transient EditorManager editorManager;
    private transient OnlineMapsInformation onlineMapsInformation;
    private transient OnlineMapsSaver onlineMapsSaver;
    private transient OnlineAccountAccessClient onlineAccountAccessClient;
    private transient ActionManager actionManager;
    private transient I18n i18n;
    private static final String IMX_EXTENSION = ".imx";
    private static final String ILLEGAL_CHARACTERS = "[\\\\/:\\*?\"<>\\|]";
    private static final Logger LOGGER = Logger.getLogger(CreateChildMapAction.class);
    public static final String ACTION_ID = "com.thinkbuzan.gaia.actions.CreateChildMapAction";

    public CreateChildMapAction(BundleContext context) {
        super(context);
        OSGiService editorManagerService = new OSGiService(this.getBundleContext(), EditorManager.class);
        OSGiService onlineMapsInformationService = new OSGiService(this.getBundleContext(), OnlineMapsInformation.class);
        OSGiService onlineMapsSaverService = new OSGiService(this.getBundleContext(), OnlineMapsSaver.class);
        OSGiService onlineAccountAccessClientService = new OSGiService(this.getBundleContext(), OnlineAccountAccessClient.class);
        OSGiService actionManagerService = new OSGiService(this.getBundleContext(), ActionManager.class);
        OSGiService i18nService = new OSGiService(this.getBundleContext(), I18n.class);
        editorManagerService.addListener((IServiceListener)new ServiceAdapter<EditorManager>(){

            public void serviceAdded(EditorManager service) {
                CreateChildMapAction.this.editorManager = service;
            }
        });
        onlineMapsInformationService.addListener((IServiceListener)new ServiceAdapter<OnlineMapsInformation>(){

            public void serviceAdded(OnlineMapsInformation service) {
                CreateChildMapAction.this.onlineMapsInformation = service;
            }
        });
        onlineMapsSaverService.addListener((IServiceListener)new ServiceAdapter<OnlineMapsSaver>(){

            public void serviceAdded(OnlineMapsSaver service) {
                CreateChildMapAction.this.onlineMapsSaver = service;
            }
        });
        onlineAccountAccessClientService.addListener((IServiceListener)new ServiceAdapter<OnlineAccountAccessClient>(){

            public void serviceAdded(OnlineAccountAccessClient service) {
                CreateChildMapAction.this.onlineAccountAccessClient = service;
            }
        });
        actionManagerService.addListener((IServiceListener)new ServiceAdapter<ActionManager>(){

            public void serviceAdded(ActionManager service) {
                CreateChildMapAction.this.actionManager = service;
            }
        });
        i18nService.addListener((IServiceListener)new ServiceAdapter<I18n>(){

            public void serviceAdded(I18n service) {
                CreateChildMapAction.this.i18n = service;
            }
        });
        this.changeState(false);
        this.selectionSupport = new SelectionSupport(context){

            public void updateState(IEditorComponent editorComponent, List<mmCell> selectionCells) {
                boolean enabled = CreateChildMapAction.this.isEnabled(selectionCells);
                CreateChildMapAction.this.changeState(enabled);
            }
        };
    }

    private boolean isEnabled(List<mmCell> selectedCells) {
        boolean allAvailable = true;
        if (this.editorManager == null) {
            allAvailable = false;
        }
        if (this.onlineMapsInformation == null) {
            allAvailable = false;
        }
        if (this.onlineMapsSaver == null) {
            allAvailable = false;
        }
        if (this.onlineAccountAccessClient == null) {
            allAvailable = false;
        }
        if (this.actionManager == null) {
            allAvailable = false;
        }
        if (this.i18n == null) {
            allAvailable = false;
        }
        if (selectedCells == null || selectedCells.size() != 1 || !(selectedCells.get(0) instanceof mmBranchCell)) {
            allAvailable = false;
        }
        return allAvailable;
    }

    public String getId() {
        return ACTION_ID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAction(Object ... parameters) {
        IEditorComponent parentMapEditorComponent;
        if (this.selectionSupport.getSelectionCells() == null || this.selectionSupport.getSelectionCells().size() != 1 || !(this.selectionSupport.getSelectionCells().get(0) instanceof mmBranchCell)) {
            LOGGER.error((Object)("Invalid Selection Cells, expected 1 selected mmBranchCell. selection= " + this.selectionSupport.getSelectionCells()));
            return;
        }
        mmBranchCell selectedStructure = (mmBranchCell)this.selectionSupport.getSelectionCells().get(0);
        try {
            parentMapEditorComponent = this.selectionSupport.getCurrentEditor();
        }
        catch (IllegalStateException exception) {
            return;
        }
        this.editorManager.setEditorComponentBusy(parentMapEditorComponent.getId(), true);
        IEditorComponent childMapEditorComponent = null;
        try {
            String parentMapSaveLocation = parentMapEditorComponent.getSaveLocation();
            File parentMapSaveLocationFile = null;
            if (parentMapSaveLocation == null) {
                int pass = UIFactory.showConfirmDialog(MainFrameUtilities.getMainFrame(), this.i18n.getLocalizedText("com.thinkbuzan.i18n.common.childmap.saveparent.title"), this.i18n.getLocalizedText("com.thinkbuzan.i18n.common.childmap.saveparent.message"), this.i18n.getLocalizedText("com.thinkbuzan.i18n.common.ok"), this.i18n.getLocalizedText("com.thinkbuzan.i18n.common.cancel"));
                if (pass == 0) {
                    this.actionManager.runAction("com.thinkbuzan.gaia.actions.SaveAction", new Object[0]);
                }
                if (parentMapEditorComponent.getSaveLocation() == null) {
                    this.editorManager.setEditorComponentBusy(parentMapEditorComponent.getId(), false);
                    return;
                }
                parentMapSaveLocationFile = new File(parentMapEditorComponent.getSaveLocation());
            } else {
                parentMapSaveLocationFile = new File(parentMapSaveLocation);
                if (this.onlineMapsInformation.isSharedMap(parentMapSaveLocationFile)) {
                    UIFactory.showMessageDialog(MainFrameUtilities.getMainFrame(), this.i18n.getLocalizedText("com.thinkbuzan.i18n.common.childmap.cannotcreate.title"), this.i18n.getLocalizedText("com.thinkbuzan.i18n.common.childmap.cannotcreate.message"), this.i18n.getLocalizedText("com.thinkbuzan.i18n.common.ok"));
                    this.editorManager.setEditorComponentBusy(parentMapEditorComponent.getId(), false);
                    return;
                }
            }
            childMapEditorComponent = this.editorManager.createEditorComponent();
            this.editorManager.setEditorComponentBusy(childMapEditorComponent.getId(), true);
            childMapEditorComponent.beginUpdate();
            childMapEditorComponent.getGraphComponent().getGraphControl().updatePreferredSize();
            this.copyParentMapSettings(parentMapEditorComponent, childMapEditorComponent);
            final mmFloatingIdeaCell floatingIdea = this.insertFloatingIdea(parentMapEditorComponent, selectedStructure, childMapEditorComponent);
            boolean isOnlineMap = this.onlineMapsInformation.isOnlineMap(parentMapSaveLocationFile);
            if (!isOnlineMap) {
                String childMapSaveLocation = this.getChildSaveLocation(parentMapSaveLocationFile, selectedStructure);
                childMapEditorComponent.setSaveLocation(childMapSaveLocation);
                this.addFileLinkToMap(childMapEditorComponent, (mmIStructureCell)floatingIdea, parentMapEditorComponent.getSaveLocation());
            }
            this.updateChildMapInView(childMapEditorComponent);
            this.populateChildMap(parentMapEditorComponent, selectedStructure, childMapEditorComponent, floatingIdea);
            childMapEditorComponent.runAction((AbstractEditorAction)new RunImportLayoutAction());
            childMapEditorComponent.runAction((AbstractEditorAction)new CondenseMapAction());
            childMapEditorComponent.endUpdate();
            if (isOnlineMap) {
                this.actionManager.runAction("com.thinkbuzan.gaia.actions.SaveAction", new Object[0]);
            } else {
                this.actionManager.runAction("com.thinkbuzan.gaia.actions.SaveAction", new Object[0]);
                this.addFileLinkToMap(parentMapEditorComponent, (mmIStructureCell)selectedStructure, childMapEditorComponent.getSaveLocation());
            }
            boolean descendantsDeleted = false;
            if (selectedStructure.getChildStructures() != null && !selectedStructure.getChildStructures().isEmpty()) {
                int answer = UIFactory.showConfirmDialog(MainFrameUtilities.getMainFrame(), this.i18n.getLocalizedText("com.thinkbuzan.i18n.common.childmap.deletechildren.title"), this.i18n.getLocalizedText("com.thinkbuzan.i18n.common.childmap.deletechildren.message"), this.i18n.getLocalizedText("com.thinkbuzan.i18n.common.yes"), this.i18n.getLocalizedText("com.thinkbuzan.i18n.common.no"));
                boolean bl = descendantsDeleted = answer == 0;
            }
            if (descendantsDeleted && selectedStructure.getChildStructures().size() > 0) {
                parentMapEditorComponent.runAction((AbstractEditorAction)new RemoveCellAndSubTreeAction(selectedStructure.getChildStructures().toArray()));
            }
            if (!isOnlineMap || descendantsDeleted) {
                this.actionManager.runAction("com.thinkbuzan.gaia.actions.SaveMapQuietlyAction", new Object[]{parentMapEditorComponent});
            }
            this.editorManager.switchFocusToEditorComponent(childMapEditorComponent.getId());
            final IEditorComponent childEditor = childMapEditorComponent;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    childEditor.runSingleAction((AbstractEditorAction)new ScrollToPositionAction((Object)floatingIdea, true));
                }
            });
            if (selectedStructure.getChildStructures() == null || selectedStructure.getChildStructures().isEmpty()) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        int sleepTime = 500;
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e) {
                            LOGGER.warn((Object)("scroll thread interrupted! " + e));
                        }
                        childEditor.runSingleAction((AbstractEditorAction)new ScrollToPositionAction((Object)floatingIdea, true));
                    }
                };
                Thread scrollThread = new Thread(runnable);
                scrollThread.setDaemon(true);
                scrollThread.start();
            }
            this.clearUndoManager(childMapEditorComponent);
            childMapEditorComponent.setModified(false);
            this.actionManager.runAction("com.thinkbuzan.gaia.actions.SaveMapQuietlyAction", new Object[]{childMapEditorComponent});
        }
        catch (Exception exc) {
            LOGGER.error((Object)"Exception thrown when creating child map", (Throwable)exc);
        }
        finally {
            this.editorManager.setEditorComponentBusy(parentMapEditorComponent.getId(), false);
            if (childMapEditorComponent != null) {
                try {
                    this.editorManager.setEditorComponentBusy(childMapEditorComponent.getId(), false);
                }
                catch (IllegalArgumentException exc) {
                    LOGGER.info((Object)"Couldn't remove busy animation from child editor because it couldn't be found");
                }
            }
        }
    }

    private void clearUndoManager(IEditorComponent childMapEditorComponent) {
        childMapEditorComponent.getGraphComponent().getUndoManager().clear();
    }

    private void addFileLinkToMap(IEditorComponent editorToAddLink, mmIStructureCell cellToAddLink, String linkString) {
        HyperLink link = new HyperLink();
        link.setType(HyperLinkType.FILE);
        link.setChildMapLink(true);
        File relativeLink = RelativeFileUtilities.convertToRelative((File)new File(linkString), (File)new File(editorToAddLink.getSaveLocation()).getParentFile());
        if (relativeLink == null) {
            LOGGER.warn("Couldn't convert link to relative! link=%s, saveLocation=%s", (Object)linkString, (Object)editorToAddLink.getSaveLocation());
            link.setLink(linkString);
        } else {
            link.setLink(relativeLink.getPath());
        }
        editorToAddLink.runAction((AbstractEditorAction)new AddHyperLinkAction((mmICell)cellToAddLink, link));
    }

    private void updateChildMapInView(IEditorComponent childMapEditorComponent) {
        mmGraph graph = (mmGraph)childMapEditorComponent.getGraphComponent().getGraph();
        graph.centerCells();
    }

    private void copyParentMapSettings(IEditorComponent parentMapEditorComponent, IEditorComponent childMapEditorComponent) {
        mmGraphComponent childGraphComp = childMapEditorComponent.getGraphComponent();
        mmGraphComponent parentGraphComp = parentMapEditorComponent.getGraphComponent();
        ThemeSettings parentTheme = parentGraphComp.getThemeSettings();
        childGraphComp.getThemeSettings().populateSettingsWithNewTheme(parentTheme.getPresetThemeId(), parentTheme.getColorOption(), parentTheme.getGraphicsOption(), parentTheme.getLayoutOption(), parentTheme.getFontOption());
        ((mmGraph)childGraphComp.getGraph()).getLayoutSettings().apply(((mmGraph)parentGraphComp.getGraph()).getLayoutSettings());
        childGraphComp.setControlsVisible(parentGraphComp.isControlsVisible());
        childGraphComp.setShowControlPoints(parentGraphComp.isShowControlPoints());
        childGraphComp.setShowAudioNotesIcon(parentGraphComp.isShowAudioNotesIcon());
        childGraphComp.setShowComments(parentGraphComp.isShowComments());
        childGraphComp.setShowFileIcon(parentGraphComp.isShowFileIcon());
        childGraphComp.setShowIcons(parentGraphComp.isShowIcon());
        childGraphComp.setShowLinkIcon(parentGraphComp.isShowLinkIcon());
        childGraphComp.setShowNotesIcon(parentGraphComp.isShowNotesIcon());
        childGraphComp.setShowTagIcons(parentGraphComp.isShowTagsIcon());
        childGraphComp.setShowOrdering(parentGraphComp.isShowOrdering());
        childGraphComp.setShowTaskIcon(parentGraphComp.isShowTaskIcon());
        childGraphComp.setShowPinnedIcons(parentGraphComp.isShowPinnedIcons());
        ((mmGraph)childGraphComp.getGraph()).setShadowsEnabled(((mmGraph)parentGraphComp.getGraph()).isShadowsEnabled());
        childMapEditorComponent.setBackgroundColor(parentMapEditorComponent.getBackgroundColor());
    }

    private String getChildSaveLocation(File parentSaveLocation, mmBranchCell branch) {
        StringBuilder builder = new StringBuilder(parentSaveLocation.getParentFile().getAbsolutePath() + File.separator);
        builder.append(this.getChildMapName(parentSaveLocation.getName(), branch));
        if (new File(builder.toString() + IMX_EXTENSION).exists()) {
            String uniquePath;
            String baseName = builder.toString();
            int count = 2;
            do {
                uniquePath = baseName + "_" + count;
                ++count;
            } while (new File(uniquePath + IMX_EXTENSION).exists());
            return uniquePath + IMX_EXTENSION;
        }
        return builder.toString() + IMX_EXTENSION;
    }

    private String getChildMapName(String parentMapName, mmBranchCell branch) {
        String lastFourCharacters;
        String parentName = parentMapName;
        if (parentName.length() >= IMX_EXTENSION.length() && (lastFourCharacters = this.getLastFourCharacters(parentName)).equalsIgnoreCase(IMX_EXTENSION)) {
            parentName = this.removeLastFourCharacters(parentName);
        }
        StringBuilder builder = new StringBuilder(parentName);
        builder.append(" - ");
        builder.append(this.getValidBranchText(PropertyUtilities.getText((mmICell)branch)));
        String returnString = builder.toString();
        if (builder.length() > 70 && (returnString = builder.substring(parentName.length() + 3, builder.length())).length() > 70) {
            returnString = returnString.substring(0, 69);
        }
        return returnString;
    }

    private String getOnlineChildMapName(IEditorComponent parentMapEditorComponent, mmBranchCell branch) {
        return this.getChildMapName(parentMapEditorComponent.getTabName(), branch);
    }

    private String getValidBranchText(String branchText) {
        String validText;
        if (branchText == null || "".equals(branchText)) {
            validText = this.i18n.getLocalizedText("com.thinkbuzan.i18n.common.childMap");
        } else {
            validText = branchText.replaceAll(ILLEGAL_CHARACTERS, "");
            if ("".equals(validText)) {
                validText = this.i18n.getLocalizedText("com.thinkbuzan.i18n.common.childMap");
            }
        }
        return validText;
    }

    private String removeLastFourCharacters(String string) {
        return string.substring(0, string.length() - IMX_EXTENSION.length());
    }

    private String getLastFourCharacters(String string) {
        return string.substring(string.length() - IMX_EXTENSION.length(), string.length());
    }

    public void systemStateChanged(ISystemState systemState) {
    }

    private mmFloatingIdeaCell insertFloatingIdea(IEditorComponent parentMapEditorComponent, mmBranchCell structure, IEditorComponent childMapEditorComponent) {
        mmFloatingIdeaCell idea;
        MindMapImage image = this.getChildMapImage(parentMapEditorComponent.getGraphComponent(), structure);
        if (image == null) {
            idea = (mmFloatingIdeaCell)childMapEditorComponent.runAction((AbstractEditorAction)new AddFloatingIdeaAction());
        } else {
            String text = PropertyUtilities.getText((mmICell)structure);
            idea = (mmFloatingIdeaCell)childMapEditorComponent.runAction((AbstractEditorAction)new AddFloatingIdeaAction(text, image));
        }
        try {
            idea.setValue(PropertyUtilities.getCellProperties((mmICell)structure).clone());
        }
        catch (CloneNotSupportedException e) {
            LOGGER.error((Object)"Couldn't clone CellProperties", (Throwable)e);
        }
        return idea;
    }

    private MindMapImage getChildMapImage(mmGraphComponent graphComponent, mmBranchCell branch) {
        Object delagate = branch.getBoxBranch() == null ? branch : branch.getBoxBranch();
        MindMapImage image = null;
        for (int count = 0; count < delagate.getChildCount(); ++count) {
            mxICell child = delagate.getChildAt(count);
            if (!(child instanceof mmImageCell) || child instanceof mmPluginCell) continue;
            image = mmUtils.getMindMapImageFromImageCell((mmGraphComponent)graphComponent, (mmImageCell)((mmImageCell)child));
            break;
        }
        if (image == null) {
            try {
                InputStream inputStream = ResourceManager.getInputStream("childmm_2.png");
                image = new MindMapImage(inputStream, 250.0, 143.0);
            }
            catch (IllegalArgumentException exc) {
                LOGGER.warn((Object)("Could not get default child map image!" + exc));
                image = null;
            }
        }
        return image;
    }

    private void populateChildMap(IEditorComponent parentMapEditorComponent, mmBranchCell structure, IEditorComponent childMapEditorComponent, mmFloatingIdeaCell idea) {
        mmGraphTransferable transferable = new mmGraphTransferable(parentMapEditorComponent.getGraphComponent(), structure.getChildStructures().toArray());
        transferable.setEditorId(parentMapEditorComponent.getId());
        parentMapEditorComponent.getGraphComponent().getDndHandler().cloneCellsInTransferable(transferable);
        childMapEditorComponent.getGraphComponent().getDndHandler().pasteFromTransferable(transferable, (mmIStructureCell)idea);
        if (structure.isCollapsed() || structure.isCollapsedBranch()) {
            mmGraph childGraph = (mmGraph)childMapEditorComponent.getGraphComponent().getGraph();
            for (Object cell : childGraph.getSubtree((Object)idea)) {
                if (cell instanceof mmBranchCell) {
                    ((mmBranchCell)cell).setVisible(true);
                    ((mmBranchCell)cell).setCollapsedBranch(false);
                    childGraph.branchFolded(cell, false);
                    continue;
                }
                if (cell instanceof mxICell) {
                    ((mxICell)cell).setVisible(true);
                    continue;
                }
                LOGGER.warn((Object)("Could not set cell to visible as its not an mxICell! cell=" + cell));
            }
        }
        ArrayList<mmFloatingIdeaCell> ideaList = new ArrayList<mmFloatingIdeaCell>();
        ideaList.add(idea);
        childMapEditorComponent.setSelectionCells(ideaList);
    }
}

