/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.actions;

import com.buzanonline.chaos.systemstate.ISystemState;
import com.mxgraph.mindmap.model.mmCell;
import com.mxgraph.mindmap.model.mmIStructureCell;
import com.thinkbuzan.chaos.osgiutilities.service.OSGiService;
import com.thinkbuzan.gaia.action.AbstractOSGiAction;
import com.thinkbuzan.gaia.action.OSGiManager;
import com.thinkbuzan.gaia.editor.EditorManager;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.editor.actions.AbstractEditorAction;
import com.thinkbuzan.gaia.editor.actions.RemoveCellAndSubTreeAction;
import com.thinkbuzan.gaia.editor.actionsupport.SelectionSupport;
import com.thinkbuzan.gaia.editor.actionsupport.ViewTypeSupport;
import com.thinkbuzan.gaia.editor.listeners.EditorListener;
import com.thinkbuzan.pascal.services.editor.SketchModeListener;
import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteAction
extends AbstractOSGiAction
implements SketchModeListener {
    private final transient SelectionSupport selectionSupport;
    private IEditorComponent currentEditor;

    public DeleteAction(BundleContext context) {
        super(context);
        this.changeState(false);
        this.selectionSupport = new SelectionSupport(context){

            public void updateState(IEditorComponent editorComponent, List<mmCell> selectionCells) {
                boolean enabled = DeleteAction.this.isEnabled(editorComponent, selectionCells);
                DeleteAction.this.changeState(enabled);
            }
        };
        OSGiService editorManagerService = new OSGiService(context, EditorManager.class);
        ((EditorManager)editorManagerService.get()).addEditorListener(new EditorListener(){

            public void editorChanged(IEditorComponent editor) {
                DeleteAction.this.editorChangedImpl(editor);
            }
        });
        editorManagerService.close();
    }

    private void editorChangedImpl(IEditorComponent editor) {
        if (editor == null) {
            this.changeState(false);
        } else {
            this.changeState(editor.getGraphComponent().getSketchHandler() != null && editor.getGraphComponent().getSketchHandler().isEnabled());
        }
        if (this.currentEditor != null) {
            this.currentEditor.removeSketchModeListener((SketchModeListener)this);
        }
        this.currentEditor = editor;
        if (this.currentEditor != null) {
            this.currentEditor.addSketchModeListener((SketchModeListener)this);
        }
    }

    private boolean isEnabled(IEditorComponent editorComponent, List<mmCell> selectionCells) {
        return editorComponent != null && (selectionCells.size() > 0 || editorComponent.getGraphComponent().getSketchHandler().isEnabled() || ViewTypeSupport.TIMELINE_VIEW.equalsIgnoreCase(editorComponent.getView().getId()));
    }

    public final String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public final void runAction(Object ... parameters) {
        List selectionCells = this.selectionSupport.getCurrentEditor().getAllSelectionCells();
        if (this.isEnabled(this.selectionSupport.getCurrentEditor(), selectionCells)) {
            if ("com.thinkbuzan.orion.view.TimelineView".equalsIgnoreCase(this.selectionSupport.getCurrentEditor().getView().getId())) {
                OSGiManager.getActionManager().runAction("com.thinkbuzan.orion.timeline.actions.DeleteAction", parameters);
            } else if (this.selectionSupport.getCurrentEditor().getGraphComponent().getSketchHandler().isEnabled()) {
                this.selectionSupport.getCurrentEditor().getGraphComponent().getSketchHandler().doDelete();
            } else {
                this.selectionSupport.getCurrentEditor().runSingleAction((AbstractEditorAction)new RemoveCellAndSubTreeAction(selectionCells.toArray()));
                if (selectionCells.size() == 1 && selectionCells.get(0) instanceof mmIStructureCell) {
                    mmIStructureCell parent = ((mmIStructureCell)selectionCells.get(0)).getParentStructure();
                    ArrayList<mmIStructureCell> parentAsList = new ArrayList<mmIStructureCell>();
                    parentAsList.add(parent);
                    this.selectionSupport.getCurrentEditor().setSelectionCells(parentAsList);
                }
            }
        }
    }

    public final void systemStateChanged(ISystemState systemState) {
    }

    public final void sketchToolStateChanged(boolean enabled) {
        if (enabled) {
            this.changeState(enabled);
        } else {
            this.changeState(this.isEnabled(this.currentEditor, this.currentEditor.getAllSelectionCells()));
        }
    }
}

