/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.actions;

import com.buzanonline.chaos.systemstate.ISystemState;
import com.mxgraph.mindmap.model.mmBranchCell;
import com.mxgraph.mindmap.model.mmCell;
import com.mxgraph.mindmap.model.mmIStructureCell;
import com.thinkbuzan.chaos.osgiutilities.service.OSGiService;
import com.thinkbuzan.gaia.action.AbstractOSGiAction;
import com.thinkbuzan.gaia.editor.EditorManager;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.editor.actions.AbstractEditorAction;
import com.thinkbuzan.gaia.editor.actions.RemoveCellAndAdoptSubtreeAction;
import com.thinkbuzan.gaia.editor.actionsupport.SelectionSupport;
import com.thinkbuzan.gaia.editor.listeners.EditorListener;
import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteKeepChildrenAction
extends AbstractOSGiAction {
    private final transient SelectionSupport selectionSupport;

    public DeleteKeepChildrenAction(BundleContext context) {
        super(context);
        this.changeState(false);
        this.selectionSupport = new SelectionSupport(context){

            public void updateState(IEditorComponent editorComponent, List<mmCell> selectionCells) {
                boolean enabled = DeleteKeepChildrenAction.this.isEnabled(editorComponent, selectionCells);
                DeleteKeepChildrenAction.this.changeState(enabled);
            }
        };
        OSGiService editorManagerService = new OSGiService(context, EditorManager.class);
        ((EditorManager)editorManagerService.get()).addEditorListener(new EditorListener(){

            public void editorChanged(IEditorComponent editor) {
                DeleteKeepChildrenAction.this.editorChangedImpl(editor);
            }
        });
        editorManagerService.close();
    }

    private void editorChangedImpl(IEditorComponent editor) {
        this.changeState(editor != null);
    }

    private boolean isEnabled(IEditorComponent editorComponent, List<mmCell> selectionCells) {
        return editorComponent != null && !editorComponent.getGraphComponent().getSketchHandler().isEnabled() && selectionCells.size() == 1 && selectionCells.get(0) instanceof mmBranchCell && !((mmBranchCell)selectionCells.get(0)).getChildStructures().isEmpty();
    }

    public final String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public final void runAction(Object ... parameters) {
        List selectionCells = this.selectionSupport.getCurrentEditor().getAllSelectionCells();
        if (this.isEnabled(this.selectionSupport.getCurrentEditor(), selectionCells)) {
            this.selectionSupport.getCurrentEditor().runSingleAction((AbstractEditorAction)new RemoveCellAndAdoptSubtreeAction(selectionCells.get(0)));
            mmIStructureCell parent = ((mmIStructureCell)selectionCells.get(0)).getParentStructure();
            ArrayList<mmIStructureCell> parentAsList = new ArrayList<mmIStructureCell>();
            parentAsList.add(parent);
            this.selectionSupport.getCurrentEditor().setSelectionCells(parentAsList);
        }
    }

    public final void systemStateChanged(ISystemState systemState) {
    }
}

