/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.actions;

import com.buzanonline.chaos.action.ActionManager;
import com.buzanonline.chaos.preferences.Preferences;
import com.buzanonline.chaos.systemstate.ISystemState;
import com.jidesoft.utils.SystemInfo;
import com.mxgraph.mindmap.model.mmCell;
import com.mxgraph.mindmap.model.mmFloatingIdeaCell;
import com.thinkbuzan.apollo.dialogs.AbstractIdeaSelectorDialog;
import com.thinkbuzan.apollo.dialogs.ImageChooserDialog;
import com.thinkbuzan.apollo.dialogs.mac.imagechooser.MacCentralIdeaChooser;
import com.thinkbuzan.apollo.dialogs.mac.imagechooser.MacCentralIdeaChooserOption;
import com.thinkbuzan.apollo.dialogs.mac.imagechooser.MacCentralIdeaHelper;
import com.thinkbuzan.chaos.internationalization.I18n;
import com.thinkbuzan.chaos.osgiutilities.service.OSGiService;
import com.thinkbuzan.gaia.action.AbstractOSGiAction;
import com.thinkbuzan.gaia.action.OSGiManager;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.editor.actions.AbstractEditorAction;
import com.thinkbuzan.gaia.editor.actions.EditFloatingIdeaImageAction;
import com.thinkbuzan.gaia.editor.actionsupport.SelectionSupport;
import com.thinkbuzan.gaia.ui.MainFrameUtilities;
import com.thinkbuzan.pascal.services.editor.IdeaImage;
import com.thinkbuzan.pascal.services.editor.ideaimages.IIdeaInserter;
import com.thinkbuzan.pascal.services.editor.ideaimages.IdeaImages;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.UUID;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditCentralIdeaAction
extends AbstractOSGiAction {
    private final transient SelectionSupport selectionSupport;
    private final transient ActionManager actionManager;
    private AbstractIdeaSelectorDialog dialog;

    public EditCentralIdeaAction(BundleContext context) {
        super(context);
        OSGiService actionManagerService = new OSGiService(context, ActionManager.class);
        this.actionManager = (ActionManager)actionManagerService.get();
        this.changeState(false);
        this.selectionSupport = new SelectionSupport(context){

            public void updateState(IEditorComponent editorComponent, List<mmCell> selectionCells) {
                boolean enabled = EditCentralIdeaAction.this.isEnabled(editorComponent, selectionCells);
                EditCentralIdeaAction.this.changeState(enabled);
            }
        };
    }

    private boolean isEnabled(IEditorComponent editorComponent, List<mmCell> selectionCells) {
        return editorComponent != null && selectionCells != null && selectionCells.size() == 1 && selectionCells.get(0) instanceof mmFloatingIdeaCell;
    }

    public String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void runAction(final Object ... parameters) {
        if (SystemInfo.isAnyMac()) {
            this.dialog = new MacCentralIdeaChooser(OSGiManager.getI18n(), OSGiManager.getEditorManager(), OSGiManager.getActionManager(), OSGiManager.getPendingTdViewInterface(), false, false, false, false);
            ((MacCentralIdeaChooser)this.dialog).show(MacCentralIdeaChooserOption.NONE, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Object cell = EditCentralIdeaAction.this.getCurrentIdeaCell(parameters);
                    if (cell instanceof mmFloatingIdeaCell) {
                        UUID id = EditCentralIdeaAction.this.dialog.getSelectedIdeaId();
                        IdeaImage ideaImage = IdeaImages.getIdeaImage((UUID)id);
                        EditCentralIdeaAction.this.selectionSupport.getCurrentEditor().runSingleAction((AbstractEditorAction)new EditFloatingIdeaImageAction(new Object[]{cell, ideaImage}));
                        EditCentralIdeaAction.this.dialog.setVisible(false);
                    }
                }
            }, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Object cell;
                    Image selectedLocalImage = MacCentralIdeaHelper.pickImageFile((I18n)OSGiManager.getI18n(), (Preferences)OSGiManager.getPreferencesService().getCurrentUserPreferences());
                    if (selectedLocalImage != null && (cell = EditCentralIdeaAction.this.getCurrentIdeaCell(parameters)) instanceof mmFloatingIdeaCell) {
                        EditCentralIdeaAction.this.selectionSupport.getCurrentEditor().runSingleAction((AbstractEditorAction)new EditFloatingIdeaImageAction(new Object[]{cell, selectedLocalImage}));
                        EditCentralIdeaAction.this.dialog.setVisible(false);
                    }
                }
            });
        } else {
            this.dialog = new ImageChooserDialog(MainFrameUtilities.getMainFrame(), OSGiManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.edit"), new IIdeaInserter(){

                public void start() {
                    Object cell = EditCentralIdeaAction.this.getCurrentIdeaCell(parameters);
                    if (cell instanceof mmFloatingIdeaCell) {
                        UUID id = EditCentralIdeaAction.this.dialog.getSelectedIdeaId();
                        IdeaImage ideaImage = IdeaImages.getIdeaImage((UUID)id);
                        EditCentralIdeaAction.this.selectionSupport.getCurrentEditor().runSingleAction((AbstractEditorAction)new EditFloatingIdeaImageAction(new Object[]{cell, ideaImage}));
                        EditCentralIdeaAction.this.dialog.setVisible(false);
                    }
                }

                public void start(Image localSelected) {
                    Object cell = EditCentralIdeaAction.this.getCurrentIdeaCell(parameters);
                    if (cell instanceof mmFloatingIdeaCell) {
                        EditCentralIdeaAction.this.selectionSupport.getCurrentEditor().runSingleAction((AbstractEditorAction)new EditFloatingIdeaImageAction(new Object[]{cell, localSelected}));
                        EditCentralIdeaAction.this.dialog.setVisible(false);
                    }
                }
            }, OSGiManager.getI18n(), OSGiManager.getPreferencesService().getCurrentUserPreferences(), OSGiManager.getPendingTdViewInterface(), true);
            this.dialog.setVisible(true);
        }
    }

    public void systemStateChanged(ISystemState systemState) {
    }

    private Object getCurrentIdeaCell(Object ... parameters) {
        Object cell = null;
        cell = parameters != null && parameters.length > 0 && parameters[0] instanceof mmFloatingIdeaCell ? parameters[0] : (Object)this.selectionSupport.getSelectionCells().get(0);
        return cell;
    }
}

