/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.actions;

import com.buzanonline.chaos.systemstate.ISystemState;
import com.mxgraph.mindmap.model.mmBoundaryCell;
import com.mxgraph.mindmap.model.mmBranchCell;
import com.mxgraph.mindmap.model.mmCell;
import com.mxgraph.mindmap.model.mmIStructureCell;
import com.mxgraph.mindmap.view.mmGraph;
import com.thinkbuzan.gaia.action.AbstractOSGiAction;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.editor.actions.AbstractEditorAction;
import com.thinkbuzan.gaia.editor.actions.AddBoundaryAction;
import com.thinkbuzan.gaia.editor.actionsupport.SelectionSupport;
import com.thinkbuzan.gaia.editor.actionsupport.UndoRedoSupport;
import com.thinkbuzan.gaia.editor.actionsupport.ViewTypeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InsertBoundaryAction
extends AbstractOSGiAction {
    private final transient SelectionSupport selectionSupport;

    public InsertBoundaryAction(BundleContext contextIn) {
        super(contextIn);
        this.changeState(false);
        this.selectionSupport = new SelectionSupport(contextIn){

            public void updateState(IEditorComponent editorComponent, List<mmCell> selectionCells) {
                ArrayList<mmIStructureCell> selectionStructureCells = new ArrayList<mmIStructureCell>();
                for (mmCell selectionCell : selectionCells) {
                    if (!(selectionCell instanceof mmIStructureCell)) continue;
                    selectionStructureCells.add((mmIStructureCell)selectionCell);
                }
                boolean enabled = InsertBoundaryAction.this.isEnabled(selectionStructureCells);
                InsertBoundaryAction.this.changeState(enabled);
            }
        };
        new UndoRedoSupport(contextIn){

            public void updateState(IEditorComponent editorComponent, List<mmCell> selectionCells) {
                ArrayList<mmIStructureCell> selectionStructureCells = new ArrayList<mmIStructureCell>();
                for (mmCell selectionCell : selectionCells) {
                    if (!(selectionCell instanceof mmIStructureCell)) continue;
                    selectionStructureCells.add((mmIStructureCell)selectionCell);
                }
                boolean enabled = InsertBoundaryAction.this.isEnabled(selectionStructureCells);
                InsertBoundaryAction.this.changeState(enabled);
            }
        };
    }

    private boolean isEnabled(List<mmIStructureCell> selectionCells) {
        if (this.selectionSupport.getCurrentEditor() == null) {
            return false;
        }
        if (this.selectionSupport.getCurrentEditor().getView().getId().equals(ViewTypeSupport.BRAINSTORM_VIEW) || this.selectionSupport.getCurrentEditor().getView().getId().equals(ViewTypeSupport.FAST_CAPTURE_VIEW)) {
            return false;
        }
        mmGraph graph = (mmGraph)this.selectionSupport.getCurrentEditor().getGraphComponent().getGraph();
        Object[] selection = graph.getSelectionCells();
        if (selection == null || selection.length != 1 || selectionCells.size() != 1) {
            return false;
        }
        if (!(selection[0] instanceof mmBranchCell)) {
            return false;
        }
        Collection allBoundaries = graph.getBoundaries();
        for (Object boundary : allBoundaries) {
            if (!(boundary instanceof mmBoundaryCell)) continue;
            Set branches = ((mmBoundaryCell)boundary).getBranches();
            for (Object branch : branches) {
                for (int i = 0; i < selection.length; ++i) {
                    if (branch != selection[i]) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public final String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public final void runAction(Object ... parameters) {
        List selectionCells = this.selectionSupport.getCurrentEditor().getSelectionCells();
        if (!this.isEnabled(selectionCells)) {
            return;
        }
        selectionCells.addAll(((mmIStructureCell)selectionCells.get(0)).getDescendantsStructures());
        mmIStructureCell[] cells = new mmIStructureCell[selectionCells.size()];
        selectionCells.toArray(cells);
        List oldSelection = this.selectionSupport.getCurrentEditor().getAllSelectionCells();
        ArrayList<mmIStructureCell> old = new ArrayList<mmIStructureCell>();
        for (mmCell cell : oldSelection) {
            if (!(cell instanceof mmIStructureCell)) continue;
            old.add((mmIStructureCell)cell);
        }
        this.selectionSupport.getCurrentEditor().setSelectionCells(new ArrayList());
        this.selectionSupport.getCurrentEditor().runAction((AbstractEditorAction)new AddBoundaryAction(cells));
        this.selectionSupport.getCurrentEditor().setSelectionCells(old);
    }

    public void systemStateChanged(ISystemState systemState) {
    }
}

