/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.actions;

import com.buzanonline.chaos.systemstate.ISystemState;
import com.mxgraph.mindmap.model.mmBranchCell;
import com.mxgraph.mindmap.model.mmCell;
import com.mxgraph.mindmap.model.mmFloatingIdeaCell;
import com.mxgraph.mindmap.model.mmIStructureCell;
import com.thinkbuzan.gaia.action.AbstractOSGiAction;
import com.thinkbuzan.gaia.editor.BranchType;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.editor.actions.AbstractEditorAction;
import com.thinkbuzan.gaia.editor.actions.AddBranchAfterAction;
import com.thinkbuzan.gaia.editor.actionsupport.SelectionSupport;
import com.thinkbuzan.gaia.editor.actionsupport.ViewTypeSupport;
import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InsertBranchAfterAction
extends AbstractOSGiAction {
    private final transient SelectionSupport selectionSupport;
    private final transient BranchType branchType;

    public InsertBranchAfterAction(BundleContext context, BranchType branchTypeIn) {
        super(context);
        this.branchType = branchTypeIn;
        this.changeState(false);
        this.selectionSupport = new SelectionSupport(context){

            public void updateState(IEditorComponent editorComponent, List<mmCell> selectionCells) {
                ArrayList<mmIStructureCell> selectionStructureCells = new ArrayList<mmIStructureCell>();
                for (mmCell selectionCell : selectionCells) {
                    if (!(selectionCell instanceof mmIStructureCell)) continue;
                    selectionStructureCells.add((mmIStructureCell)selectionCell);
                }
                boolean enabled = InsertBranchAfterAction.this.isEnabled(selectionStructureCells, editorComponent);
                InsertBranchAfterAction.this.changeState(enabled);
            }
        };
    }

    public InsertBranchAfterAction(BundleContext context) {
        this(context, BranchType.BRANCH);
    }

    private boolean isEnabled(List<mmIStructureCell> selectionCells, IEditorComponent editorComponent) {
        if (editorComponent == null || editorComponent.getView() == null || editorComponent.getView().getId().equals(ViewTypeSupport.FAST_CAPTURE_VIEW)) {
            return false;
        }
        boolean enabled = selectionCells.size() != 1 ? false : selectionCells.get(0) instanceof mmBranchCell || selectionCells.get(0) instanceof mmFloatingIdeaCell;
        return enabled;
    }

    public String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public final void runAction(Object ... parameters) {
        this.validateRunAction(parameters);
        List selectionCells = this.selectionSupport.getCurrentEditor().getSelectionCells();
        if (this.isEnabled(selectionCells, this.selectionSupport.getCurrentEditor())) {
            BranchType type = parameters.length > 0 ? (BranchType)parameters[0] : (this.branchType == null ? BranchType.BRANCH : this.branchType);
            mmIStructureCell newCell = (mmIStructureCell)this.selectionSupport.getCurrentEditor().runAction((AbstractEditorAction)new AddBranchAfterAction((mmIStructureCell)selectionCells.get(0), type));
            ArrayList<mmIStructureCell> newSelection = new ArrayList<mmIStructureCell>();
            newSelection.add(newCell);
            this.selectionSupport.getCurrentEditor().setSelectionCells(newSelection);
        }
    }

    private void validateRunAction(Object ... parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException("parameters must not be null");
        }
        if (parameters.length != 0 && parameters.length != 1) {
            throw new IllegalArgumentException("parameters.length must be 0 or 1");
        }
        if (parameters.length == 1 && !(parameters[0] instanceof BranchType)) {
            throw new IllegalArgumentException("If parameters.length is 1, parameters[0] must be a BranchType");
        }
    }

    public final void systemStateChanged(ISystemState systemState) {
    }
}

