/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.actions;

import com.buzanonline.chaos.systemstate.ISystemState;
import com.mxgraph.mindmap.model.mmBranchBoxCell;
import com.mxgraph.mindmap.model.mmBranchCell;
import com.mxgraph.mindmap.model.mmCell;
import com.mxgraph.mindmap.model.mmFloatingIdeaCell;
import com.mxgraph.mindmap.model.mmICell;
import com.mxgraph.mindmap.model.mmIStructureCell;
import com.mxgraph.mindmap.model.mmImageCell;
import com.mxgraph.mindmap.util.mmUtils;
import com.mxgraph.model.mxGeometry;
import com.thinkbuzan.gaia.action.AbstractOSGiAction;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.editor.actions.AbstractEditorAction;
import com.thinkbuzan.gaia.editor.actions.AddFloatingImageAction;
import com.thinkbuzan.gaia.editor.actions.AddImageAction;
import com.thinkbuzan.gaia.editor.actions.BeginModelUpdateAction;
import com.thinkbuzan.gaia.editor.actions.EndModelUpdateAction;
import com.thinkbuzan.gaia.editor.actions.SetPropertyAction;
import com.thinkbuzan.gaia.editor.actionsupport.SelectionSupport;
import com.thinkbuzan.gaia.entities.MindMapImage;
import java.awt.geom.Point2D;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InsertImageAction
extends AbstractOSGiAction {
    private final transient SelectionSupport support = new SelectionSupport(this.getBundleContext()){

        public void updateState(IEditorComponent editorComponent, List<mmCell> selectionCells) {
            ArrayList<mmIStructureCell> selectionStructureCells = new ArrayList<mmIStructureCell>();
            for (mmCell selectionCell : selectionCells) {
                if (!(selectionCell instanceof mmIStructureCell)) continue;
                selectionStructureCells.add((mmIStructureCell)selectionCell);
            }
            InsertImageAction.this.changeState(InsertImageAction.this.isEnabled(editorComponent, selectionStructureCells));
        }
    };
    private static final transient Logger LOGGER = Logger.getLogger(InsertImageAction.class);

    public InsertImageAction(BundleContext context) {
        super(context);
        this.changeState(this.isEnabled(this.support.getCurrentEditor(), this.support.getSelectionCells()));
    }

    private boolean isEnabled(IEditorComponent editorComponent, List<mmIStructureCell> selectionCells) {
        boolean enabled = false;
        if (editorComponent != null && selectionCells != null) {
            if (selectionCells.size() == 0) {
                enabled = true;
            } else if (selectionCells.size() == 1 && this.isCellTypeValid(selectionCells.get(0))) {
                enabled = true;
            }
        }
        return enabled;
    }

    private boolean isCellTypeValid(mmIStructureCell cell) {
        boolean valid = false;
        if (cell instanceof mmBranchCell || cell instanceof mmBranchBoxCell || cell instanceof mmFloatingIdeaCell) {
            valid = true;
        }
        return valid;
    }

    public final String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public final void runAction(Object ... parameters) {
        ArrayList<mmIStructureCell> selectionCells;
        boolean isCIPickerShowing;
        MindMapImage mindMapImage = (MindMapImage)parameters[0];
        UUID imageId = parameters.length > 1 && parameters[1] instanceof UUID ? (UUID)parameters[1] : null;
        IEditorComponent editorComponent = this.support.getCurrentEditor();
        if (editorComponent == null) {
            return;
        }
        boolean bl = isCIPickerShowing = editorComponent.getImageChooserManager() != null && editorComponent.getImageChooserManager().isShowing();
        if (isCIPickerShowing) {
            selectionCells = new ArrayList<mmIStructureCell>(1);
            selectionCells.add((mmIStructureCell)editorComponent.getImageChooserManager().getFloatingIdea());
        } else {
            selectionCells = editorComponent.getSelectionCells();
        }
        if (!this.isEnabled(editorComponent, selectionCells)) {
            LOGGER.error((Object)String.format("The \"%s\" action should not be run when it is disabled", this.getId()));
            return;
        }
        if (selectionCells.size() == 0) {
            InputStream inputStream = mindMapImage.getImageStream();
            Point2D imageInsertSize = mmUtils.calculateCentralIdeaImageInsertSize((double)mindMapImage.getWidth(), (double)mindMapImage.getHeight());
            mxGeometry geometry = new mxGeometry(0.0, 0.0, imageInsertSize.getX(), imageInsertSize.getY());
            editorComponent.runAction((AbstractEditorAction)new BeginModelUpdateAction());
            mmImageCell imageCell = (mmImageCell)editorComponent.runAction((AbstractEditorAction)new AddFloatingImageAction(inputStream, geometry.getRectangle()));
            if (imageId != null) {
                String propertyKey = "com.thinkbuzan.phoenix.imageId";
                String propertyValue = imageId.toString();
                editorComponent.runAction((AbstractEditorAction)new SetPropertyAction((mmICell)imageCell, "com.thinkbuzan.phoenix.imageId", propertyValue));
            }
            editorComponent.runAction((AbstractEditorAction)new EndModelUpdateAction());
        } else {
            mmIStructureCell selectedStructure = (mmIStructureCell)selectionCells.get(0);
            if (selectedStructure instanceof mmBranchCell || selectedStructure instanceof mmBranchBoxCell || selectedStructure instanceof mmFloatingIdeaCell) {
                InputStream inputStream = mindMapImage.getImageStream();
                Point2D imageInsertSize = mmUtils.calculateImageInsertSize((mmICell)selectedStructure, (MindMapImage)mindMapImage);
                mxGeometry geometry = new mxGeometry(0.8, imageInsertSize.getY() / 2.0 + mmUtils.getImageInsertYOffest((mmICell)selectedStructure), mindMapImage.getWidth(), mindMapImage.getHeight());
                editorComponent.runAction((AbstractEditorAction)new BeginModelUpdateAction());
                mmICell imageCell = (mmICell)editorComponent.runAction((AbstractEditorAction)new AddImageAction(selectedStructure, geometry, inputStream));
                if (imageId != null) {
                    String propertyKey = selectedStructure instanceof mmFloatingIdeaCell ? "com.thinkbuzan.phoenix.centralIdeaImageId" : "com.thinkbuzan.phoenix.imageId";
                    String propertyValue = imageId.toString();
                    editorComponent.runAction((AbstractEditorAction)new SetPropertyAction(imageCell, propertyKey, propertyValue));
                }
                editorComponent.runAction((AbstractEditorAction)new EndModelUpdateAction());
            }
        }
        if (isCIPickerShowing) {
            editorComponent.getImageChooserManager().close(true);
        }
    }

    public void systemStateChanged(ISystemState systemState) {
    }
}

