/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.actions;

import com.buzanonline.chaos.systemstate.ISystemState;
import com.mxgraph.mindmap.model.mmBranchBoxCell;
import com.mxgraph.mindmap.model.mmBranchCell;
import com.mxgraph.mindmap.model.mmCell;
import com.mxgraph.mindmap.model.mmFloatingIdeaCell;
import com.thinkbuzan.chaos.osgiutilities.service.IServiceListener;
import com.thinkbuzan.chaos.osgiutilities.service.OSGiService;
import com.thinkbuzan.chaos.osgiutilities.service.ServiceAdapter;
import com.thinkbuzan.chaos.utilities.edtutilities.EDTUtilities;
import com.thinkbuzan.gaia.action.AbstractOSGiAction;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.editor.actionsupport.SelectionSupport;
import com.thinkbuzan.gaia.editor.actionsupport.ViewTypeSupport;
import com.thinkbuzan.gaia.editor.impl.ideaimagechooser.ImageChooserManager;
import com.thinkbuzan.pascal.services.images.IImageService;
import java.awt.Component;
import java.util.List;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InsertImageFromFileAction
extends AbstractOSGiAction {
    private final transient SelectionSupport selectionSupport;
    private final transient ViewTypeSupport viewSupport;
    private transient IImageService imgService;
    private transient ImageChooserManager imageChooser;

    public InsertImageFromFileAction(BundleContext context) {
        super(context);
        this.changeState(false);
        this.selectionSupport = new SelectionSupport(context){

            public void updateState(IEditorComponent editorComponent, List<mmCell> selectionCells) {
                boolean enabled = InsertImageFromFileAction.this.isEnabled(editorComponent, selectionCells);
                InsertImageFromFileAction.this.changeState(enabled);
            }
        };
        this.viewSupport = new ViewTypeSupport(context){

            public void updateState() {
                InsertImageFromFileAction.this.changeState(InsertImageFromFileAction.this.viewSupport.getViewId() != null && !InsertImageFromFileAction.this.viewSupport.getViewId().equals(ViewTypeSupport.FAST_CAPTURE_VIEW));
            }
        };
        OSGiService imageService = new OSGiService(context, IImageService.class);
        imageService.addListener((IServiceListener)new ServiceAdapter<IImageService>(){

            public void serviceAdded(IImageService service) {
                super.serviceAdded((Object)service);
                InsertImageFromFileAction.this.setImageService(service);
            }
        });
    }

    private void setImageService(final IImageService service) {
        EDTUtilities.runOnEDT((Runnable)new Runnable(){

            public void run() {
                InsertImageFromFileAction.this.imgService = service;
                IEditorComponent editor = InsertImageFromFileAction.this.selectionSupport.getCurrentEditor();
                boolean enabled = editor == null ? false : InsertImageFromFileAction.this.isEnabled(editor, editor.getAllSelectionCells());
                InsertImageFromFileAction.this.changeState(enabled);
            }
        });
    }

    private boolean isEnabled(IEditorComponent editorComp, List<mmCell> selectionCells) {
        if (this.imgService == null) {
            return false;
        }
        if (editorComp == null || editorComp.getView() == null) {
            return false;
        }
        if (editorComp.getView().getId().equals("com.thinkbuzan.phoenix.view.FastCaptureView")) {
            return false;
        }
        if (selectionCells.isEmpty()) {
            return true;
        }
        if (selectionCells.size() != 1) {
            return false;
        }
        if (selectionCells.get(0) instanceof mmBranchCell) {
            return true;
        }
        if (selectionCells.get(0) instanceof mmBranchBoxCell) {
            return true;
        }
        return selectionCells.get(0) instanceof mmFloatingIdeaCell;
    }

    public String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void runAction(Object ... parameters) {
        if (parameters != null && parameters.length > 0) {
            this.imageChooser = (ImageChooserManager)parameters[0];
        }
        EDTUtilities.runOnEDT((Runnable)new Runnable(){

            public void run() {
                InsertImageFromFileAction.this.doRunAction();
            }
        });
    }

    private void doRunAction() {
        IEditorComponent currentEditor = this.selectionSupport.getCurrentEditor();
        if (currentEditor == null) {
            return;
        }
        Object parent = this.imageChooser == null ? currentEditor.getGraphComponent() : this.imageChooser.getOverlay();
        this.imgService.getOpenImageService().insertImageFromFile((Component)parent);
        if (this.imageChooser != null) {
            this.imageChooser.close();
        }
    }

    public void systemStateChanged(ISystemState systemState) {
    }
}

