/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.actions;

import com.buzanonline.chaos.systemstate.ISystemState;
import com.mxgraph.mindmap.model.mmBranchBoxCell;
import com.mxgraph.mindmap.model.mmBranchCell;
import com.mxgraph.mindmap.model.mmCell;
import com.mxgraph.mindmap.model.mmFloatingIdeaCell;
import com.mxgraph.mindmap.model.mmICell;
import com.mxgraph.mindmap.model.mmIStructureCell;
import com.mxgraph.mindmap.util.PropertyUtilities;
import com.mxgraph.mindmap.util.ThemeSettings;
import com.mxgraph.mindmap.util.mmUtils;
import com.mxgraph.mindmap.view.mmGraph;
import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxICell;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxUtils;
import com.thinkbuzan.gaia.action.AbstractOSGiAction;
import com.thinkbuzan.gaia.editor.BranchType;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.editor.actions.AbstractEditorAction;
import com.thinkbuzan.gaia.editor.actions.AddBranchAction;
import com.thinkbuzan.gaia.editor.actions.AddImageAction;
import com.thinkbuzan.gaia.editor.actions.RunHybridFullMapLayoutAction;
import com.thinkbuzan.gaia.editor.actionsupport.SelectionSupport;
import com.thinkbuzan.gaia.entities.HTMLLabel;
import com.thinkbuzan.gaia.entities.Notes;
import com.thinkbuzan.gaia.model.properties.CellProperties;
import com.thinkbuzan.gaia.model.properties.IProperty;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.List;
import org.apache.log4j.Logger;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InsertMapPartAction
extends AbstractOSGiAction {
    private static final Logger LOGGER = Logger.getLogger(InsertMapPartAction.class);
    private final transient SelectionSupport selectionSupport;

    public InsertMapPartAction(BundleContext context) {
        super(context);
        this.changeState(false);
        this.selectionSupport = new SelectionSupport(this.getBundleContext()){

            public void updateState(IEditorComponent editorComponent, List<mmCell> selectionCells) {
                boolean enabled = InsertMapPartAction.this.isEnabled(selectionCells);
                InsertMapPartAction.this.changeState(enabled);
            }
        };
    }

    private boolean isEnabled(List<mmCell> selectionCells) {
        return !selectionCells.isEmpty();
    }

    public final String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public final void runAction(Object ... parameters) {
        List selectionCells = this.selectionSupport.getCurrentEditor().getAllSelectionCells();
        if (parameters != null && parameters.length == 2 && parameters[0] instanceof mmIStructureCell && parameters[1] instanceof String) {
            final mmGraph graph = (mmGraph)this.selectionSupport.getCurrentEditor().getGraphComponent().getGraph();
            boolean layoutOn = graph.getLayoutSettings().isLayoutOn();
            graph.getLayoutSettings().setLayoutEnabled(false);
            graph.getModel().beginUpdate();
            for (mmCell cell : selectionCells) {
                if (!(cell instanceof mmIStructureCell)) continue;
                this.insertMapPart((mmIStructureCell)cell, (mmCell)parameters[0], (String)parameters[1]);
            }
            if (layoutOn) {
                ActionListener layoutCompleteListener = new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        graph.getModel().endUpdate();
                        graph.getLayoutSettings().setLayoutEnabled(true);
                    }
                };
                this.selectionSupport.getCurrentEditor().runAction((AbstractEditorAction)new RunHybridFullMapLayoutAction(true, layoutCompleteListener, true));
            } else {
                graph.getModel().endUpdate();
            }
        }
    }

    private void insertMapPart(mmIStructureCell newRoot, mmCell oldRoot, String dataFolder) {
        boolean isRight;
        Rectangle rect;
        mmGraph graph = (mmGraph)this.selectionSupport.getCurrentEditor().getGraphComponent().getGraph();
        if (newRoot instanceof mmFloatingIdeaCell) {
            ((mmFloatingIdeaCell)newRoot).getCellLayout().setDirty(true);
            rect = (Rectangle)newRoot.getGeometry().getRectangle().clone();
        } else if (newRoot instanceof mmBranchCell) {
            ((mmBranchCell)newRoot).getCellLayout().setDirty(true);
            rect = (Rectangle)newRoot.getTerminal(false).getGeometry().getRectangle().clone();
        } else {
            rect = (Rectangle)newRoot.getGeometry().getRectangle().clone();
        }
        double rootCenterY = rect.getCenterY();
        Object connectedIdea = graph.getConnectedIdea((Object)newRoot);
        if (connectedIdea instanceof mmFloatingIdeaCell) {
            if (connectedIdea.equals(newRoot)) {
                double center = ((mmFloatingIdeaCell)connectedIdea).getGeometry().getCenterX();
                int count = 0;
                for (mmIStructureCell struct : newRoot.getVisibleChildStructures()) {
                    if (struct.getTerminal(false).getGeometry().getCenterX() > center) {
                        ++count;
                        continue;
                    }
                    --count;
                }
                isRight = count <= 0;
            } else {
                double incomingX;
                double newX;
                if (newRoot.isEdge()) {
                    newX = newRoot.getTerminal(false).getGeometry().getX();
                    incomingX = newRoot.getTerminal(true).getGeometry().getX();
                } else {
                    newX = newRoot.getGeometry().getX();
                    incomingX = ((mmFloatingIdeaCell)connectedIdea).getGeometry().getCenterX();
                }
                isRight = newX > incomingX;
            }
        } else {
            Logger.getLogger(((Object)((Object)this)).getClass()).warn((Object)"Failed to locate connected idea");
            isRight = true;
        }
        this.updateBranchAndSubtree(graph, newRoot, (mxCell)oldRoot, rect, rootCenterY, isRight, dataFolder);
    }

    private void updateBranchAndSubtree(mmGraph graph, mmIStructureCell newRoot, mxCell oldRoot, Rectangle rect, double rootCenterY, boolean isRight, String dataFolder) {
        for (int edgeIndex = 0; edgeIndex < oldRoot.getEdgeCount(); ++edgeIndex) {
            mxGeometry oldTargetGeom;
            mxGeometry oldSourceGeom;
            mxICell cell = oldRoot.getEdgeAt(edgeIndex);
            if (!(cell instanceof mmBranchCell)) continue;
            BranchType type = ((mmBranchCell)cell).getBoxBranch() == null ? BranchType.BRANCH : BranchType.BOX;
            Object insertedBranch = this.selectionSupport.getCurrentEditor().runAction((AbstractEditorAction)new AddBranchAction(newRoot, type));
            if (!(insertedBranch instanceof mmBranchCell)) continue;
            if (type == BranchType.BOX && ((mmBranchCell)cell).getBoxBranch().getEdgeCount() > 0) {
                oldSourceGeom = ((mmBranchCell)cell).getBoxBranch().getEdgeAt(0).getTerminal(true).getGeometry();
                oldTargetGeom = ((mmBranchCell)cell).getBoxBranch().getEdgeAt(0).getTerminal(false).getGeometry();
            } else {
                oldSourceGeom = ((mmBranchCell)cell).getSource().getGeometry();
                oldTargetGeom = ((mmBranchCell)cell).getTarget().getGeometry();
            }
            mxGeometry newSourceGeom = ((mmBranchCell)insertedBranch).getSource().getGeometry();
            mxGeometry newTargetGeom = (mxGeometry)((mmBranchCell)insertedBranch).getTarget().getGeometry().clone();
            double diffX = Math.abs(oldTargetGeom.getX() - oldSourceGeom.getX());
            if (isRight) {
                newTargetGeom.setX(newSourceGeom.getX() + diffX);
            } else {
                newTargetGeom.setX(newSourceGeom.getX() - diffX);
            }
            newTargetGeom.setY(newSourceGeom.getY() + (oldTargetGeom.getY() - oldSourceGeom.getY()));
            graph.getModel().setGeometry((Object)((mmBranchCell)insertedBranch).getTarget(), newTargetGeom);
            ((mmBranchCell)insertedBranch).getCellLayout().setDirty(true);
            rect.add((Rectangle)((mmBranchCell)insertedBranch).getTarget().getGeometry().getRectangle().clone());
            CellProperties cellProperties = PropertyUtilities.getCellProperties((mmICell)((mmBranchCell)cell));
            CellProperties newCellProperties = new CellProperties();
            if (cellProperties != null) {
                IProperty notes;
                List links;
                Object icons = cellProperties.get("com.thinkbuzan.gaia.cell.icons");
                if (icons instanceof List && ((List)icons).size() > 0) {
                    newCellProperties.put("com.thinkbuzan.gaia.cell.icons", icons);
                }
                if ((links = PropertyUtilities.getNonChildMapLinks((mmICell)((mmBranchCell)cell))) instanceof List && links.size() > 0) {
                    newCellProperties.put("com.thinkbuzan.gaia.cell.hyperlinks", (Object)links);
                }
                if ((notes = PropertyUtilities.getProperty((mmICell)((mmBranchCell)cell), (String)"com.thinkbuzan.gaia.cell.notes", Notes.class)) instanceof Notes) {
                    newCellProperties.put("com.thinkbuzan.gaia.cell.notes", (Object)notes);
                }
                String creationOrder = "0";
                if (newRoot instanceof mmFloatingIdeaCell) {
                    creationOrder = ((mmFloatingIdeaCell)newRoot).getNextCreationIndex();
                    newCellProperties.put("com.thinkbuzan.gaia.cell.creation.order", (Object)new Integer(Integer.parseInt(creationOrder) - 1).toString());
                }
                graph.getModel().setStyle(insertedBranch, cell.getStyle());
                ThemeSettings themeSettings = this.selectionSupport.getCurrentEditor().getGraphComponent().getThemeSettings();
                String themeStyle = themeSettings.getStyleForBranch((mmBranchCell)insertedBranch);
                graph.getModel().setStyle(insertedBranch, themeStyle);
                if (((mmBranchCell)insertedBranch).getBoxBranch() == null) {
                    Object htmlText;
                    Object labelText = cellProperties.get("com.thinkbuzan.gaia.cell.text");
                    if (labelText instanceof String) {
                        newCellProperties.put("com.thinkbuzan.gaia.cell.text", labelText);
                    }
                    if ((htmlText = cellProperties.get("com.thinkbuzan.gaia.entities.HTMLLabel")) instanceof HTMLLabel) {
                        newCellProperties.put("com.thinkbuzan.gaia.entities.HTMLLabel", htmlText);
                    }
                    graph.getModel().setValue(insertedBranch, (Object)newCellProperties);
                    this.addChildImages(dataFolder, cell, (mmIStructureCell)((mmBranchCell)insertedBranch));
                } else {
                    Object htmlText;
                    graph.getModel().setValue(insertedBranch, (Object)newCellProperties);
                    CellProperties boxProperties = new CellProperties();
                    boxProperties.put("com.thinkbuzan.gaia.cell.creation.order", (Object)new Integer(Integer.parseInt(creationOrder) - 1).toString());
                    Object labelText = cellProperties.get("com.thinkbuzan.gaia.cell.text");
                    if (labelText instanceof String) {
                        boxProperties.put("com.thinkbuzan.gaia.cell.text", labelText);
                    }
                    if ((htmlText = cellProperties.get("com.thinkbuzan.gaia.entities.HTMLLabel")) instanceof HTMLLabel) {
                        boxProperties.put("com.thinkbuzan.gaia.entities.HTMLLabel", htmlText);
                    }
                    mmBranchBoxCell box = ((mmBranchCell)insertedBranch).getBoxBranch();
                    graph.getModel().setValue((Object)box, (Object)boxProperties);
                    if (((mmBranchCell)cell).getBoxBranch() != null) {
                        graph.getModel().setStyle((Object)box, ((mmBranchCell)cell).getBoxBranch().getStyle());
                    }
                    String boxStyle = themeSettings.getStyleForBoxBranch(box);
                    String boxColour = mmUtils.getStyle((String)themeStyle, (String)mxConstants.STYLE_STROKECOLOR);
                    boxStyle = mxUtils.setStyle((String)boxStyle, (String)mxConstants.STYLE_STROKECOLOR, (String)boxColour);
                    graph.getModel().setStyle((Object)box, boxStyle);
                    this.addChildImages(dataFolder, ((mmBranchCell)cell).getTarget(), (mmIStructureCell)((mmBranchCell)insertedBranch));
                }
            }
            if (((mmBranchCell)cell).getTarget().getEdgeCount() <= 0) continue;
            Rectangle targetRect = (Rectangle)((mmBranchCell)insertedBranch).getTarget().getGeometry().getRectangle().clone();
            this.updateBranchAndSubtree(graph, (mmIStructureCell)((mmBranchCell)insertedBranch), (mxCell)((mmBranchCell)cell).getTarget(), targetRect, targetRect.getCenterY(), isRight, dataFolder);
        }
        double off = rootCenterY - rect.getCenterY();
        for (mmIStructureCell cell : newRoot.getChildStructures()) {
            mxGeometry geom = cell.getTerminal(false).getGeometry();
            geom.translate(0.0, off);
            graph.getModel().setGeometry((Object)cell, geom);
        }
    }

    private void addChildImages(String dataFolder, mxICell oldCell, mmIStructureCell newCell) {
        for (int childIndex = 0; childIndex < oldCell.getChildCount(); ++childIndex) {
            mxICell child = oldCell.getChildAt(childIndex);
            if (child == null) continue;
            String imageId = mmUtils.getStyle((String)child.getStyle(), (String)mxConstants.STYLE_IMAGE);
            File imageFile = new File(dataFolder + File.separator + imageId);
            if (!imageFile.exists()) continue;
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(imageFile);
            }
            catch (FileNotFoundException exc) {
                LOGGER.warn((Object)("no child image data found for insert " + exc));
            }
            if (inputStream == null) continue;
            double height = child.getGeometry().getHeight();
            double width = child.getGeometry().getWidth();
            double xPos = 0.8;
            double yPos = -width / 2.0;
            this.selectionSupport.getCurrentEditor().runAction((AbstractEditorAction)new AddImageAction(newCell, 0.8, yPos, width, height, (InputStream)inputStream));
        }
    }

    public final void systemStateChanged(ISystemState systemState) {
    }
}

