/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.actions;

import com.buzanonline.chaos.systemstate.ISystemState;
import com.mxgraph.mindmap.model.mmBranchCell;
import com.mxgraph.mindmap.model.mmCell;
import com.mxgraph.mindmap.model.mmIStructureCell;
import com.thinkbuzan.gaia.action.AbstractOSGiAction;
import com.thinkbuzan.gaia.action.OSGiManager;
import com.thinkbuzan.gaia.editor.BranchType;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.editor.actions.AbstractEditorAction;
import com.thinkbuzan.gaia.editor.actions.AddBranchAction;
import com.thinkbuzan.gaia.editor.actions.SetSelectionAction;
import com.thinkbuzan.gaia.editor.actionsupport.SelectionSupport;
import com.thinkbuzan.gaia.editor.actionsupport.ViewTypeSupport;
import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InsertNewBranchAction
extends AbstractOSGiAction {
    private final transient SelectionSupport selectionSupport;
    private final transient BranchType branchType;

    public InsertNewBranchAction(BundleContext context) {
        this(context, BranchType.BRANCH);
    }

    public InsertNewBranchAction(BundleContext context, BranchType branchTypeIn) {
        super(context);
        this.branchType = branchTypeIn;
        this.changeState(false);
        this.selectionSupport = new SelectionSupport(context){

            public void updateState(IEditorComponent editorComponent, List<mmCell> selectionCells) {
                ArrayList<mmIStructureCell> selectionStructureCells = new ArrayList<mmIStructureCell>();
                for (mmCell selectionCell : selectionCells) {
                    if (!(selectionCell instanceof mmIStructureCell)) continue;
                    selectionStructureCells.add((mmIStructureCell)selectionCell);
                }
                boolean enabled = InsertNewBranchAction.this.isEnabled(selectionStructureCells, editorComponent);
                InsertNewBranchAction.this.changeState(enabled);
            }
        };
    }

    private boolean isEnabled(List<mmIStructureCell> selectionCells, IEditorComponent editorComponent) {
        if (editorComponent == null || editorComponent.getView() == null) {
            return false;
        }
        return selectionCells.size() == 1;
    }

    public String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public final void runAction(Object ... parameters) {
        mmBranchCell newBranch;
        mmIStructureCell parent;
        this.validateRunAction(parameters);
        List selectionCells = this.selectionSupport.getCurrentEditor().getSelectionCells();
        if (!this.isEnabled(selectionCells, this.selectionSupport.getCurrentEditor())) {
            throw new IllegalStateException("The action can only be run when it is enabled");
        }
        ArrayList<Object> newSelection = new ArrayList<Object>();
        if (ViewTypeSupport.BRAINSTORM_VIEW.equalsIgnoreCase(this.selectionSupport.getCurrentEditor().getView().getId())) {
            if (BranchType.BOX == this.branchType) {
                newSelection.add(((mmIStructureCell)selectionCells.get(0)).getParentStructure());
                this.selectionSupport.getCurrentEditor().setSelectionCells(newSelection);
                OSGiManager.getActionManager().runAction("com.thinkbuzan.gaia.actions.InsertSiblingAction", new Object[0]);
                return;
            }
            OSGiManager.getActionManager().runAction("com.thinkbuzan.apollo.brainstorm.actions.ConvertIdeaToGroupAction", new Object[0]);
            parent = (mmIStructureCell)selectionCells.get(0);
        } else {
            if (ViewTypeSupport.TIMELINE_VIEW.equalsIgnoreCase(this.selectionSupport.getCurrentEditor().getView().getId())) {
                OSGiManager.getActionManager().runAction("com.thinkbuzan.orion.timeline.actions.AddTaskAction", new Object[0]);
                return;
            }
            parent = (mmIStructureCell)selectionCells.get(0);
        }
        if (parameters != null && parameters.length == 1 && parameters[0] instanceof Boolean) {
            boolean isRight = (Boolean)parameters[0];
            newBranch = (mmBranchCell)this.selectionSupport.getCurrentEditor().runAction((AbstractEditorAction)new AddBranchAction(parent, this.branchType, isRight));
        } else {
            newBranch = (mmBranchCell)this.selectionSupport.getCurrentEditor().runAction((AbstractEditorAction)new AddBranchAction(parent, this.branchType));
        }
        newSelection.add(newBranch);
        this.selectionSupport.getCurrentEditor().setSelectionCells(newSelection);
        if (ViewTypeSupport.BRAINSTORM_VIEW.equalsIgnoreCase(this.selectionSupport.getCurrentEditor().getView().getId())) {
            this.selectionSupport.getCurrentEditor().runSingleAction((AbstractEditorAction)new SetSelectionAction((Object)newBranch));
            OSGiManager.getActionManager().runAction("com.thinkbuzan.apollo.brainstorm.actions.ForceEditAction", new Object[]{newBranch});
        }
    }

    private void validateRunAction(Object ... parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException("parameters must not be null");
        }
        if (parameters.length > 1) {
            throw new IllegalArgumentException("no more than one parameter can be passed ");
        }
    }

    public final void systemStateChanged(ISystemState systemState) {
    }
}

