/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.actions;

import com.buzanonline.chaos.systemstate.ISystemState;
import com.mxgraph.mindmap.model.mmBranchCell;
import com.mxgraph.mindmap.model.mmCell;
import com.mxgraph.mindmap.model.mmFloatingIdeaCell;
import com.mxgraph.mindmap.model.mmImageCell;
import com.thinkbuzan.gaia.action.AbstractOSGiAction;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.editor.actionsupport.SelectionSupport;
import com.thinkbuzan.gaia.editor.actionsupport.ViewTypeSupport;
import java.util.List;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InsertSketchAction
extends AbstractOSGiAction {
    public static final String INSERT_SKETCH_ACTION_ID = "com.thinkbuzan.gaia.actions.InsertSketchAction";
    private final transient ViewTypeSupport viewTypeSupport;
    private final transient SelectionSupport selectionSupport;

    public InsertSketchAction(BundleContext contextIn) {
        super(contextIn);
        this.changeState(false);
        this.selectionSupport = new SelectionSupport(this.getBundleContext()){

            public void updateState(IEditorComponent editorComponent, List<mmCell> selectionCells) {
                boolean enabled = InsertSketchAction.this.isEnabled(selectionCells);
                InsertSketchAction.this.changeState(enabled);
            }
        };
        this.viewTypeSupport = new ViewTypeSupport(contextIn){

            public void updateState() {
                InsertSketchAction.this.updateActionState();
            }
        };
    }

    public String getId() {
        return INSERT_SKETCH_ACTION_ID;
    }

    public void runAction(Object ... parameters) {
        IEditorComponent currentEditor = this.selectionSupport.getCurrentEditor();
        if (currentEditor == null) {
            return;
        }
        List allSelectionCells = currentEditor.getAllSelectionCells();
        if (!this.isEnabled(allSelectionCells)) {
            throw new IllegalStateException("The action can only be run when it is enabled");
        }
        currentEditor.setSketchModeEnabledState(!currentEditor.getGraphComponent().getSketchHandler().isEnabled());
    }

    private boolean isEnabled(List<mmCell> selectionCells) {
        boolean doEnable = false;
        for (mmCell cell : selectionCells) {
            if (!(cell instanceof mmImageCell) && !(cell instanceof mmBranchCell) && !(cell instanceof mmFloatingIdeaCell)) continue;
            doEnable = true;
            break;
        }
        boolean validView = ViewTypeSupport.MIND_MAP_VIEW_ID.equals(this.viewTypeSupport.getViewId()) || ViewTypeSupport.PROJECT_MANAGEMENT_VIEW_ID.equals(this.viewTypeSupport.getViewId());
        return validView && (doEnable || selectionCells.isEmpty());
    }

    private void updateActionState() {
        boolean view2D = ViewTypeSupport.MIND_MAP_VIEW_ID.equals(this.viewTypeSupport.getViewId());
        this.changeState(view2D);
        IEditorComponent editor = this.selectionSupport.getCurrentEditor();
        if (!view2D && editor != null && editor.getGraphComponent() != null && editor.getGraphComponent().getSketchHandler().isEnabled()) {
            editor.setSketchModeEnabledState(false);
        }
    }

    public void systemStateChanged(ISystemState systemState) {
    }
}

