/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.actions;

import com.buzanonline.chaos.systemstate.ISystemState;
import com.mxgraph.mindmap.model.mmFloatingIdeaCell;
import com.mxgraph.mindmap.model.mmGraphModel;
import com.mxgraph.mindmap.model.mmICell;
import com.mxgraph.mindmap.view.mmGraph;
import com.mxgraph.model.mxIGraphModel;
import com.thinkbuzan.chaos.internationalization.I18n;
import com.thinkbuzan.chaos.osgiutilities.service.OSGiService;
import com.thinkbuzan.gaia.action.AbstractOSGiAction;
import com.thinkbuzan.gaia.editor.EditorManager;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.editor.actions.AbstractEditorAction;
import com.thinkbuzan.gaia.editor.actions.AddFloatingIdeaAction;
import com.thinkbuzan.gaia.editor.actions.ScrollToPositionAction;
import com.thinkbuzan.gaia.editor.actions.SetPropertyAction;
import com.thinkbuzan.gaia.entities.MindMapImage;
import com.thinkbuzan.pascal.services.editor.IdeaImage;
import com.thinkbuzan.pascal.services.editor.ideaimages.IdeaImages;
import java.awt.Dimension;
import java.awt.Point;
import java.io.InputStream;
import java.util.UUID;
import javax.swing.SwingUtilities;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class NewAction
extends AbstractOSGiAction {
    final I18n i18nService;

    public NewAction(BundleContext context) {
        super(context);
        OSGiService i18nService = new OSGiService(context, I18n.class);
        this.i18nService = (I18n)i18nService.get();
    }

    public final String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void runAction(Object ... parameters) {
        IEditorComponent component;
        boolean hiddenEditorComponent = false;
        String ideaText = this.i18nService.getLocalizedText("com.thinkbuzan.i18n.common.floatingIdea");
        UUID ideaId = null;
        if (parameters.length > 0) {
            hiddenEditorComponent = (Boolean)parameters[0];
            ideaText = (String)parameters[1];
            if (parameters.length == 3 && parameters[2] instanceof UUID) {
                ideaId = (UUID)parameters[2];
            }
        }
        EditorManager editorManager = this.getEditorManager();
        if (hiddenEditorComponent) {
            mmGraph graph = new mmGraph((mxIGraphModel)new mmGraphModel());
            UUID id = editorManager.createEditorComponent(graph, false, false);
            component = editorManager.getEditorComponent(id);
        } else {
            component = editorManager.createEditorComponent();
        }
        component.beginUpdate();
        try {
            component.getGraphComponent().getGraphControl().updatePreferredSize();
            AddFloatingIdeaAction addFloatingIdeaAction = null;
            if (!hiddenEditorComponent) {
                addFloatingIdeaAction = new AddFloatingIdeaAction(this.i18nService.getLocalizedText("com.thinkbuzan.i18n.common.floatingIdea"));
                addFloatingIdeaAction.setShowImageChooser(true);
                addFloatingIdeaAction.setImageChooserClearUndoManager(true);
                addFloatingIdeaAction.setImageChooserExitButtonClosesMap(true);
            } else if (ideaId != null) {
                IdeaImage ideaImage = IdeaImages.getIdeaImage(ideaId);
                Dimension size = IdeaImages.getSize((IdeaImage)ideaImage);
                InputStream ideaStream = IdeaImages.getInputStream((IdeaImage)ideaImage);
                MindMapImage mmi = new MindMapImage(ideaStream, size.getWidth(), size.getHeight());
                addFloatingIdeaAction = new AddFloatingIdeaAction(ideaText, mmi);
            }
            if (addFloatingIdeaAction != null) {
                mmFloatingIdeaCell floatingIdea = (mmFloatingIdeaCell)component.runAction(addFloatingIdeaAction);
                mmGraph graph = (mmGraph)component.getGraphComponent().getGraph();
                final int centreX = (int)graph.getMinimumGraphSize().getCenterX();
                final int centreY = (int)graph.getMinimumGraphSize().getCenterY();
                graph.centerCells();
                floatingIdea.getGeometry().setX((double)centreX - floatingIdea.getGeometry().getWidth());
                floatingIdea.getGeometry().setY((double)centreY - floatingIdea.getGeometry().getHeight());
                graph.getModel().setGeometry((Object)floatingIdea, floatingIdea.getGeometry());
                if (ideaId != null) {
                    component.runAction((AbstractEditorAction)new SetPropertyAction((mmICell)floatingIdea, "com.thinkbuzan.phoenix.centralIdeaImageId", ideaId.toString()));
                }
                if (!hiddenEditorComponent) {
                    editorManager.switchFocusToEditorComponent(component.getId());
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            component.runAction((AbstractEditorAction)new ScrollToPositionAction(new Point(centreX, centreY)));
                        }
                    });
                }
            }
        }
        finally {
            component.endUpdate();
        }
        component.getGraphComponent().getUndoManager().clear();
    }

    public void systemStateChanged(ISystemState systemState) {
    }

    private EditorManager getEditorManager() {
        String editorManagerClassName = EditorManager.class.getName();
        ServiceReference serviceReference = this.getBundleContext().getServiceReference(editorManagerClassName);
        if (serviceReference == null) {
            throw new IllegalStateException("Could not get ServiceReference for " + editorManagerClassName);
        }
        EditorManager editorManager = (EditorManager)this.getBundleContext().getService(serviceReference);
        if (editorManager == null) {
            throw new IllegalStateException("Could not get service " + editorManagerClassName);
        }
        return editorManager;
    }
}

