/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.actions;

import com.buzanonline.chaos.action.ActionManager;
import com.buzanonline.chaos.systemstate.ISystemState;
import com.mxgraph.mindmap.model.mmFloatingIdeaCell;
import com.mxgraph.mindmap.view.mmGraph;
import com.thinkbuzan.chaos.internationalization.I18n;
import com.thinkbuzan.chaos.osgiutilities.service.OSGiService;
import com.thinkbuzan.gaia.action.AbstractOSGiAction;
import com.thinkbuzan.gaia.editor.EditorManager;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.editor.actions.AbstractEditorAction;
import com.thinkbuzan.gaia.editor.actions.AddFloatingIdeaAction;
import com.thinkbuzan.gaia.editor.actions.ScrollToPositionAction;
import java.awt.Point;
import java.util.Arrays;
import javax.swing.SwingUtilities;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class NewBrainstormAction
extends AbstractOSGiAction {
    final I18n i18nService;
    private final ActionManager actionManager;

    public NewBrainstormAction(ActionManager actionManagerIn, BundleContext context) {
        super(context);
        this.actionManager = actionManagerIn;
        OSGiService i18nService = new OSGiService(context, I18n.class);
        this.i18nService = (I18n)i18nService.get();
    }

    public final String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void runAction(Object ... parameters) {
        EditorManager editorManager = this.getEditorManager();
        final IEditorComponent component = editorManager.createEditorComponent();
        component.beginUpdate();
        try {
            component.getGraphComponent().getGraphControl().updatePreferredSize();
            AddFloatingIdeaAction addFloatingIdeaAction = new AddFloatingIdeaAction(this.i18nService.getLocalizedText("com.thinkbuzan.i18n.common.floatingIdea"));
            addFloatingIdeaAction.setShowImageChooser(true);
            addFloatingIdeaAction.setImageChooserClearUndoManager(true);
            addFloatingIdeaAction.setImageChooserExitButtonClosesMap(true);
            mmFloatingIdeaCell floatingIdea = (mmFloatingIdeaCell)component.runAction((AbstractEditorAction)addFloatingIdeaAction);
            mmGraph graph = (mmGraph)component.getGraphComponent().getGraph();
            final int centreX = (int)graph.getMinimumGraphSize().getCenterX();
            final int centreY = (int)graph.getMinimumGraphSize().getCenterY();
            graph.centerCells();
            floatingIdea.getGeometry().setX((double)centreX - floatingIdea.getGeometry().getWidth());
            floatingIdea.getGeometry().setY((double)centreY - floatingIdea.getGeometry().getHeight());
            graph.getModel().setGeometry((Object)floatingIdea, floatingIdea.getGeometry());
            editorManager.switchFocusToEditorComponent(component.getId());
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    component.runAction((AbstractEditorAction)new ScrollToPositionAction(new Point(centreX, centreY)));
                }
            });
            component.setSelectionCells(Arrays.asList(floatingIdea));
            this.actionManager.runAction("com.thinkbuzan.gaia.actions.BrainstormViewAction", parameters);
        }
        finally {
            component.endUpdate();
        }
        component.getGraphComponent().getUndoManager().clear();
    }

    public void systemStateChanged(ISystemState systemState) {
    }

    private EditorManager getEditorManager() {
        String editorManagerClassName = EditorManager.class.getName();
        ServiceReference serviceReference = this.getBundleContext().getServiceReference(editorManagerClassName);
        if (serviceReference == null) {
            throw new IllegalStateException("Could not get ServiceReference for " + editorManagerClassName);
        }
        EditorManager editorManager = (EditorManager)this.getBundleContext().getService(serviceReference);
        if (editorManager == null) {
            throw new IllegalStateException("Could not get service " + editorManagerClassName);
        }
        return editorManager;
    }
}

