/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.actions;

import com.buzanonline.chaos.systemstate.ISystemState;
import com.mxgraph.mindmap.model.mmFloatingIdeaCell;
import com.mxgraph.mindmap.model.mmICell;
import com.mxgraph.mindmap.view.mmGraph;
import com.thinkbuzan.chaos.internationalization.I18n;
import com.thinkbuzan.chaos.osgiutilities.service.OSGiService;
import com.thinkbuzan.gaia.action.AbstractOSGiAction;
import com.thinkbuzan.gaia.action.OSGiManager;
import com.thinkbuzan.gaia.editor.EditorManager;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.editor.actions.AbstractEditorAction;
import com.thinkbuzan.gaia.editor.actions.AddFloatingIdeaAction;
import com.thinkbuzan.gaia.editor.actions.ScrollToPositionAction;
import com.thinkbuzan.gaia.editor.actions.SetPropertyAction;
import com.thinkbuzan.gaia.entities.MindMapImage;
import com.thinkbuzan.pascal.services.editor.IdeaImage;
import com.thinkbuzan.pascal.services.editor.ideaimages.IdeaImages;
import java.awt.Dimension;
import java.io.InputStream;
import java.util.Arrays;
import java.util.UUID;
import javax.swing.SwingUtilities;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class NewNewAction
extends AbstractOSGiAction {
    private static final String THEME_ACTION = "com.thinkbuzan.gaia.theme.actions.SetThemeByIdAction";
    private static final String CREATIVE_THEME = "644b2a25-c97e-4cb2-8928-5cce7bba23d0";
    private static final String PRO_THEME = "f503e61f-5a7f-46b7-b94a-e05563ecc47d";
    private static final String BS_THEME = "20872e30-4e39-11e4-916c-0800200c9a66";
    private static final String FAST_CAPTURE_THEME = "FAST_CAPTURE_THEME";
    private static final String TIMELINE_THEME = "TIMELINE_THEME";
    final I18n i18nService;

    public NewNewAction(BundleContext context) {
        super(context);
        this.i18nService = (I18n)new OSGiService(context, I18n.class).get();
    }

    public final String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void runAction(Object ... parameters) {
        String ideaText = this.i18nService.getLocalizedText("com.thinkbuzan.i18n.common.floatingIdea");
        if (parameters.length >= 2) {
            UUID ideaId = (UUID)parameters[0];
            String themeId = (String)parameters[1];
            if (parameters.length == 3 && parameters[2] instanceof String) {
                ideaText = (String)parameters[2];
            }
            EditorManager editorManager = this.getEditorManager();
            final IEditorComponent component = editorManager.createEditorComponent();
            component.beginUpdate();
            try {
                mmFloatingIdeaCell floatingIdea;
                component.getGraphComponent().getGraphControl().updatePreferredSize();
                AddFloatingIdeaAction addFloatingIdeaAction = null;
                if (ideaId != null) {
                    IdeaImage ideaImage = IdeaImages.getIdeaImage((UUID)ideaId);
                    Dimension size = IdeaImages.getSize((IdeaImage)ideaImage);
                    InputStream ideaStream = IdeaImages.getInputStream((IdeaImage)ideaImage);
                    MindMapImage mmi = new MindMapImage(ideaStream, size.getWidth(), size.getHeight());
                    addFloatingIdeaAction = new AddFloatingIdeaAction(ideaText, mmi);
                }
                mmGraph graph = (mmGraph)component.getGraphComponent().getGraph();
                int centreX = (int)graph.getMinimumGraphSize().getCenterX();
                int centreY = (int)graph.getMinimumGraphSize().getCenterY();
                graph.centerCells();
                if (addFloatingIdeaAction != null) {
                    floatingIdea = (mmFloatingIdeaCell)component.runAction(addFloatingIdeaAction);
                    floatingIdea.getGeometry().setX((double)centreX - floatingIdea.getGeometry().getWidth());
                    floatingIdea.getGeometry().setY((double)centreY - floatingIdea.getGeometry().getHeight());
                    graph.getModel().setGeometry((Object)floatingIdea, floatingIdea.getGeometry());
                    if (ideaId != null) {
                        component.runAction((AbstractEditorAction)new SetPropertyAction((mmICell)floatingIdea, "com.thinkbuzan.phoenix.centralIdeaImageId", ideaId.toString()));
                    }
                } else {
                    floatingIdea = null;
                }
                if (themeId.equals(BS_THEME)) {
                    component.setSelectionCells(Arrays.asList(floatingIdea));
                    OSGiManager.getActionManager().runAction("com.thinkbuzan.gaia.actions.BrainstormViewAction", parameters);
                    component.setShowThemePrompt(true);
                } else if (themeId.equals(FAST_CAPTURE_THEME)) {
                    OSGiManager.getActionManager().runAction("com.thinkbuzan.gaia.actions.FastCaptureViewAction", parameters);
                    component.setShowThemePrompt(true);
                } else if (themeId.equalsIgnoreCase(TIMELINE_THEME)) {
                    OSGiManager.getActionManager().runAction("com.thinkbuzan.gaia.actions.TimelineViewAction", parameters);
                    component.setShowThemePrompt(true);
                } else {
                    OSGiManager.getActionManager().runAction(THEME_ACTION, new Object[]{themeId});
                    boolean pro = PRO_THEME.equalsIgnoreCase(themeId);
                    component.setGridEnabled(pro);
                }
                editorManager.switchFocusToEditorComponent(component.getId());
                if (floatingIdea != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            component.runAction((AbstractEditorAction)new ScrollToPositionAction((Object)floatingIdea, true));
                            component.setSelectionCells(Arrays.asList(floatingIdea));
                        }
                    });
                }
            }
            finally {
                component.endUpdate();
            }
            component.getGraphComponent().getUndoManager().clear();
        }
    }

    public void systemStateChanged(ISystemState systemState) {
    }

    private EditorManager getEditorManager() {
        String editorManagerClassName = EditorManager.class.getName();
        ServiceReference serviceReference = this.getBundleContext().getServiceReference(editorManagerClassName);
        if (serviceReference == null) {
            throw new IllegalStateException("Could not get ServiceReference for " + editorManagerClassName);
        }
        EditorManager editorManager = (EditorManager)this.getBundleContext().getService(serviceReference);
        if (editorManager == null) {
            throw new IllegalStateException("Could not get service " + editorManagerClassName);
        }
        return editorManager;
    }
}

