/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.actions;

import com.buzanonline.chaos.systemstate.ISystemState;
import com.thinkbuzan.chaos.osgiutilities.service.OSGiService;
import com.thinkbuzan.gaia.action.AbstractOSGiAction;
import com.thinkbuzan.gaia.editor.EditorManager;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.editor.actionsupport.ViewTypeSupport;
import com.thinkbuzan.pascal.services.presentation.undo.UndoRedoListener;
import org.osgi.framework.BundleContext;

public final class PresentationRedoAction
extends AbstractOSGiAction
implements UndoRedoListener {
    private final transient OSGiService<EditorManager> editorManagerService = new OSGiService(this.getBundleContext(), EditorManager.class);
    private final transient ViewTypeSupport viewTypeSupport;
    private transient IEditorComponent currentEditor;

    public PresentationRedoAction(BundleContext contextIn) {
        super(contextIn);
        this.changeState(false);
        this.viewTypeSupport = new ViewTypeSupport(this.getBundleContext()){

            public void updateState() {
                if (PresentationRedoAction.this.currentEditor != null && PresentationRedoAction.this.currentEditor.getPresentationUndoController() != null) {
                    PresentationRedoAction.this.currentEditor.getPresentationUndoController().removeUndoRedoListener((UndoRedoListener)PresentationRedoAction.this);
                }
                PresentationRedoAction.this.currentEditor = PresentationRedoAction.this.getCurrentEditorComponent();
                if (PresentationRedoAction.this.currentEditor != null && PresentationRedoAction.this.currentEditor.isInPresentationView() && PresentationRedoAction.this.currentEditor.getPresentationUndoController() != null) {
                    PresentationRedoAction.this.currentEditor.getPresentationUndoController().addUndoRedoListener((UndoRedoListener)PresentationRedoAction.this);
                }
                PresentationRedoAction.this.changeState(PresentationRedoAction.this.isEnabled());
            }
        };
    }

    private boolean isEnabled() {
        return this.currentEditor != null && this.currentEditor.isInPresentationView() && this.currentEditor.getPresentationUndoController() != null && this.currentEditor.getPresentationUndoController().canRedo();
    }

    private IEditorComponent getCurrentEditorComponent() {
        try {
            return ((EditorManager)this.editorManagerService.get()).getCurrentEditorComponent();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void runAction(Object ... parameters) {
        if (this.currentEditor != null && this.currentEditor.isInPresentationView() && this.currentEditor.getPresentationUndoController() != null) {
            if (!this.currentEditor.getPresentationUndoController().canRedo()) {
                throw new IllegalStateException("The action can only be run when it is enabled");
            }
            this.currentEditor.getPresentationUndoController().redo();
        }
    }

    public void systemStateChanged(ISystemState systemState) {
    }

    public void editsCleared() {
        this.changeState(this.isEnabled());
    }

    public void newEditAdded() {
        this.changeState(this.isEnabled());
    }

    public void redoPerformed() {
        this.changeState(this.isEnabled());
    }

    public void undoPerformed() {
        this.changeState(this.isEnabled());
    }
}

