/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.actions;

import com.buzanonline.chaos.systemstate.ISystemState;
import com.mxgraph.mindmap.model.mmCell;
import com.mxgraph.mindmap.model.mmFlowCell;
import com.mxgraph.mindmap.model.mmIStructureCell;
import com.mxgraph.model.mxICell;
import com.thinkbuzan.chaos.osgiutilities.service.OSGiService;
import com.thinkbuzan.gaia.action.AbstractOSGiAction;
import com.thinkbuzan.gaia.editor.EditorManager;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.editor.actions.AbstractEditorAction;
import com.thinkbuzan.gaia.editor.actionsupport.SelectionSupport;
import com.thinkbuzan.gaia.editor.listeners.EditorListener;
import com.thinkbuzan.pascal.services.editor.listeners.IViewListener;
import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectDescendantsAction
extends AbstractOSGiAction {
    private final transient SelectionSupport selectionSupport;
    private transient boolean enabled;
    private transient IEditorComponent currentEditor;
    private transient IViewListener viewListener;

    public SelectDescendantsAction(BundleContext context) {
        super(context);
        OSGiService editorManagerService = new OSGiService(context, EditorManager.class);
        EditorListener editorListener = this.createEditorListener();
        ((EditorManager)editorManagerService.get()).addEditorListener(editorListener);
        this.selectionSupport = new SelectionSupport(context){

            public void updateState(IEditorComponent editorComponent, List<mmCell> selectionCells) {
                if (editorComponent == null || editorComponent.getView() == null || editorComponent.getView().getId().equals("com.thinkbuzan.phoenix.view.FastCaptureView")) {
                    SelectDescendantsAction.this.changeState(false);
                    return;
                }
                ArrayList<mxICell> selection = new ArrayList<mxICell>();
                for (mmCell selectionCell : selectionCells) {
                    if (selectionCell instanceof mmIStructureCell) {
                        selection.add((mxICell)((mmIStructureCell)selectionCell));
                        continue;
                    }
                    if (!(selectionCell instanceof mmFlowCell)) continue;
                    selection.add((mxICell)((mmFlowCell)selectionCell));
                }
                SelectDescendantsAction.this.changeState(SelectDescendantsAction.this.isEnabled(selection));
            }
        };
    }

    protected final boolean isEnabled(List<mxICell> selectionCells) {
        this.enabled = selectionCells.size() > 0;
        return this.enabled;
    }

    private EditorListener createEditorListener() {
        return new EditorListener(){

            public void editorChanged(IEditorComponent editor) {
                if (SelectDescendantsAction.this.currentEditor != null) {
                    SelectDescendantsAction.this.currentEditor.removeViewTypeListener(SelectDescendantsAction.this.getViewListener());
                }
                SelectDescendantsAction.this.currentEditor = editor;
                if (SelectDescendantsAction.this.currentEditor != null) {
                    SelectDescendantsAction.this.currentEditor.removeViewTypeListener(SelectDescendantsAction.this.getViewListener());
                    SelectDescendantsAction.this.currentEditor.addViewTypeListener(SelectDescendantsAction.this.getViewListener());
                    SelectDescendantsAction.this.changeState(!SelectDescendantsAction.this.isFastCaptureView(editor.getView().getId()));
                } else {
                    SelectDescendantsAction.this.changeState(false);
                }
            }
        };
    }

    private IViewListener getViewListener() {
        if (this.viewListener == null) {
            this.viewListener = new IViewListener(){

                public void viewChanged(String viewID) {
                    SelectDescendantsAction.this.changeState(!SelectDescendantsAction.this.isFastCaptureView(viewID));
                }
            };
        }
        return this.viewListener;
    }

    private boolean isFastCaptureView(String viewId) {
        return viewId.equals("com.thinkbuzan.phoenix.view.FastCaptureView");
    }

    public final String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public final void runAction(Object ... parameters) {
        if (this.enabled) {
            this.selectionSupport.getCurrentEditor().runSingleAction((AbstractEditorAction)new com.thinkbuzan.gaia.editor.actions.SelectDescendantsAction());
        }
    }

    public final void systemStateChanged(ISystemState systemState) {
    }
}

