/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.actions;

import com.buzanonline.chaos.action.AbstractAction;
import com.buzanonline.chaos.systemstate.ISystemState;
import com.mxgraph.mindmap.model.mmBranchCell;
import com.mxgraph.mindmap.model.mmCell;
import com.mxgraph.mindmap.util.mmConstants;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.editor.actions.AbstractEditorAction;
import com.thinkbuzan.gaia.editor.actionsupport.SelectionSupport;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetFillColourAction
extends AbstractAction {
    private static final Logger LOGGER = Logger.getLogger(SetFillColourAction.class);
    private final transient SelectionSupport selectionSupport;

    public SetFillColourAction(BundleContext context) {
        this.changeState(false);
        this.selectionSupport = new SelectionSupport(context){

            public void updateState(IEditorComponent editorComponent, List<mmCell> selectionCells) {
                SetFillColourAction.this.changeState(editorComponent != null && SetFillColourAction.this.isEnabled(selectionCells));
            }
        };
    }

    private boolean isEnabled(List<mmCell> selectionCells) {
        return this.getValidFillColourCells(selectionCells).length > 0;
    }

    private Object[] getValidFillColourCells(List<mmCell> cells) {
        ArrayList<mmCell> validCells = new ArrayList<mmCell>();
        if (cells != null && !cells.isEmpty()) {
            for (mmCell cell : cells) {
                if (!mmConstants.VALID_FILL_COLOR_CELLS.contains(cell.getClass()) && (!(cell instanceof mmBranchCell) || ((mmBranchCell)cell).getBoxBranch() == null)) continue;
                validCells.add(cell);
            }
        }
        return validCells.toArray();
    }

    public final String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public final void runAction(Object ... parameters) {
        Color colour;
        if (parameters[0] instanceof Color) {
            colour = (Color)parameters[0];
        } else {
            int rgbaColour;
            if (parameters[0] instanceof Integer) {
                rgbaColour = (Integer)parameters[0];
            } else if (parameters[0] instanceof String) {
                rgbaColour = Integer.parseInt((String)parameters[0]);
            } else {
                throw new IllegalArgumentException("parameters[0] must be an Integer or String");
            }
            colour = new Color(rgbaColour, true);
        }
        IEditorComponent currentEditor = this.selectionSupport.getCurrentEditor();
        Object[] validCells = this.getValidFillColourCells(currentEditor.getAllSelectionCells());
        if (validCells.length == 0) {
            LOGGER.warn((Object)"no valid fill colour cells found in current selection!");
        } else {
            currentEditor.runSingleAction((AbstractEditorAction)new com.thinkbuzan.gaia.editor.actions.SetFillColourAction(colour, validCells));
        }
    }

    public void systemStateChanged(ISystemState systemState) {
    }
}

