/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.actions;

import com.buzanonline.chaos.systemstate.ISystemState;
import com.mxgraph.mindmap.model.mmCell;
import com.thinkbuzan.gaia.action.AbstractOSGiAction;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.editor.actions.AbstractEditorAction;
import com.thinkbuzan.gaia.editor.actions.RunHybridFullMapLayoutAction;
import com.thinkbuzan.gaia.editor.actions.SetLayoutEnabledAction;
import com.thinkbuzan.gaia.editor.actions.SetLayoutSpacingAction;
import com.thinkbuzan.gaia.editor.actionsupport.SelectionSupport;
import com.thinkbuzan.pascal.services.editor.listeners.StateToggleListener;
import java.util.Arrays;
import java.util.List;
import org.osgi.framework.BundleContext;

public class SetLayoutSpacingValueAction
extends AbstractOSGiAction {
    private final transient SelectionSupport selectionSupport;

    public SetLayoutSpacingValueAction(BundleContext contextIn) {
        super(contextIn);
        this.changeState(false);
        final StateToggleListener toggleListener = new StateToggleListener(){

            public void toggleStateChanged(boolean oldSetting, boolean newSetting) {
                SetLayoutSpacingValueAction.this.changeState(newSetting);
            }
        };
        this.selectionSupport = new SelectionSupport(this.getBundleContext()){
            private transient IEditorComponent oldEditor;

            public void updateState(IEditorComponent editorComponent, List<mmCell> selectionCells) {
                if (this.oldEditor != null) {
                    this.oldEditor.removeLayoutToggleListener(toggleListener);
                }
                this.oldEditor = editorComponent;
                if (editorComponent == null) {
                    SetLayoutSpacingValueAction.this.changeState(false);
                } else {
                    editorComponent.addLayoutToggleListener(toggleListener);
                    SetLayoutSpacingValueAction.this.changeState(editorComponent.isLayoutOn());
                }
            }
        };
    }

    public final String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void runAction(Object ... parameters) {
        int value;
        IEditorComponent editorComponent = this.selectionSupport.getCurrentEditor();
        if (editorComponent == null) {
            throw new IllegalStateException("action should be disabled when there is a null editor component");
        }
        if (parameters == null || parameters.length == 0) {
            throw new IllegalArgumentException("expected 1 boolean or string argument, got none");
        }
        if (parameters[0] instanceof Integer) {
            value = (Integer)parameters[0];
        } else if (parameters[0] instanceof String) {
            value = Integer.parseInt((String)parameters[0]);
        } else {
            throw new IllegalArgumentException("expected 1 int or string argument, got " + Arrays.toString(parameters));
        }
        if (value > 0 && value <= 5) {
            boolean layoutEnabled = editorComponent.getLayoutSettings().isLayoutOn();
            editorComponent.runAction((AbstractEditorAction)new SetLayoutEnabledAction(false, false));
            editorComponent.beginUpdate();
            try {
                editorComponent.runAction((AbstractEditorAction)new SetLayoutSpacingAction(value, layoutEnabled));
            }
            finally {
                editorComponent.endUpdate();
                if (layoutEnabled) {
                    editorComponent.runAction((AbstractEditorAction)new SetLayoutEnabledAction(true));
                    editorComponent.runAction((AbstractEditorAction)new RunHybridFullMapLayoutAction());
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid value passed into action, expected int from 1 to 5, value=" + value);
        }
    }

    public void systemStateChanged(ISystemState systemState) {
    }
}

