/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.actions;

import com.buzanonline.chaos.systemstate.ISystemState;
import com.thinkbuzan.chaos.osgiutilities.service.OSGiService;
import com.thinkbuzan.chaos.utilities.edtutilities.EDTUtilities;
import com.thinkbuzan.gaia.action.AbstractOSGiAction;
import com.thinkbuzan.gaia.editor.EditorManager;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.editor.actionsupport.ViewTypeSupport;
import org.osgi.framework.BundleContext;

public class SetZoomAction
extends AbstractOSGiAction {
    private final transient OSGiService<EditorManager> editorManagerService = new OSGiService(this.getBundleContext(), EditorManager.class);
    private final ViewTypeSupport viewTypeSupport;

    public SetZoomAction(BundleContext context) {
        super(context);
        this.changeState(false);
        this.viewTypeSupport = new ViewTypeSupport(this.getBundleContext()){

            public void updateState() {
                SetZoomAction.this.changeState(SetZoomAction.this.isEnabled());
            }
        };
    }

    private boolean isEnabled() {
        return this.getCurrentEditorComponent() != null && (ViewTypeSupport.MIND_MAP_VIEW_ID.equals(this.viewTypeSupport.getViewId()) || ViewTypeSupport.TD_VIEW_ID.equals(this.viewTypeSupport.getViewId()) || ViewTypeSupport.PROJECT_MANAGEMENT_VIEW_ID.equals(this.viewTypeSupport.getViewId()) || ViewTypeSupport.PRESENTATION_VIEW_ID.equals(this.viewTypeSupport.getViewId()) || ViewTypeSupport.BRAINSTORM_VIEW.equals(this.viewTypeSupport.getViewId()) || ViewTypeSupport.FAST_CAPTURE_VIEW.equals(this.viewTypeSupport.getViewId()) || ViewTypeSupport.TIMELINE_VIEW.equals(this.viewTypeSupport.getViewId()));
    }

    private IEditorComponent getCurrentEditorComponent() {
        try {
            return ((EditorManager)this.editorManagerService.get()).getCurrentEditorComponent();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void runAction(Object ... parameters) {
        this.validateRunAction(parameters);
        if (!this.isEnabled()) {
            return;
        }
        final double scale = (Double)parameters[0];
        EDTUtilities.runOnEDT((Runnable)new Runnable(){

            public void run() {
                IEditorComponent editorComponent = SetZoomAction.this.getCurrentEditorComponent();
                if (editorComponent != null) {
                    editorComponent.getZoomController().setZoom(scale);
                }
            }
        });
    }

    private void validateRunAction(Object ... parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException("parameters must not be null");
        }
        if (parameters.length != 1) {
            throw new IllegalArgumentException("parameters.length mut be  1");
        }
        if (!(parameters[0] instanceof Double)) {
            throw new IllegalArgumentException("parameters[0] must be a Double");
        }
    }

    public final void systemStateChanged(ISystemState systemState) {
    }
}

