/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.actions;

import com.buzanonline.chaos.systemstate.ISystemState;
import com.mxgraph.mindmap.model.mmBranchCell;
import com.mxgraph.mindmap.model.mmCell;
import com.mxgraph.mindmap.swing.mmGraphComponent;
import com.mxgraph.mindmap.swing.popup.BranchArt;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxCellState;
import com.thinkbuzan.chaos.internationalization.I18n;
import com.thinkbuzan.chaos.osgiutilities.service.OSGiService;
import com.thinkbuzan.gaia.action.AbstractOSGiAction;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.editor.actionsupport.SelectionSupport;
import com.thinkbuzan.gaia.ui.MainFrameUtilities;
import com.thinkbuzan.gaia.ui.v2.factory.AbstractBranchArtDialog;
import com.thinkbuzan.gaia.ui.v2.factory.UIFactory;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetupBranchArtPagesAction
extends AbstractOSGiAction {
    private static final Dimension PREFERRED_SIZE = new Dimension(375, 300);
    private static final Color HIGHLIGHT = Color.decode("#dddddd");
    private transient IEditorComponent currentEditor;

    public SetupBranchArtPagesAction(BundleContext contextIn) {
        super(contextIn);
        new SelectionSupport(contextIn){

            public void updateState(IEditorComponent editorComponent, List<mmCell> selectionCells) {
                SetupBranchArtPagesAction.this.currentEditor = editorComponent;
                SetupBranchArtPagesAction.this.changeState(SetupBranchArtPagesAction.this.isEnabled(selectionCells));
            }
        };
    }

    protected final IEditorComponent getCurrentEditor() {
        return this.currentEditor;
    }

    protected final boolean isEnabled(List<mmCell> selectionCells) {
        if (this.currentEditor != null && this.currentEditor.getAllSelectionCells().size() >= 1) {
            for (mmCell cell : this.currentEditor.getAllSelectionCells()) {
                if (!(cell instanceof mmBranchCell)) continue;
                return true;
            }
        }
        return false;
    }

    public final String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public final void runAction(Object ... parameters) {
        if (parameters[0] instanceof List) {
            if (this.currentEditor == null) {
                return;
            }
            final List<Object> cells = this.getCells(parameters);
            if (cells.size() < 1) {
                return;
            }
            ArrayList<Object> branches = new ArrayList<Object>();
            for (Object cell : cells) {
                if (!(cell instanceof mmBranchCell)) continue;
                branches.add(cell);
            }
            if (branches.isEmpty()) {
                return;
            }
            final ArtController controller = new ArtController(this.currentEditor.getGraphComponent(), this.currentEditor.getGraphComponent().getGraph().getView().getState(branches.get(0), true), branches);
            OSGiService i18nService = new OSGiService(this.getBundleContext(), I18n.class);
            final AbstractBranchArtDialog branchArtDialog = UIFactory.createBranchArtDialog(MainFrameUtilities.getMainFrame(), controller, (I18n)i18nService.get());
            JList list = branchArtDialog.getList();
            list.setPreferredSize(PREFERRED_SIZE);
            list.setBorder(BorderFactory.createEmptyBorder());
            JScrollPane pane = new JScrollPane(list);
            pane.setPreferredSize(PREFERRED_SIZE);
            pane.setBorder(BorderFactory.createEmptyBorder());
            final JPopupMenu menu = new JPopupMenu();
            menu.setBorder(BorderFactory.createLineBorder(HIGHLIGHT, 1));
            menu.add(pane);
            CopyOnWriteArrayList<ListSelectionListener> listeners = new CopyOnWriteArrayList<ListSelectionListener>(list.getListSelectionListeners());
            for (ListSelectionListener listener : listeners) {
                list.removeListSelectionListener(listener);
            }
            list.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent event) {
                    if (!event.getValueIsAdjusting() && event.getSource() instanceof JList) {
                        AbstractBranchArtDialog.BranchArtItem item = (AbstractBranchArtDialog.BranchArtItem)((JList)event.getSource()).getSelectedValue();
                        controller.selectionChange(item.getType());
                        branchArtDialog.doSetStyle(controller);
                        menu.setVisible(false);
                    }
                }
            });
            if (parameters[0] instanceof List) {
                List comps = (List)parameters[0];
                for (int i = 0; i < list.getModel().getSize(); ++i) {
                    Object ob = list.getModel().getElementAt(i);
                    if (!(ob instanceof AbstractBranchArtDialog.BranchArtItem)) continue;
                    final AbstractBranchArtDialog.BranchArtItem bai = (AbstractBranchArtDialog.BranchArtItem)ob;
                    final JLabel label = new JLabel(bai.getImage());
                    label.setOpaque(false);
                    label.setBackground(HIGHLIGHT);
                    label.addMouseListener(new MouseAdapter(){

                        public void mouseClicked(MouseEvent e) {
                            super.mouseClicked(e);
                            SetupBranchArtPagesAction.this.currentEditor.getGraphComponent().setCellStyles("branchArt", SetupBranchArtPagesAction.this.getBranchArtTypeForModel(bai.getType()), cells.toArray());
                        }

                        public void mouseEntered(MouseEvent e) {
                            super.mouseEntered(e);
                            label.setOpaque(true);
                            label.revalidate();
                            label.repaint();
                        }

                        public void mouseExited(MouseEvent e) {
                            super.mouseExited(e);
                            label.setOpaque(false);
                            label.revalidate();
                            label.repaint();
                        }
                    });
                    comps.add(label);
                }
            }
        }
    }

    protected final List<Object> getCells(Object ... parameters) {
        ArrayList<Object> cells = new ArrayList<Object>();
        if (parameters != null && parameters.length > 1) {
            for (Object cell : parameters) {
                if (cell instanceof JComponent) continue;
                cells.add(cell);
            }
        } else if (this.currentEditor.getAllSelectionCells().size() > 0) {
            cells.addAll(this.currentEditor.getAllSelectionCells());
        }
        return cells;
    }

    public void systemStateChanged(ISystemState systemState) {
    }

    private final String getBranchArtTypeForModel(BranchArt branchArt) {
        switch (branchArt) {
            case REGULAR: {
                return null;
            }
            case ARROWS: {
                return "threeArrows";
            }
            case ARROW: {
                return "oneArrow";
            }
            case OUTLINE_THIN: {
                return "outlineThin";
            }
            case OUTLINE_THICK: {
                return "outlineThick";
            }
            case TEXTURE_SQUARES: {
                return "tileSquares";
            }
            case TEXTURE_LATTICE: {
                return "tileLattice";
            }
            case TEXTURE_SKETCHY: {
                return "tileSketchy";
            }
            case LIGHTNING: {
                return "lightning";
            }
            case ROAD: {
                return "road";
            }
            case PENCIL: {
                return "pencil";
            }
            case ARM: {
                return "arm";
            }
            case HAND_DRAWN: {
                return "handDrawn";
            }
            case HAND_DRAWN_ARROW: {
                return "handDrawnArrow";
            }
            case BRUSH: {
                return "brush";
            }
            case SPLASH: {
                return "splash";
            }
            case DOTS: {
                return "dots";
            }
            case LINES: {
                return "lines";
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ArtController
    implements AbstractBranchArtDialog.BranchArtController {
        private final transient mmGraphComponent graphComponent;
        private final transient mxCellState state;
        private final transient List<Object> branches;
        private transient BranchArt type = BranchArt.REGULAR;
        private transient Map<String, Object> styleChanges = new HashMap<String, Object>();

        public ArtController(mmGraphComponent graphComponentIn, mxCellState stateIn, List<Object> branchesIn) {
            this.graphComponent = graphComponentIn;
            this.state = stateIn;
            this.branches = branchesIn;
        }

        @Override
        public ImageIcon updatePreviewImage(double dWidth, double dHeight) {
            return new ImageIcon();
        }

        @Override
        public Map<String, Object> updateStyleMapForBranchArt(boolean isFinal) {
            HashMap<String, Object> styleChangeSet = new HashMap<String, Object>();
            if (isFinal) {
                for (Map.Entry<String, Object> entry : this.styleChanges.entrySet()) {
                    styleChangeSet.put(entry.getKey(), entry.getValue());
                }
            } else if (this.type != null) {
                switch (this.type) {
                    case REGULAR: {
                        styleChangeSet.put("branchArt", null);
                        break;
                    }
                    case ARROWS: {
                        styleChangeSet.put("branchArt", "threeArrows");
                        break;
                    }
                    case ARROW: {
                        styleChangeSet.put("branchArt", "oneArrow");
                        break;
                    }
                    case OUTLINE_THIN: {
                        styleChangeSet.put("branchArt", "outlineThin");
                        break;
                    }
                    case OUTLINE_THICK: {
                        styleChangeSet.put("branchArt", "outlineThick");
                        break;
                    }
                    case TEXTURE_SQUARES: {
                        styleChangeSet.put("branchArt", "tileSquares");
                        break;
                    }
                    case TEXTURE_LATTICE: {
                        styleChangeSet.put("branchArt", "tileLattice");
                        break;
                    }
                    case TEXTURE_SKETCHY: {
                        styleChangeSet.put("branchArt", "tileSketchy");
                        break;
                    }
                    case LIGHTNING: {
                        styleChangeSet.put("branchArt", "lightning");
                        break;
                    }
                    case ROAD: {
                        styleChangeSet.put("branchArt", "road");
                        break;
                    }
                    case PENCIL: {
                        styleChangeSet.put("branchArt", "pencil");
                        break;
                    }
                    case ARM: {
                        styleChangeSet.put("branchArt", "arm");
                        break;
                    }
                    case HAND_DRAWN: {
                        styleChangeSet.put("branchArt", "handDrawn");
                        break;
                    }
                    case HAND_DRAWN_ARROW: {
                        styleChangeSet.put("branchArt", "handDrawnArrow");
                        break;
                    }
                    case BRUSH: {
                        styleChangeSet.put("branchArt", "brush");
                        break;
                    }
                    case SPLASH: {
                        styleChangeSet.put("branchArt", "splash");
                        break;
                    }
                    case DOTS: {
                        styleChangeSet.put("branchArt", "dots");
                        break;
                    }
                    case LINES: {
                        styleChangeSet.put("branchArt", "lines");
                        break;
                    }
                    default: {
                        styleChangeSet.put("branchArt", null);
                    }
                }
            }
            return styleChangeSet;
        }

        @Override
        public Object getCell() {
            if (this.state == null) {
                return this.state;
            }
            return this.state.getCell();
        }

        @Override
        public List<Object> getCells() {
            return this.branches;
        }

        @Override
        public void setCellStyles(String key, String value, Object[] cells) {
            this.graphComponent.setCellStyles(key, value, cells);
        }

        @Override
        public void selectionChange(BranchArt artType) {
            this.type = artType;
        }

        @Override
        public BranchArt getCurrentBranchArtType() {
            if (this.state == null) {
                return BranchArt.REGULAR;
            }
            String branchArt = mxUtils.getString((Map)this.state.getStyle(), (String)"branchArt", (String)"");
            BranchArt branchType = branchArt.equalsIgnoreCase("threeArrows") ? BranchArt.ARROWS : (branchArt.equalsIgnoreCase("outlineThin") ? BranchArt.OUTLINE_THIN : (branchArt.equalsIgnoreCase("outlineThick") ? BranchArt.OUTLINE_THICK : (branchArt.equalsIgnoreCase("tileSquares") ? BranchArt.TEXTURE_SQUARES : (branchArt.equalsIgnoreCase("tileLattice") ? BranchArt.TEXTURE_LATTICE : (branchArt.equalsIgnoreCase("tileSketchy") ? BranchArt.TEXTURE_SKETCHY : (branchArt.equalsIgnoreCase("lightning") ? BranchArt.LIGHTNING : (branchArt.equalsIgnoreCase("road") ? BranchArt.ROAD : (branchArt.equalsIgnoreCase("pencil") ? BranchArt.PENCIL : (branchArt.equalsIgnoreCase("arm") ? BranchArt.ARM : (branchArt.equalsIgnoreCase("oneArrow") ? BranchArt.ARROW : (branchArt.equalsIgnoreCase("handDrawn") ? BranchArt.HAND_DRAWN : (branchArt.equalsIgnoreCase("handDrawnArrow") ? BranchArt.HAND_DRAWN_ARROW : (branchArt.equalsIgnoreCase("brush") ? BranchArt.BRUSH : (branchArt.equalsIgnoreCase("splash") ? BranchArt.SPLASH : (branchArt.equalsIgnoreCase("dots") ? BranchArt.DOTS : (branchArt.equalsIgnoreCase("lines") ? BranchArt.LINES : BranchArt.REGULAR))))))))))))))));
            return branchType;
        }

        @Override
        public Color getBackgroundColour() {
            return this.graphComponent.getBackground();
        }
    }
}

