/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.actions;

import com.buzanonline.chaos.systemstate.ISystemState;
import com.mxgraph.mindmap.model.mmBranchCell;
import com.mxgraph.mindmap.model.mmCell;
import com.mxgraph.mindmap.swing.mmGraphComponent;
import com.mxgraph.mindmap.swing.popup.BranchArt;
import com.mxgraph.mindmap.swing.popup.StateShapePainter;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxCellState;
import com.thinkbuzan.chaos.internationalization.I18n;
import com.thinkbuzan.chaos.osgiutilities.service.OSGiService;
import com.thinkbuzan.gaia.action.AbstractOSGiAction;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.editor.actionsupport.SelectionSupport;
import com.thinkbuzan.gaia.ui.MainFrameUtilities;
import com.thinkbuzan.gaia.ui.v2.factory.AbstractBranchArtDialog;
import com.thinkbuzan.gaia.ui.v2.factory.UIFactory;
import com.thinkbuzan.gaia.view.mindmap.MindMapView;
import java.awt.Color;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShowBranchArtDialogAction
extends AbstractOSGiAction {
    private transient IEditorComponent currentEditor;

    public ShowBranchArtDialogAction(BundleContext contextIn) {
        super(contextIn);
        new SelectionSupport(contextIn){

            public void updateState(IEditorComponent editorComponent, List<mmCell> selectionCells) {
                ShowBranchArtDialogAction.this.currentEditor = editorComponent;
                ShowBranchArtDialogAction.this.changeState(ShowBranchArtDialogAction.this.isEnabled(selectionCells));
            }
        };
        this.changeState(false);
    }

    protected final IEditorComponent getCurrentEditor() {
        return this.currentEditor;
    }

    protected final boolean isEnabled(List<mmCell> selectionCells) {
        if (this.currentEditor != null && this.currentEditor.getAllSelectionCells().size() >= 1) {
            if (!(this.currentEditor.getView() instanceof MindMapView)) {
                return false;
            }
            for (mmCell cell : this.currentEditor.getAllSelectionCells()) {
                if (!(cell instanceof mmBranchCell)) continue;
                return true;
            }
        }
        return false;
    }

    public final String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public final void runAction(Object ... parameters) {
        if (this.currentEditor == null) {
            return;
        }
        List<Object> cells = this.getCells(parameters);
        if (cells.size() < 1) {
            return;
        }
        ArrayList<Object> branches = new ArrayList<Object>();
        for (Object cell : cells) {
            if (!(cell instanceof mmBranchCell)) continue;
            branches.add(cell);
        }
        if (branches.isEmpty()) {
            return;
        }
        OSGiService i18nService = new OSGiService(this.getBundleContext(), I18n.class);
        AbstractBranchArtDialog artDialog = UIFactory.createBranchArtDialog(MainFrameUtilities.getMainFrame(), new ArtController(this.currentEditor.getGraphComponent(), this.currentEditor.getGraphComponent().getGraph().getView().getState(branches.get(0)), branches), (I18n)i18nService.get());
        artDialog.getDialog().setLocationRelativeTo((Component)this.currentEditor.getGraphComponent());
        artDialog.getDialog().setVisible(true);
    }

    protected final List<Object> getCells(Object ... parameters) {
        ArrayList<Object> cells = new ArrayList<Object>();
        if (parameters != null && parameters.length > 0) {
            for (Object cell : parameters) {
                cells.add(cell);
            }
        } else if (this.currentEditor.getAllSelectionCells().size() > 0) {
            cells.addAll(this.currentEditor.getAllSelectionCells());
        }
        return cells;
    }

    public void systemStateChanged(ISystemState systemState) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ArtController
    implements AbstractBranchArtDialog.BranchArtController {
        private static final int PADDING = 50;
        private final transient mmGraphComponent graphComponent;
        private final transient mxCellState state;
        private final transient List<Object> branches;
        private transient BranchArt type = BranchArt.REGULAR;
        private transient Map<String, Object> styleChanges = new HashMap<String, Object>();

        public ArtController(mmGraphComponent graphComponentIn, mxCellState stateIn, List<Object> branchesIn) {
            this.graphComponent = graphComponentIn;
            this.state = stateIn;
            this.branches = branchesIn;
        }

        @Override
        public ImageIcon updatePreviewImage(double dWidth, double dHeight) {
            mxCellState source = this.graphComponent.getGraph().getView().getState((Object)((mmBranchCell)this.state.getCell()).getSource());
            int width = (int)(this.state.getWidth() + source.getWidth() / 2.0) + 50;
            int height = (int)(this.state.getHeight() + source.getHeight() / 2.0) + 50;
            this.styleChanges = this.updateStyleMapForBranchArt(false);
            BufferedImage img = new BufferedImage(width, height, 6);
            StateShapePainter.paintBranchShape((mmGraphComponent)this.graphComponent, (mxCellState)this.state, this.styleChanges, (BufferedImage)img, (int)0);
            double newScale = width >= height ? dWidth / (double)width : dHeight / (double)height;
            return new ImageIcon(img.getScaledInstance((int)((double)width * newScale), (int)((double)height * newScale), 4));
        }

        @Override
        public Map<String, Object> updateStyleMapForBranchArt(boolean isFinal) {
            HashMap<String, Object> styleChangeSet = new HashMap<String, Object>();
            if (isFinal) {
                for (Map.Entry<String, Object> entry : this.styleChanges.entrySet()) {
                    styleChangeSet.put(entry.getKey(), entry.getValue());
                }
            } else if (this.type != null) {
                switch (this.type) {
                    case REGULAR: {
                        styleChangeSet.put("branchArt", null);
                        break;
                    }
                    case ARROWS: {
                        styleChangeSet.put("branchArt", "threeArrows");
                        break;
                    }
                    case ARROW: {
                        styleChangeSet.put("branchArt", "oneArrow");
                        break;
                    }
                    case OUTLINE_THIN: {
                        styleChangeSet.put("branchArt", "outlineThin");
                        break;
                    }
                    case OUTLINE_THICK: {
                        styleChangeSet.put("branchArt", "outlineThick");
                        break;
                    }
                    case TEXTURE_SQUARES: {
                        styleChangeSet.put("branchArt", "tileSquares");
                        break;
                    }
                    case TEXTURE_LATTICE: {
                        styleChangeSet.put("branchArt", "tileLattice");
                        break;
                    }
                    case TEXTURE_SKETCHY: {
                        styleChangeSet.put("branchArt", "tileSketchy");
                        break;
                    }
                    case LIGHTNING: {
                        styleChangeSet.put("branchArt", "lightning");
                        break;
                    }
                    case ROAD: {
                        styleChangeSet.put("branchArt", "road");
                        break;
                    }
                    case PENCIL: {
                        styleChangeSet.put("branchArt", "pencil");
                        break;
                    }
                    case ARM: {
                        styleChangeSet.put("branchArt", "arm");
                        break;
                    }
                    case HAND_DRAWN: {
                        styleChangeSet.put("branchArt", "handDrawn");
                        break;
                    }
                    case HAND_DRAWN_ARROW: {
                        styleChangeSet.put("branchArt", "handDrawnArrow");
                        break;
                    }
                    case BRUSH: {
                        styleChangeSet.put("branchArt", "brush");
                        break;
                    }
                    case SPLASH: {
                        styleChangeSet.put("branchArt", "splash");
                        break;
                    }
                    case DOTS: {
                        styleChangeSet.put("branchArt", "dots");
                        break;
                    }
                    case LINES: {
                        styleChangeSet.put("branchArt", "lines");
                        break;
                    }
                    default: {
                        styleChangeSet.put("branchArt", null);
                    }
                }
            }
            return styleChangeSet;
        }

        @Override
        public Object getCell() {
            if (this.state == null) {
                return this.state;
            }
            return this.state.getCell();
        }

        @Override
        public List<Object> getCells() {
            return this.branches;
        }

        @Override
        public void setCellStyles(String key, String value, Object[] cells) {
            this.graphComponent.setCellStyles(key, value, cells);
        }

        @Override
        public void selectionChange(BranchArt artType) {
            this.type = artType;
        }

        @Override
        public BranchArt getCurrentBranchArtType() {
            String branchArt = mxUtils.getString((Map)this.state.getStyle(), (String)"branchArt", (String)"");
            BranchArt branchType = branchArt.equalsIgnoreCase("threeArrows") ? BranchArt.ARROWS : (branchArt.equalsIgnoreCase("outlineThin") ? BranchArt.OUTLINE_THIN : (branchArt.equalsIgnoreCase("outlineThick") ? BranchArt.OUTLINE_THICK : (branchArt.equalsIgnoreCase("tileSquares") ? BranchArt.TEXTURE_SQUARES : (branchArt.equalsIgnoreCase("tileLattice") ? BranchArt.TEXTURE_LATTICE : (branchArt.equalsIgnoreCase("tileSketchy") ? BranchArt.TEXTURE_SKETCHY : (branchArt.equalsIgnoreCase("lightning") ? BranchArt.LIGHTNING : (branchArt.equalsIgnoreCase("road") ? BranchArt.ROAD : (branchArt.equalsIgnoreCase("pencil") ? BranchArt.PENCIL : (branchArt.equalsIgnoreCase("arm") ? BranchArt.ARM : (branchArt.equalsIgnoreCase("oneArrow") ? BranchArt.ARROW : (branchArt.equalsIgnoreCase("handDrawn") ? BranchArt.HAND_DRAWN : (branchArt.equalsIgnoreCase("handDrawnArrow") ? BranchArt.HAND_DRAWN_ARROW : (branchArt.equalsIgnoreCase("brush") ? BranchArt.BRUSH : (branchArt.equalsIgnoreCase("splash") ? BranchArt.SPLASH : (branchArt.equalsIgnoreCase("dots") ? BranchArt.DOTS : (branchArt.equalsIgnoreCase("lines") ? BranchArt.LINES : BranchArt.REGULAR))))))))))))))));
            return branchType;
        }

        @Override
        public Color getBackgroundColour() {
            return this.graphComponent.getBackground();
        }
    }
}

