/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.actions;

import com.buzanonline.chaos.systemstate.ISystemState;
import com.mxgraph.mindmap.model.mmCell;
import com.mxgraph.mindmap.util.mmUtils;
import com.thinkbuzan.apollo.ui.core.win.component.IgnoreTransparencyColourChooser;
import com.thinkbuzan.chaos.internationalization.I18n;
import com.thinkbuzan.chaos.osgiutilities.service.OSGiService;
import com.thinkbuzan.gaia.action.AbstractOSGiAction;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.editor.actions.AbstractEditorAction;
import com.thinkbuzan.gaia.editor.actions.SetEdgeColorAction;
import com.thinkbuzan.gaia.editor.actionsupport.SelectionSupport;
import com.thinkbuzan.gaia.ui.MainFrameUtilities;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShowBranchColorChooserAction
extends AbstractOSGiAction {
    private final transient SelectionSupport selectionSupport;
    private final transient I18n i18n;

    public ShowBranchColorChooserAction(BundleContext context) {
        super(context);
        this.changeState(false);
        this.selectionSupport = new SelectionSupport(this.getBundleContext()){

            public void updateState(IEditorComponent editorComponent, List<mmCell> selectionCells) {
                ShowBranchColorChooserAction.this.changeState(ShowBranchColorChooserAction.this.isEnabled(mmUtils.filterBranchColorCells(selectionCells)));
            }
        };
        this.i18n = (I18n)new OSGiService(context, I18n.class).get();
    }

    private boolean isEnabled(List<mmCell> selectionCells) {
        return !selectionCells.isEmpty();
    }

    public final String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public final void runAction(Object ... parameters) {
        Color color = IgnoreTransparencyColourChooser.showDialog((Component)MainFrameUtilities.getMainFrame(), (String)this.i18n.getLocalizedText("com.thinkbuzan.i18n.common.tooltips.branchColourChooser"), null);
        if (color != null) {
            IEditorComponent editor = this.selectionSupport.getCurrentEditor();
            List selectionCells = mmUtils.filterBranchColorCells((List)editor.getAllSelectionCells());
            editor.runSingleAction((AbstractEditorAction)new SetEdgeColorAction(color, selectionCells.toArray()));
        }
    }

    public final void systemStateChanged(ISystemState systemState) {
    }
}

