/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.actions;

import com.buzanonline.chaos.systemstate.ISystemState;
import com.mxgraph.mindmap.model.mmBoundaryCell;
import com.mxgraph.mindmap.model.mmBranchBoxCell;
import com.mxgraph.mindmap.model.mmBranchCell;
import com.mxgraph.mindmap.model.mmCell;
import com.mxgraph.mindmap.model.mmFlowConnectorCell;
import com.mxgraph.mindmap.model.mmRelationshipCell;
import com.mxgraph.mindmap.util.mmConstants;
import com.mxgraph.mindmap.view.mmGraph;
import com.mxgraph.model.mxICell;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraph;
import com.thinkbuzan.gaia.action.AbstractOSGiAction;
import com.thinkbuzan.gaia.dialogs.tabs.BoundaryTabContent;
import com.thinkbuzan.gaia.dialogs.tabs.BoxTabContent;
import com.thinkbuzan.gaia.dialogs.tabs.BranchTabContent;
import com.thinkbuzan.gaia.dialogs.tabs.RelationshipTabContent;
import com.thinkbuzan.gaia.dialogs.ui.v2.AbstractFormatMapElementsDialog;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.editor.actions.AbstractEditorAction;
import com.thinkbuzan.gaia.editor.actions.RemoveCellStyleAction;
import com.thinkbuzan.gaia.editor.actionsupport.SelectionSupport;
import com.thinkbuzan.gaia.graphlayout.LayoutSettings;
import com.thinkbuzan.gaia.ui.MainFrameUtilities;
import com.thinkbuzan.gaia.ui.v2.factory.UIFactory;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShowFormatDialogAction
extends AbstractOSGiAction {
    private final SelectionSupport selectionSupport;
    private IEditorComponent currentEditor;
    private final int selectionIndex;
    protected static final int BRANCH_TAB = 0;
    protected static final int BOX_TAB = 1;
    protected static final int ARROW_TAB = 2;
    protected static final int CLOUD_TAB = 3;
    private static final Logger LOGGER = Logger.getLogger(ShowFormatDialogAction.class);

    public ShowFormatDialogAction(BundleContext context) {
        this(context, 0);
    }

    public ShowFormatDialogAction(BundleContext context, int selectionIn) {
        super(context);
        this.selectionIndex = selectionIn;
        this.selectionSupport = new SelectionSupport(context){

            public void updateState(IEditorComponent editorComponent, List<mmCell> selectionCells) {
                ShowFormatDialogAction.this.currentEditor = editorComponent;
                ShowFormatDialogAction.this.changeState(ShowFormatDialogAction.this.isEnabled(selectionCells));
            }
        };
    }

    protected IEditorComponent getCurrentEditor() {
        return this.currentEditor;
    }

    protected boolean isEnabled(List<mmCell> selectionCells) {
        if (this.currentEditor != null && this.currentEditor.getAllSelectionCells().size() > 0) {
            for (mmCell cell : this.currentEditor.getAllSelectionCells()) {
                if (!(cell instanceof mmBranchBoxCell) && !(cell instanceof mmBranchCell) && !this.isStructureToStructureRelationship(cell)) continue;
                return true;
            }
        }
        return false;
    }

    protected final boolean isStructureToStructureRelationship(Object cell) {
        return cell instanceof mmRelationshipCell || cell instanceof mmFlowConnectorCell;
    }

    public final String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void runAction(Object ... parameters) {
        if (this.currentEditor == null) {
            return;
        }
        List<Object> cells = this.getCells(parameters);
        if (cells.size() == 0) {
            return;
        }
        ArrayList<mmBranchCell> branches = new ArrayList<mmBranchCell>();
        ArrayList<mmBranchBoxCell> boxes = new ArrayList<mmBranchBoxCell>();
        for (Object cell : cells) {
            if (cell instanceof mmBranchCell) {
                if (((mmBranchCell)cell).getBoxBranch() == null) {
                    branches.add((mmBranchCell)cell);
                    continue;
                }
                boxes.add(((mmBranchCell)cell).getBoxBranch());
                continue;
            }
            if (!(cell instanceof mmBranchBoxCell)) continue;
            boxes.add((mmBranchBoxCell)cell);
        }
        RelationshipTabContent.RelationshipController arrowController = this.createRelationshipController(cells);
        BoundaryTabContent.BoundaryController boundaryController = this.createBoundaryController(cells);
        BranchControl branchController = new BranchControl(this.currentEditor, branches);
        BoxControl boxController = new BoxControl(this.currentEditor, boxes);
        AbstractFormatMapElementsDialog.BaseDialogController dialogControl = this.createBaseDialogController(cells);
        AbstractFormatMapElementsDialog dialog = UIFactory.createFormatMapElementsDialog(dialogControl, boundaryController, branchController, arrowController, boxController, MainFrameUtilities.getMainFrame(), true);
        dialog.getDialog().setLocationRelativeTo((Component)this.currentEditor.getGraphComponent());
        dialog.setSelectedTabByIndex(this.selectionIndex);
        dialog.setVisible(true);
    }

    protected final List<Object> getCells(Object ... parameters) {
        ArrayList<Object> cells = new ArrayList<Object>();
        if (parameters != null && parameters.length > 0) {
            for (Object cell : parameters) {
                cells.add(cell);
            }
        } else if (this.currentEditor.getAllSelectionCells().size() > 0) {
            cells.addAll(this.currentEditor.getAllSelectionCells());
        }
        return cells;
    }

    protected final AbstractFormatMapElementsDialog.BaseDialogController createBaseDialogController(final List<Object> cells) {
        AbstractFormatMapElementsDialog.BaseDialogController dialogControl = new AbstractFormatMapElementsDialog.BaseDialogController(){

            public void cancel() {
                LOGGER.debug((Object)"Cancel Preview for format dialog");
                ShowFormatDialogAction.this.currentEditor.getGraphComponent().getUndoManager().endPreview(false);
            }

            public void apply() {
                LOGGER.debug((Object)"Finish and Apply Preview for format dialog");
                ShowFormatDialogAction.this.currentEditor.getGraphComponent().getUndoManager().endPreview(true);
                ShowFormatDialogAction.this.currentEditor.getGraphComponent().getGraph().setSelectionCell(null);
                ShowFormatDialogAction.this.currentEditor.getGraphComponent().getGraph().setSelectionCells((Collection)cells);
            }
        };
        LOGGER.debug((Object)"Starting Preview for format dialog");
        this.currentEditor.getGraphComponent().getUndoManager().startPreview();
        return dialogControl;
    }

    protected final RelationshipTabContent.RelationshipController createRelationshipController(List<Object> cells) {
        ArrayList<mmCell> arrows = new ArrayList<mmCell>();
        for (Object cell : cells) {
            if (!this.isStructureToStructureRelationship(cell)) continue;
            arrows.add((mmCell)cell);
        }
        return new ArrowControl(this.currentEditor, arrows);
    }

    protected final BoundaryTabContent.BoundaryController createBoundaryController(List<Object> cells) {
        ArrayList<mmBoundaryCell> boundaries = new ArrayList<mmBoundaryCell>();
        for (Object cell : cells) {
            if (cell instanceof mmBoundaryCell) {
                boundaries.add((mmBoundaryCell)cell);
                continue;
            }
            if (!(cell instanceof mmBranchCell) || ((mmBranchCell)cell).getBoundaries() == null) continue;
            for (mmBoundaryCell boundary : ((mmBranchCell)cell).getBoundaries()) {
                boundaries.add(boundary);
            }
        }
        return new BoundaryControl(this.currentEditor, boundaries);
    }

    public static void setStyle(mxGraph graph, mxICell cell, String key, String value) {
        graph.setCellStyles(key, value, new Object[]{cell});
    }

    static final Object getCellStyle(mmGraph graph, Object cell, String key) {
        mxCellState state = graph.getView().getState(cell);
        if (state != null && state.getStyle().containsKey(key)) {
            return state.getStyle().get(key);
        }
        return null;
    }

    public final void systemStateChanged(ISystemState systemState) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BranchControl
    implements BranchTabContent.BranchController {
        private final boolean enabled;
        private final List<mmBranchCell> branches;
        private final IEditorComponent editor;
        private final mmGraph graph;
        private int shape = 0;
        private Color colour = Color.BLACK;

        public BranchControl(IEditorComponent currentEditor, List<mmBranchCell> branchesIn) {
            this.editor = currentEditor;
            this.branches = branchesIn;
            this.graph = (mmGraph)this.editor.getGraphComponent().getGraph();
            boolean bl = this.enabled = branchesIn.size() > 0;
            if (this.enabled) {
                this.initialiseValues(branchesIn);
            }
        }

        private void initialiseValues(List<mmBranchCell> branchesIn) {
            String stroke = (String)ShowFormatDialogAction.getCellStyle(this.graph, branchesIn.get(0), mxConstants.STYLE_STROKECOLOR);
            this.colour = mxUtils.parseColor((String)stroke);
            String shapeStr = (String)ShowFormatDialogAction.getCellStyle(this.graph, branchesIn.get(0), "organicLevel");
            this.shape = shapeStr == null ? this.graph.getLayoutSettings().getOrganicLevel() : Integer.valueOf(shapeStr).intValue();
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public int getBranchStyle() {
            return this.shape;
        }

        public Color getBranchColour() {
            return this.colour;
        }

        public void branchStyleChanged(int branchStyle) {
            this.shape = branchStyle;
            this.updateBranchStyle();
        }

        private void updateBranchStyle() {
            this.editor.beginUpdate();
            try {
                this.editor.getGraphComponent().setCellStyles("organicLevel", Integer.toString(this.shape), this.branches.toArray());
            }
            finally {
                this.editor.endUpdate();
            }
        }

        public void branchColourChanged(Color branchColour) {
            this.colour = branchColour;
            this.updateBranchColour();
        }

        private void updateBranchColour() {
            this.editor.beginUpdate();
            try {
                if (this.colour != null) {
                    this.editor.getGraphComponent().setCellStyles(mxConstants.STYLE_STROKECOLOR, mxUtils.hexString((Color)this.colour), this.branches.toArray());
                    for (mmBranchCell branch : this.branches) {
                        if (branch.getBoxBranch() == null) continue;
                        this.editor.getGraphComponent().setCellStyles(mxConstants.STYLE_STROKECOLOR, mxUtils.hexString((Color)this.colour), new Object[]{branch.getBoxBranch()});
                    }
                }
            }
            finally {
                this.editor.endUpdate();
            }
        }

        public void refresh() {
            this.initialiseValues(this.branches);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BoxControl
    implements BoxTabContent.BoxController {
        private final boolean enabled;
        private final List<mmBranchBoxCell> boxes;
        private final List<mmBranchCell> branches;
        private final IEditorComponent editor;
        private final mmGraph graph;
        private BoxTabContent.BoxShape shape = BoxTabContent.BoxShape.RECTANGLE;
        private Color fillColor = Color.WHITE;
        private int branchShape = 0;
        private Color branchColour = Color.BLACK;

        public BoxControl(IEditorComponent currentEditor, List<mmBranchBoxCell> boxesIn) {
            this.editor = currentEditor;
            this.boxes = boxesIn;
            this.branches = new ArrayList<mmBranchCell>();
            for (mmBranchBoxCell box : this.boxes) {
                this.branches.add(box.getBranch());
            }
            this.graph = (mmGraph)this.editor.getGraphComponent().getGraph();
            boolean bl = this.enabled = boxesIn.size() > 0;
            if (this.enabled) {
                this.initialiseValues(boxesIn);
            }
        }

        private void initialiseValues(List<mmBranchBoxCell> boxesIn) {
            String shapeStr;
            String stroke = (String)ShowFormatDialogAction.getCellStyle(this.graph, boxesIn.get(0), mxConstants.STYLE_STROKECOLOR);
            this.branchColour = mxUtils.parseColor((String)stroke);
            String fill = (String)ShowFormatDialogAction.getCellStyle(this.graph, boxesIn.get(0), mxConstants.STYLE_FILLCOLOR);
            this.fillColor = mxUtils.parseColor((String)fill);
            String box = (String)ShowFormatDialogAction.getCellStyle(this.graph, boxesIn.get(0), mxConstants.STYLE_SHAPE);
            if (box != null) {
                this.shape = BoxTabContent.BoxShape.getShape((String)box);
            }
            this.branchShape = (shapeStr = (String)ShowFormatDialogAction.getCellStyle(this.graph, boxesIn.get(0).getBranch(), "organicLevel")) == null ? this.graph.getLayoutSettings().getOrganicLevel() : Integer.valueOf(shapeStr).intValue();
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void boxShapeChanged(BoxTabContent.BoxShape boxShape) {
            this.shape = boxShape;
            this.updateBoxShape();
        }

        public void fillColourChanged(Color fillColour) {
            this.fillColor = fillColour;
            this.updateBoxColour();
        }

        private void updateBoxColour() {
            this.editor.beginUpdate();
            try {
                if (this.fillColor == null) {
                    this.editor.getGraphComponent().setCellStyles("fillOpacity", "0f", this.boxes.toArray());
                } else {
                    this.editor.getGraphComponent().setCellStyles("fillOpacity", "1f", this.boxes.toArray());
                    this.editor.getGraphComponent().setCellStyles(mxConstants.STYLE_FILLCOLOR, mxUtils.hexString((Color)this.fillColor), this.boxes.toArray());
                }
                this.editor.getGraphComponent().setCellStyles("userDefinedFillColour", String.valueOf(true), this.boxes.toArray());
            }
            finally {
                this.endUpdateWithoutAnimation();
            }
        }

        private void endUpdateWithoutAnimation() {
            LayoutSettings layout = ((mmGraph)this.editor.getGraphComponent().getGraph()).getLayoutSettings();
            boolean animateOn = layout.isAnimate();
            if (animateOn) {
                ((mmGraph)this.editor.getGraphComponent().getGraph()).getLayoutSettings().setAnimate(false);
            }
            this.editor.endUpdate();
            if (animateOn) {
                ((mmGraph)this.editor.getGraphComponent().getGraph()).getLayoutSettings().setAnimate(true);
            }
        }

        public void branchShapeChanged(int endStyle) {
            this.branchShape = endStyle;
            this.updateBoxBranchShape();
        }

        private void updateBoxBranchShape() {
            this.editor.beginUpdate();
            try {
                this.editor.getGraphComponent().setCellStyles("organicLevel", Integer.toString(this.branchShape), this.branches.toArray());
            }
            finally {
                this.endUpdateWithoutAnimation();
            }
        }

        public void branchColourChanged(Color branchColourIn) {
            this.branchColour = branchColourIn;
            this.updateBoxBranchColour();
        }

        private void updateBoxBranchColour() {
            this.editor.beginUpdate();
            try {
                if (this.branchColour != null) {
                    this.editor.getGraphComponent().setCellStyles(mxConstants.STYLE_STROKECOLOR, mxUtils.hexString((Color)this.branchColour), this.branches.toArray());
                    this.editor.getGraphComponent().setCellStyles(mxConstants.STYLE_STROKECOLOR, mxUtils.hexString((Color)this.branchColour), this.boxes.toArray());
                }
            }
            finally {
                this.endUpdateWithoutAnimation();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateBoxShape() {
            this.editor.beginUpdate();
            try {
                if (this.shape != null) {
                    this.editor.getGraphComponent().setCellStyles(mxConstants.STYLE_SHAPE, this.shape.getStyle(), this.boxes.toArray());
                    this.editor.getGraphComponent().setLastBoxShape(this.shape.getStyle());
                    for (mmBranchBoxCell box : this.boxes) {
                        this.editor.getGraphComponent().getGraph().getView().removeState((Object)box);
                        for (int edgeIndex = 0; edgeIndex < box.getEdgeCount(); ++edgeIndex) {
                            this.editor.getGraphComponent().getGraph().getView().removeState((Object)box.getEdgeAt(edgeIndex));
                        }
                    }
                }
            }
            finally {
                this.endUpdateWithoutAnimation();
            }
        }

        public BoxTabContent.BoxShape getBoxShape() {
            return this.shape;
        }

        public Color getFillColour() {
            return this.fillColor;
        }

        public void refresh() {
            this.initialiseValues(this.boxes);
        }

        public int getBranchShape() {
            return this.branchShape;
        }

        public Color getBranchColour() {
            return this.branchColour;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ArrowControl
    implements RelationshipTabContent.RelationshipController {
        private final boolean enabled;
        private final List<mmCell> arrows;
        private final IEditorComponent editor;
        private final mmGraph graph;
        private final int defaultSize = 2;
        private int size = mxConstants.DEFAULT_MARKERSIZE;
        private int width = this.defaultSize;
        private RelationshipTabContent.StrokeStyle stroke = RelationshipTabContent.StrokeStyle.DASHED;
        private RelationshipTabContent.ShapeStyle shape = RelationshipTabContent.ShapeStyle.ARROW_CURVE_HORIZONTAL;
        private RelationshipTabContent.Type endType = RelationshipTabContent.Type.CLASSIC;
        private RelationshipTabContent.Type startType = RelationshipTabContent.Type.NONE;
        private Color colour = Color.BLACK;
        private boolean hasChangedShape = false;

        public ArrowControl(IEditorComponent currentEditor, List<mmCell> arrowsIn) {
            this.enabled = arrowsIn.size() > 0;
            this.editor = currentEditor;
            this.arrows = arrowsIn;
            this.graph = (mmGraph)this.editor.getGraphComponent().getGraph();
            if (this.enabled) {
                this.initialiseValues(arrowsIn);
            }
        }

        private void initialiseValues(List<mmCell> arrowsIn) {
            String endSizeString;
            try {
                Object strokeStr = ShowFormatDialogAction.getCellStyle(this.graph, arrowsIn.get(0), mxConstants.STYLE_STROKECOLOR);
                if (strokeStr instanceof String) {
                    this.colour = mxUtils.parseColor((String)((String)strokeStr));
                    this.colour = Color.BLACK;
                }
            }
            catch (Exception ex) {
                LOGGER.warn((Object)"failed to get colour ", (Throwable)ex);
            }
            String end = (String)ShowFormatDialogAction.getCellStyle(this.graph, arrowsIn.get(0), mxConstants.STYLE_ENDARROW);
            this.endType = end == null ? RelationshipTabContent.Type.NONE : RelationshipTabContent.Type.getType((String)end);
            String start = (String)ShowFormatDialogAction.getCellStyle(this.graph, arrowsIn.get(0), mxConstants.STYLE_STARTARROW);
            this.startType = start == null ? RelationshipTabContent.Type.NONE : RelationshipTabContent.Type.getType((String)start);
            String styleString = (String)ShowFormatDialogAction.getCellStyle(this.graph, arrowsIn.get(0), "arrowStyle");
            this.stroke = styleString == null ? RelationshipTabContent.StrokeStyle.SOLID : RelationshipTabContent.StrokeStyle.getStyle((String)styleString);
            if (arrowsIn.get(0) instanceof mmRelationshipCell) {
                String shapeString = (String)ShowFormatDialogAction.getCellStyle(this.graph, arrowsIn.get(0), mxConstants.STYLE_SHAPE);
                String edgeString = (String)ShowFormatDialogAction.getCellStyle(this.graph, arrowsIn.get(0), mxConstants.STYLE_EDGE);
                String elbowString = (String)ShowFormatDialogAction.getCellStyle(this.graph, arrowsIn.get(0), mxConstants.STYLE_ELBOW);
                this.shape = shapeString == null ? RelationshipTabContent.ShapeStyle.ARROW_CURVE_HORIZONTAL : (shapeString.equalsIgnoreCase("connector") ? (elbowString == null ? RelationshipTabContent.ShapeStyle.CONNECTOR_STRAIGHT : (elbowString.equalsIgnoreCase("vertical") ? RelationshipTabContent.ShapeStyle.CONNECTOR_ELBOW_VERTICAL : RelationshipTabContent.ShapeStyle.CONNECTOR_ELBOW_HORIZONTAL)) : (edgeString != null && edgeString.equalsIgnoreCase("elbowEdgeStyle") ? (elbowString != null && elbowString.equalsIgnoreCase("vertical") ? RelationshipTabContent.ShapeStyle.ARROW_ELBOW_VERTICAL : RelationshipTabContent.ShapeStyle.ARROW_ELBOW_HORIZONTAL) : (elbowString != null && elbowString.equalsIgnoreCase("vertical") ? RelationshipTabContent.ShapeStyle.ARROW_CURVE_VERTICAL : RelationshipTabContent.ShapeStyle.ARROW_CURVE_HORIZONTAL)));
            } else {
                this.shape = null;
            }
            String widthString = (String)ShowFormatDialogAction.getCellStyle(this.graph, arrowsIn.get(0), mxConstants.STYLE_STROKEWIDTH);
            if (widthString != null) {
                this.width = Integer.valueOf(widthString);
            }
            if ((endSizeString = (String)ShowFormatDialogAction.getCellStyle(this.graph, arrowsIn.get(0), mxConstants.STYLE_ENDSIZE)) == null) {
                String startSizeString = (String)ShowFormatDialogAction.getCellStyle(this.graph, arrowsIn.get(0), mxConstants.STYLE_STARTSIZE);
                if (startSizeString != null) {
                    this.size = Integer.valueOf(startSizeString);
                }
            } else {
                this.size = Integer.valueOf(endSizeString);
            }
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void endTypeChanged(RelationshipTabContent.Type endTypeIn) {
            this.endType = endTypeIn;
            this.updateArrowEndType();
        }

        private void updateArrowEndType() {
            this.editor.beginUpdate();
            try {
                if (this.endType != null) {
                    this.editor.getGraphComponent().setCellStyles(mxConstants.STYLE_ENDARROW, this.endType.getStyle(), this.arrows.toArray());
                }
            }
            finally {
                this.editor.endUpdate();
            }
        }

        public void arrowColourChanged(Color arrowColour) {
            this.colour = arrowColour;
            this.updateArrowColour();
        }

        private void updateArrowColour() {
            this.editor.beginUpdate();
            try {
                if (this.colour != null) {
                    this.editor.getGraphComponent().setCellStyles(mxConstants.STYLE_STROKECOLOR, mxUtils.hexString((Color)this.colour), this.arrows.toArray());
                }
            }
            finally {
                this.editor.endUpdate();
            }
        }

        public void widthChanged(int arrowWidth) {
            this.width = arrowWidth;
            this.updateArrowWidth();
        }

        private void updateArrowWidth() {
            this.editor.beginUpdate();
            try {
                if (this.width > 0) {
                    this.editor.getGraphComponent().setCellStyles(mxConstants.STYLE_STROKEWIDTH, Integer.toString(this.width), this.arrows.toArray());
                }
            }
            finally {
                this.editor.endUpdate();
            }
        }

        public void startTypeChanged(RelationshipTabContent.Type startTypeIn) {
            this.startType = startTypeIn;
            this.updateArrowStartType();
        }

        private void updateArrowStartType() {
            this.editor.beginUpdate();
            try {
                if (this.startType != null) {
                    this.editor.getGraphComponent().setCellStyles(mxConstants.STYLE_STARTARROW, this.startType.getStyle(), this.arrows.toArray());
                }
            }
            finally {
                this.editor.endUpdate();
            }
        }

        public void sizeChanged(int arrowSize) {
            this.size = arrowSize;
            this.updateArrowSize();
        }

        private void updateArrowSize() {
            this.editor.beginUpdate();
            try {
                if (this.size > 0) {
                    this.editor.getGraphComponent().setCellStyles(mxConstants.STYLE_ENDSIZE, Integer.toString(this.size), this.arrows.toArray());
                    this.editor.getGraphComponent().setCellStyles(mxConstants.STYLE_STARTSIZE, Integer.toString(this.size), this.arrows.toArray());
                }
            }
            finally {
                this.editor.endUpdate();
            }
        }

        public void strokeStyleChanged(RelationshipTabContent.StrokeStyle arrowStyle) {
            this.stroke = arrowStyle;
            this.updateArrowStroke();
        }

        private void updateArrowStroke() {
            this.editor.beginUpdate();
            try {
                if (this.stroke != null) {
                    this.editor.getGraphComponent().setCellStyles("arrowStyle", this.stroke.getStyle(), this.arrows.toArray());
                }
            }
            finally {
                this.editor.endUpdate();
            }
        }

        public void shapeStyleChanged(RelationshipTabContent.ShapeStyle arrowStyle) {
            if (this.shape != null) {
                this.shape = arrowStyle;
                this.hasChangedShape = true;
                this.updateArrowShape();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void updateArrowShape() {
            this.editor.beginUpdate();
            try {
                if (this.shape == null) return;
                if (this.hasChangedShape) {
                    for (mmCell cell : this.arrows) {
                        this.graph.resetEdge((Object)cell);
                    }
                }
                switch (this.shape) {
                    case ARROW_CURVE_HORIZONTAL: {
                        this.editor.getGraphComponent().setCellStyles(mxConstants.STYLE_SHAPE, mmConstants.SHAPE_ARROW, this.arrows.toArray());
                        this.editor.getGraphComponent().setCellStyles(mxConstants.STYLE_EDGE, mmConstants.EDGESTYLE_ARROW, this.arrows.toArray());
                        this.editor.getGraphComponent().setCellStyles(mxConstants.STYLE_ELBOW, "horizontal", this.arrows.toArray());
                        return;
                    }
                    case ARROW_CURVE_VERTICAL: {
                        this.editor.getGraphComponent().setCellStyles(mxConstants.STYLE_SHAPE, mmConstants.SHAPE_ARROW, this.arrows.toArray());
                        this.editor.getGraphComponent().setCellStyles(mxConstants.STYLE_EDGE, mmConstants.EDGESTYLE_ARROW, this.arrows.toArray());
                        this.editor.getGraphComponent().setCellStyles(mxConstants.STYLE_ELBOW, "vertical", this.arrows.toArray());
                        return;
                    }
                    case ARROW_ELBOW_HORIZONTAL: {
                        this.editor.getGraphComponent().setCellStyles(mxConstants.STYLE_SHAPE, mmConstants.SHAPE_ARROW, this.arrows.toArray());
                        this.editor.getGraphComponent().setCellStyles(mxConstants.STYLE_EDGE, "arrowElbowEdgeStyle", this.arrows.toArray());
                        this.editor.getGraphComponent().setCellStyles(mxConstants.STYLE_ELBOW, "horizontal", this.arrows.toArray());
                        return;
                    }
                    case ARROW_ELBOW_VERTICAL: {
                        this.editor.getGraphComponent().setCellStyles(mxConstants.STYLE_SHAPE, mmConstants.SHAPE_ARROW, this.arrows.toArray());
                        this.editor.getGraphComponent().setCellStyles(mxConstants.STYLE_EDGE, "arrowElbowEdgeStyle", this.arrows.toArray());
                        this.editor.getGraphComponent().setCellStyles(mxConstants.STYLE_ELBOW, "vertical", this.arrows.toArray());
                        return;
                    }
                    case CONNECTOR_ELBOW_HORIZONTAL: {
                        this.editor.getGraphComponent().setCellStyles(mxConstants.STYLE_SHAPE, "connector", this.arrows.toArray());
                        this.editor.getGraphComponent().setCellStyles(mxConstants.STYLE_EDGE, "elbowEdgeStyle", this.arrows.toArray());
                        this.editor.getGraphComponent().setCellStyles(mxConstants.STYLE_ELBOW, "horizontal", this.arrows.toArray());
                        return;
                    }
                    case CONNECTOR_ELBOW_VERTICAL: {
                        this.editor.getGraphComponent().setCellStyles(mxConstants.STYLE_SHAPE, "connector", this.arrows.toArray());
                        this.editor.getGraphComponent().setCellStyles(mxConstants.STYLE_EDGE, "elbowEdgeStyle", this.arrows.toArray());
                        this.editor.getGraphComponent().setCellStyles(mxConstants.STYLE_ELBOW, "vertical", this.arrows.toArray());
                        return;
                    }
                    case CONNECTOR_STRAIGHT: {
                        this.editor.getGraphComponent().setCellStyles(mxConstants.STYLE_SHAPE, "connector", this.arrows.toArray());
                        this.editor.runAction((AbstractEditorAction)new RemoveCellStyleAction(mxConstants.STYLE_EDGE, this.arrows.toArray()));
                        this.editor.runAction((AbstractEditorAction)new RemoveCellStyleAction(mxConstants.STYLE_ELBOW, this.arrows.toArray()));
                        return;
                    }
                }
                return;
            }
            finally {
                this.editor.endUpdate();
            }
        }

        public Color getColour() {
            return this.colour;
        }

        public int getArrowWidth() {
            return this.width;
        }

        public int getArrowSize() {
            return this.size;
        }

        public RelationshipTabContent.Type getStartType() {
            return this.startType;
        }

        public RelationshipTabContent.Type getEndType() {
            return this.endType;
        }

        public RelationshipTabContent.StrokeStyle getArrowStrokeStyle() {
            return this.stroke;
        }

        public RelationshipTabContent.ShapeStyle getArrowShapeStyle() {
            return this.shape;
        }

        public void refresh() {
            this.initialiseValues(this.arrows);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BoundaryControl
    implements BoundaryTabContent.BoundaryController {
        private final boolean enabled;
        private static final int DEFAULT = 50;
        private final List<mmBoundaryCell> boundaries;
        private final IEditorComponent editor;
        private final mmGraph graph;
        private Color fillColor;
        private Color lineColor;
        private Integer frequencyValue;
        private Integer amplitudeValue;
        private Integer paddingValue;
        private BoundaryTabContent.CloudShape cloudShape;

        public BoundaryControl(IEditorComponent currentEditor, List<mmBoundaryCell> boundariesIn) {
            this.editor = currentEditor;
            this.boundaries = boundariesIn;
            this.graph = (mmGraph)this.editor.getGraphComponent().getGraph();
            boolean bl = this.enabled = boundariesIn.size() > 0;
            if (this.enabled) {
                this.initialiseValues(boundariesIn);
            }
        }

        private void initialiseValues(List<mmBoundaryCell> boundariesIn) {
            String stroke = (String)ShowFormatDialogAction.getCellStyle(this.graph, boundariesIn.get(0), mxConstants.STYLE_STROKECOLOR);
            String fill = (String)ShowFormatDialogAction.getCellStyle(this.graph, boundariesIn.get(0), mxConstants.STYLE_FILLCOLOR);
            if (stroke != null) {
                this.lineColor = mxUtils.parseColor((String)stroke);
            }
            if (fill != null) {
                this.fillColor = mxUtils.parseColor((String)fill);
            }
            Map style = this.graph.getView().getState((Object)boundariesIn.get(0)).getStyle();
            this.frequencyValue = mxUtils.getInt((Map)style, (String)"bFrequency", (int)50);
            this.amplitudeValue = mxUtils.getInt((Map)style, (String)"bAmplitude", (int)50);
            this.paddingValue = mxUtils.getInt((Map)style, (String)"bPadding", (int)50);
            this.cloudShape = BoundaryTabContent.CloudShape.getShape((String)((String)style.get("bShape")));
            if (boundariesIn.size() > 1) {
                for (int i = 1; i < boundariesIn.size(); ++i) {
                    String tmpStroke = (String)ShowFormatDialogAction.getCellStyle(this.graph, boundariesIn.get(0), mxConstants.STYLE_STROKECOLOR);
                    String tmpFill = (String)ShowFormatDialogAction.getCellStyle(this.graph, boundariesIn.get(0), mxConstants.STYLE_FILLCOLOR);
                    if (this.lineColor != null && stroke != null && !stroke.equals(tmpStroke)) {
                        this.lineColor = null;
                    }
                    if (this.fillColor == null || fill == null || fill.equals(tmpFill)) continue;
                    this.fillColor = null;
                }
                this.frequencyValue = null;
                this.amplitudeValue = null;
                this.paddingValue = null;
                this.cloudShape = null;
            }
        }

        public void fillColorChanged(Color color) {
            this.fillColor = color;
            this.updateBoundaryFillColour();
        }

        private void updateBoundaryFillColour() {
            this.editor.beginUpdate();
            try {
                if (this.fillColor != null) {
                    this.editor.getGraphComponent().getGraph().setCellStyles(mxConstants.STYLE_FILLCOLOR, Integer.toHexString(this.fillColor.getRGB()), this.boundaries.toArray());
                }
            }
            finally {
                this.editor.endUpdate();
            }
        }

        public Color getFillColor() {
            return this.fillColor;
        }

        public Color getLineColor() {
            return this.lineColor;
        }

        public void lineColorChanged(Color color) {
            this.lineColor = color;
            this.updateBoundaryLineColour();
        }

        private void updateBoundaryLineColour() {
            this.editor.beginUpdate();
            try {
                if (this.lineColor != null) {
                    this.editor.getGraphComponent().getGraph().setCellStyles(mxConstants.STYLE_STROKECOLOR, Integer.toHexString(this.lineColor.getRGB()), this.boundaries.toArray());
                }
            }
            finally {
                this.editor.endUpdate();
            }
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public Integer getAmplitude() {
            return this.amplitudeValue;
        }

        public Integer getFrequency() {
            return this.frequencyValue;
        }

        public Integer getPadding() {
            return this.paddingValue;
        }

        public void setAmplitude(Integer newValue) {
            this.amplitudeValue = newValue;
            this.updateBoundaryAmplitude();
        }

        private void updateBoundaryAmplitude() {
            this.editor.beginUpdate();
            try {
                if (this.amplitudeValue != null) {
                    this.editor.getGraphComponent().getGraph().setCellStyles("bAmplitude", Integer.toString(this.amplitudeValue), this.boundaries.toArray());
                }
            }
            finally {
                this.editor.endUpdate();
            }
        }

        public void setFrequency(Integer newValue) {
            this.frequencyValue = newValue;
            this.updateBoundaryFrequency();
        }

        private void updateBoundaryFrequency() {
            this.editor.beginUpdate();
            try {
                if (this.frequencyValue != null) {
                    this.editor.getGraphComponent().getGraph().setCellStyles("bFrequency", Integer.toString(this.frequencyValue), this.boundaries.toArray());
                }
            }
            finally {
                this.editor.endUpdate();
            }
        }

        public void setPadding(Integer newValue) {
            this.paddingValue = newValue;
            this.updateBoundaryPadding();
        }

        private void updateBoundaryPadding() {
            this.editor.beginUpdate();
            try {
                if (this.paddingValue != null) {
                    this.editor.getGraphComponent().getGraph().setCellStyles("bPadding", Integer.toString(this.paddingValue), this.boundaries.toArray());
                }
            }
            finally {
                this.editor.endUpdate();
            }
        }

        public BoundaryTabContent.CloudShape getShape() {
            return this.cloudShape;
        }

        public void setShape(BoundaryTabContent.CloudShape shape) {
            this.cloudShape = shape;
            this.updateBoundaryShape();
        }

        private void updateBoundaryShape() {
            this.editor.beginUpdate();
            try {
                if (this.cloudShape != null) {
                    this.editor.getGraphComponent().getGraph().setCellStyles("bShape", this.cloudShape.getStyle(), this.boundaries.toArray());
                }
            }
            finally {
                this.editor.endUpdate();
            }
        }

        public void delete() {
            this.graph.getModel().beginUpdate();
            try {
                this.graph.removeCells(this.boundaries.toArray());
            }
            finally {
                this.graph.getModel().endUpdate();
            }
        }

        public void refresh() {
            this.initialiseValues(this.boundaries);
        }
    }
}

