/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.actions;

import com.buzanonline.chaos.preferences.Preferences;
import com.buzanonline.chaos.systemstate.ISystemState;
import com.jidesoft.utils.SystemInfo;
import com.thinkbuzan.apollo.dialogs.mac.imagechooser.MacCentralIdeaChooser;
import com.thinkbuzan.apollo.dialogs.mac.imagechooser.MacCentralIdeaChooserOption;
import com.thinkbuzan.apollo.dialogs.mac.imagechooser.MacCentralIdeaHelper;
import com.thinkbuzan.chaos.internationalization.I18n;
import com.thinkbuzan.gaia.action.AbstractOSGiAction;
import com.thinkbuzan.gaia.action.OSGiManager;
import com.thinkbuzan.gaia.action.license.BundleLicenser;
import com.thinkbuzan.gaia.entities.MindMapImage;
import com.thinkbuzan.gaia.recentfiles.RecentFiles;
import com.thinkbuzan.gaia.recentfiles.RecentFilesChangedListener;
import com.thinkbuzan.pascal.services.editor.IdeaImage;
import com.thinkbuzan.pascal.services.editor.ideaimages.IIdeaInserter;
import com.thinkbuzan.pascal.services.editor.ideaimages.IdeaImages;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;
import org.osgi.framework.BundleContext;

public class ShowMacCentralIdeaChooserAction
extends AbstractOSGiAction {
    private static final String CREATIVE_THEME = "644b2a25-c97e-4cb2-8928-5cce7bba23d0";
    private static final String PRO_THEME = "f503e61f-5a7f-46b7-b94a-e05563ecc47d";
    private static final String BS_THEME = "20872e30-4e39-11e4-916c-0800200c9a66";
    private static final String FAST_CAPTURE_THEME = "FAST_CAPTURE_THEME";
    private static final String TIMELINE_THEME = "TIMELINE_THEME";
    private static final String BRAINSTORM_DEFAULT_CI_ID = "cec2c159-46de-4468-818e-9bbeb5e9039e";
    private static final UUID BRAINSTORM_DEFAULT_CI_UUID = UUID.fromString("cec2c159-46de-4468-818e-9bbeb5e9039e");
    private static final String FAST_CAPTURE_DEFAULT_CI_ID = "cec2c159-46de-4468-818e-9bbeb5e9039e";
    private static final UUID FAST_CAPTURE_DEFAULT_CI_UUID = UUID.fromString("cec2c159-46de-4468-818e-9bbeb5e9039e");
    private MacCentralIdeaChooser dialog;
    private transient IIdeaInserter newMapInserter;
    private transient IIdeaInserter existingMapInserter;

    public ShowMacCentralIdeaChooserAction(BundleContext context) {
        super(context);
        this.changeState(true);
        this.newMapInserter = this.createNewMapInserter();
        this.existingMapInserter = this.createExistingMapInserter();
        if (OSGiManager.getPreferencesService() != null && SystemInfo.isAnyMac()) {
            this.dialog = new MacCentralIdeaChooser(OSGiManager.getI18n(), OSGiManager.getEditorManager(), OSGiManager.getActionManager(), OSGiManager.getPendingTdViewInterface(), BundleLicenser.isBrainstormLicensed(), BundleLicenser.isPresentationLicensed(), BundleLicenser.isFastCaptureLicensed(), BundleLicenser.isTimelineLicensed());
            try {
                final RecentFiles rf = OSGiManager.getRecentFiles();
                if (rf != null) {
                    this.dialog.setRecentFiles(rf);
                    rf.addRecentFilesChangedListener(new RecentFilesChangedListener(){

                        public void recentFilesChanged() {
                            ShowMacCentralIdeaChooserAction.this.dialog.setRecentFiles(rf);
                        }
                    });
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private IIdeaInserter createNewMapInserter() {
        return new IIdeaInserter(){

            public void start() {
                if (OSGiManager.getActionManager().isActionRegistered("com.thinkbuzan.gaia.actions.NewNewAction")) {
                    if (ShowMacCentralIdeaChooserAction.this.dialog.getCurrentOption() == MacCentralIdeaChooserOption.CAPTURE) {
                        OSGiManager.getActionManager().runAction("com.thinkbuzan.gaia.actions.NewNewAction", new Object[]{FAST_CAPTURE_DEFAULT_CI_UUID, ShowMacCentralIdeaChooserAction.FAST_CAPTURE_THEME, ShowMacCentralIdeaChooserAction.this.dialog.getSelectedFastCaptureName()});
                    } else if (ShowMacCentralIdeaChooserAction.this.dialog.getCurrentOption() == MacCentralIdeaChooserOption.ORGANISE) {
                        OSGiManager.getActionManager().runAction("com.thinkbuzan.gaia.actions.NewNewAction", new Object[]{BRAINSTORM_DEFAULT_CI_UUID, ShowMacCentralIdeaChooserAction.BS_THEME, ShowMacCentralIdeaChooserAction.this.dialog.getSelectedBrainstormName()});
                    } else if (ShowMacCentralIdeaChooserAction.this.dialog.getCurrentOption() == MacCentralIdeaChooserOption.TIMEMAP) {
                        OSGiManager.getActionManager().runAction("com.thinkbuzan.gaia.actions.NewNewAction", new Object[]{BRAINSTORM_DEFAULT_CI_UUID, ShowMacCentralIdeaChooserAction.TIMELINE_THEME, ShowMacCentralIdeaChooserAction.this.dialog.getSelectedTimeMapName()});
                    } else {
                        String themeSelection = ShowMacCentralIdeaChooserAction.this.dialog.getTheme();
                        String theme = themeSelection == null ? OSGiManager.getPreferencesService().getCurrentUserPreferences().get("com.thinkbuzan.gaia.theme.defaultid", ShowMacCentralIdeaChooserAction.CREATIVE_THEME) : (ShowMacCentralIdeaChooserAction.this.dialog.getCurrentOption() == MacCentralIdeaChooserOption.ORGANISE ? ShowMacCentralIdeaChooserAction.PRO_THEME : themeSelection);
                        UUID ideaId = ShowMacCentralIdeaChooserAction.this.dialog.getSelectedIdeaId();
                        OSGiManager.getActionManager().runAction("com.thinkbuzan.gaia.actions.NewNewAction", new Object[]{ideaId, theme, OSGiManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.idea")});
                    }
                }
            }

            public void start(Image localSelected) {
                if (localSelected != null) {
                    String themeSelection = ShowMacCentralIdeaChooserAction.this.dialog.getTheme();
                    String theme = themeSelection == null ? OSGiManager.getPreferencesService().getCurrentUserPreferences().get("com.thinkbuzan.gaia.theme.defaultid", ShowMacCentralIdeaChooserAction.CREATIVE_THEME) : (ShowMacCentralIdeaChooserAction.this.dialog.getCurrentOption() == MacCentralIdeaChooserOption.ORGANISE ? ShowMacCentralIdeaChooserAction.PRO_THEME : themeSelection);
                    OSGiManager.getActionManager().runAction("com.thinkbuzan.gaia.actions.NewNewAction", new Object[]{null, theme});
                    try {
                        ByteArrayOutputStream os = new ByteArrayOutputStream();
                        ImageIO.write((RenderedImage)((BufferedImage)localSelected), "png", os);
                        ByteArrayInputStream fis = new ByteArrayInputStream(os.toByteArray());
                        MindMapImage mindMapImage = new MindMapImage((InputStream)fis, (double)localSelected.getWidth(null), (double)localSelected.getHeight(null));
                        OSGiManager.getActionManager().runAction("com.thinkbuzan.gaia.actions.InsertFloatingIdeaAction", new Object[]{mindMapImage});
                    }
                    catch (IOException ioe) {
                        Logger.getLogger(this.getClass()).error((Object)"cannot insert local image", (Throwable)ioe);
                    }
                }
            }
        };
    }

    private IIdeaInserter createExistingMapInserter() {
        return new IIdeaInserter(){

            public void start() {
                ShowMacCentralIdeaChooserAction.this.insertIdea();
                ShowMacCentralIdeaChooserAction.this.dialog.setVisible(false);
            }

            public void start(Image localSelected) {
                ShowMacCentralIdeaChooserAction.this.insertIdea(localSelected);
                ShowMacCentralIdeaChooserAction.this.dialog.setVisible(false);
            }
        };
    }

    public String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void runAction(Object ... parameters) {
        try {
            if (OSGiManager.getActionManager().isActionRegistered("com.thinkbuzan.gaia.actions.ExitPresentationAction")) {
                OSGiManager.getActionManager().runAction("com.thinkbuzan.gaia.actions.ExitPresentationAction", new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (parameters.length == 1 && parameters[0] instanceof Boolean) {
            boolean createNewMap = (Boolean)parameters[0];
            if (createNewMap) {
                this.dialog.show(MacCentralIdeaChooserOption.DEVELOP, new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ShowMacCentralIdeaChooserAction.this.newMapInserter.start();
                    }
                }, new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ShowMacCentralIdeaChooserAction.this.processBrowseOptionNew();
                    }
                });
            } else {
                this.dialog.show(MacCentralIdeaChooserOption.NONE, new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ShowMacCentralIdeaChooserAction.this.existingMapInserter.start();
                    }
                }, new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ShowMacCentralIdeaChooserAction.this.processBrowseOptionInsert();
                    }
                });
            }
        } else if (parameters.length == 2 && parameters[1] instanceof Boolean) {
            this.dialog.show(MacCentralIdeaChooserOption.CAPTURE, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ShowMacCentralIdeaChooserAction.this.newMapInserter.start();
                }
            }, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ShowMacCentralIdeaChooserAction.this.processBrowseOptionNew();
                }
            });
        } else if (parameters.length == 3) {
            MacCentralIdeaChooserOption option = MacCentralIdeaChooserOption.ACTION;
            if (parameters[2] instanceof MacCentralIdeaChooserOption) {
                option = (MacCentralIdeaChooserOption)parameters[2];
            }
            this.dialog.show(option, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ShowMacCentralIdeaChooserAction.this.newMapInserter.start();
                }
            }, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ShowMacCentralIdeaChooserAction.this.processBrowseOptionNew();
                }
            });
        }
    }

    private final void processBrowseOptionNew() {
        switch (this.dialog.getCurrentOption()) {
            case CAPTURE: 
            case ACTION: {
                break;
            }
            case DEVELOP: 
            case NONE: 
            case ORGANISE: {
                Image selectedLocalImage = MacCentralIdeaHelper.pickImageFile((I18n)OSGiManager.getI18n(), (Preferences)OSGiManager.getPreferencesService().getCurrentUserPreferences());
                if (selectedLocalImage == null) break;
                this.newMapInserter.start(selectedLocalImage);
            }
        }
    }

    private final void processBrowseOptionInsert() {
        switch (this.dialog.getCurrentOption()) {
            case CAPTURE: 
            case ACTION: {
                break;
            }
            case DEVELOP: 
            case NONE: 
            case ORGANISE: {
                Image selectedLocalImage = MacCentralIdeaHelper.pickImageFile((I18n)OSGiManager.getI18n(), (Preferences)OSGiManager.getPreferencesService().getCurrentUserPreferences());
                if (selectedLocalImage == null) break;
                this.insertIdea(selectedLocalImage);
            }
        }
    }

    private void insertIdea(Image localSelected) {
        if (localSelected != null && localSelected instanceof BufferedImage) {
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)((BufferedImage)localSelected), "png", os);
                ByteArrayInputStream fis = new ByteArrayInputStream(os.toByteArray());
                MindMapImage mindMapImage = new MindMapImage((InputStream)fis, (double)localSelected.getWidth(null), (double)localSelected.getHeight(null));
                OSGiManager.getActionManager().runAction("com.thinkbuzan.gaia.actions.InsertFloatingIdeaAction", new Object[]{mindMapImage});
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void insertIdea() {
        IdeaImage ideaImage = IdeaImages.getIdeaImage((UUID)this.dialog.getSelectedIdeaId());
        Dimension imageSize = IdeaImages.getSize((IdeaImage)ideaImage);
        InputStream inputStream = IdeaImages.getInputStream((IdeaImage)ideaImage);
        MindMapImage mindMapImage = new MindMapImage(inputStream, (double)imageSize.width, (double)imageSize.height);
        OSGiManager.getActionManager().runAction("com.thinkbuzan.gaia.actions.InsertFloatingIdeaAction", new Object[]{mindMapImage});
    }

    public void systemStateChanged(ISystemState systemState) {
    }
}

