/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.actions;

import com.buzanonline.chaos.systemstate.ISystemState;
import com.thinkbuzan.apollo.dialogs.notifications.NotificationsDialog;
import com.thinkbuzan.chaos.osgiutilities.service.IServiceListener;
import com.thinkbuzan.chaos.osgiutilities.service.PendingServiceManager;
import com.thinkbuzan.gaia.action.AbstractOSGiAction;
import com.thinkbuzan.gaia.action.OSGiManager;
import com.thinkbuzan.gaia.ui.MainFrameUtilities;
import com.thinkbuzan.pascal.services.notifications.INotificationController;
import java.awt.Desktop;
import java.net.URL;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;

public class ShowNotificationsDialogAction
extends AbstractOSGiAction {
    private NotificationsDialog dialog;

    public ShowNotificationsDialogAction(BundleContext context) {
        super(context);
        this.changeState(true);
    }

    public void runAction(Object ... parameters) {
        boolean useJfx;
        boolean bl = useJfx = !this.useJavaDialogs() || this.useJavaFXVideo();
        if (useJfx) {
            if (this.dialog == null && parameters.length > 0) {
                if (parameters[0] instanceof PendingServiceManager) {
                    PendingServiceManager service = (PendingServiceManager)parameters[0];
                    service.addListener((IServiceListener)new IServiceListener<INotificationController>(){

                        public void serviceRemoved(INotificationController service) {
                        }

                        public void serviceAdded(INotificationController service) {
                            ShowNotificationsDialogAction.this.dialog = new NotificationsDialog(MainFrameUtilities.getMainFrame(), OSGiManager.getI18n(), service, OSGiManager.getPreferencesService().getSystemPreferences());
                        }
                    });
                } else if (parameters[0] instanceof INotificationController) {
                    this.dialog = new NotificationsDialog(MainFrameUtilities.getMainFrame(), OSGiManager.getI18n(), (INotificationController)parameters[0], OSGiManager.getPreferencesService().getSystemPreferences());
                }
            }
            if (this.dialog != null) {
                this.dialog.setVisible(true);
            }
        } else {
            String defaultLocale = Locale.getDefault().toString();
            String userLocale = OSGiManager.getPreferencesService().getSystemPreferences().get("user.locale", defaultLocale);
            boolean jp = userLocale.toString().equals(Locale.JAPANESE.toString()) || userLocale.toString().equals(Locale.JAPAN.toString());
            String url = jp ? NotificationsDialog.NOTIFICATIONS_URL_JP : NotificationsDialog.NOTIFICATIONS_URL;
            this.launchExternally(url);
        }
    }

    private void launchExternally(String href) {
        Desktop desktop;
        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
            try {
                URL uri = new URL(href);
                desktop.browse(uri.toURI());
            }
            catch (Exception e) {
                Logger.getLogger(NotificationsDialog.class).warn((Object)"Failed to open notifications page");
            }
        }
    }

    private boolean useJavaDialogs() {
        String key = "com.thinkbuzan.dozer.javaDialog";
        boolean defaultValue = true;
        boolean defaultSystemValue = true;
        return this.getKeyCheckingSystemOverride("com.thinkbuzan.dozer.javaDialog", true, true);
    }

    private boolean useJavaFXVideo() {
        String key = "com.thinkbuzan.gaia.jfxvideo";
        boolean defaultValue = true;
        boolean defaultSystemValue = false;
        return this.getKeyCheckingSystemOverride("com.thinkbuzan.gaia.jfxvideo", false, true);
    }

    private boolean getKeyCheckingSystemOverride(String key, boolean defaultSystemValue, boolean defaultValue) {
        boolean systemValueExists = false;
        try {
            String[] keys;
            for (String k : keys = OSGiManager.getPreferencesService().getSystemPreferences().keys()) {
                if (!k.equals(key)) continue;
                systemValueExists = true;
                break;
            }
        }
        catch (BackingStoreException e) {
            systemValueExists = false;
        }
        boolean value = systemValueExists ? OSGiManager.getPreferencesService().getSystemPreferences().getBoolean(key, defaultSystemValue) : OSGiManager.getPreferencesService().getCurrentUserPreferences().getBoolean(key, defaultValue);
        return value;
    }

    public void systemStateChanged(ISystemState systemState) {
    }

    public String getId() {
        return "com.thinkbuzan.gaia.action.ShowNotificationsDialogAction";
    }
}

