/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.actions;

import com.buzanonline.chaos.systemstate.ISystemState;
import com.mxgraph.mindmap.model.mmCell;
import com.thinkbuzan.gaia.action.AbstractOSGiAction;
import com.thinkbuzan.gaia.action.OSGiManager;
import com.thinkbuzan.gaia.dialogs.ui.v2.AbstractShowHideDialog;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.editor.actions.AbstractEditorAction;
import com.thinkbuzan.gaia.editor.actions.ShowHideAttachmentAction;
import com.thinkbuzan.gaia.editor.actions.ShowHideAudioNotesAction;
import com.thinkbuzan.gaia.editor.actions.ShowHideCollapseAction;
import com.thinkbuzan.gaia.editor.actions.ShowHideControlsAction;
import com.thinkbuzan.gaia.editor.actions.ShowHideGridAction;
import com.thinkbuzan.gaia.editor.actions.ShowHideIconAction;
import com.thinkbuzan.gaia.editor.actions.ShowHideLinkAction;
import com.thinkbuzan.gaia.editor.actions.ShowHideNotesAction;
import com.thinkbuzan.gaia.editor.actions.ShowHideOrderingAction;
import com.thinkbuzan.gaia.editor.actions.ShowHidePinnedAction;
import com.thinkbuzan.gaia.editor.actions.ShowHideTagsAction;
import com.thinkbuzan.gaia.editor.actions.ShowHideTaskAction;
import com.thinkbuzan.gaia.editor.actions.ShowHideTaskTimelineAction;
import com.thinkbuzan.gaia.editor.actionsupport.SelectionSupport;
import com.thinkbuzan.gaia.editor.actionsupport.ViewTypeSupport;
import com.thinkbuzan.gaia.ui.MainFrameUtilities;
import com.thinkbuzan.gaia.ui.v2.factory.UIFactory;
import java.awt.Component;
import java.util.List;
import org.apache.log4j.Logger;
import org.osgi.framework.BundleContext;

public class ShowShowAndHideSettingsAction
extends AbstractOSGiAction {
    private static final String SHOW_BRANCH_EDITOR_PREFERENCE = "com.thinkbuzan.dozer.showBranchEditor";
    private final transient SelectionSupport selectionSupport;
    private final transient ViewTypeSupport viewTypeSupport;
    private transient boolean enabledForEditorComponent;

    public ShowShowAndHideSettingsAction(BundleContext context) {
        super(context);
        this.selectionSupport = new SelectionSupport(context){

            public void updateState(IEditorComponent editorComponent, List<mmCell> selectionCells) {
                ShowShowAndHideSettingsAction.this.enabledForEditorComponent = ShowShowAndHideSettingsAction.this.selectionSupport.getCurrentEditor() != null;
                ShowShowAndHideSettingsAction.this.changeState(ShowShowAndHideSettingsAction.this.isEnabled());
            }
        };
        this.viewTypeSupport = new ViewTypeSupport(context){

            public void updateState() {
                ShowShowAndHideSettingsAction.this.changeState(ShowShowAndHideSettingsAction.this.isEnabled());
            }
        };
        this.changeState(false);
    }

    private boolean isEnabled() {
        return this.enabledForEditorComponent && (ViewTypeSupport.MIND_MAP_VIEW_ID.equals(this.viewTypeSupport.getViewId()) || ViewTypeSupport.TD_VIEW_ID.equals(this.viewTypeSupport.getViewId()));
    }

    public final String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public final void runAction(Object ... parameters) {
        if (!this.isEnabled()) {
            return;
        }
        IEditorComponent editor = this.selectionSupport.getCurrentEditor();
        AbstractShowHideDialog showHideDialog = UIFactory.createShowHideDialog(MainFrameUtilities.getMainFrame(), new Controller(editor));
        showHideDialog.getDialog().setLocationRelativeTo((Component)editor.getGraphComponent());
        showHideDialog.getDialog().setVisible(true);
    }

    public final void systemStateChanged(ISystemState systemState) {
    }

    private static final class Controller
    implements AbstractShowHideDialog.Controller {
        private final transient IEditorComponent editorComponent;

        private Controller(IEditorComponent editorComponentIn) {
            this.editorComponent = editorComponentIn;
        }

        public boolean isShowCollapseIcons() {
            return this.editorComponent.getGraphComponent().isShowCollapseIcon();
        }

        public boolean isShowComments() {
            return this.editorComponent.getGraphComponent().isShowComments();
        }

        public boolean isShowIcons() {
            return this.editorComponent.getGraphComponent().isShowIcon();
        }

        public boolean isShowAttachments() {
            return this.editorComponent.getGraphComponent().isShowAttachmentsIcon();
        }

        public boolean isShowLinks() {
            return this.editorComponent.getGraphComponent().isShowLinkIcon();
        }

        public boolean isShowNotes() {
            return this.editorComponent.getGraphComponent().isShowNotesIcon();
        }

        public boolean isShowTags() {
            return this.editorComponent.getGraphComponent().isShowTagsIcon();
        }

        public boolean isShowAudioNotes() {
            return this.editorComponent.getGraphComponent().isShowAudioNotesIcon();
        }

        public boolean isShowTasks() {
            return this.editorComponent.getGraphComponent().isShowTaskIcon();
        }

        public boolean isShowTasksTimeline() {
            return this.editorComponent.getGraphComponent().isShowTaskTimelineIcon();
        }

        public void setShowCollapse(boolean value) {
            this.editorComponent.runAction((AbstractEditorAction)new ShowHideCollapseAction(value));
        }

        public void setShowComments(boolean value) {
            this.editorComponent.setCommentsVisible(value);
        }

        public void setShowIcons(boolean value) {
            this.editorComponent.runAction((AbstractEditorAction)new ShowHideIconAction(value));
        }

        public void setShowAttachments(boolean value) {
            this.editorComponent.runAction((AbstractEditorAction)new ShowHideAttachmentAction(value));
        }

        public void setShowLinks(boolean value) {
            this.editorComponent.runAction((AbstractEditorAction)new ShowHideLinkAction(value));
        }

        public void setShowNotes(boolean value) {
            this.editorComponent.runAction((AbstractEditorAction)new ShowHideNotesAction(value));
        }

        public void setShowTags(boolean value) {
            this.editorComponent.runAction((AbstractEditorAction)new ShowHideTagsAction(value));
        }

        public void setShowAudioNotes(boolean value) {
            this.editorComponent.runAction((AbstractEditorAction)new ShowHideAudioNotesAction(value));
        }

        public void setShowTasks(boolean value) {
            this.editorComponent.runAction((AbstractEditorAction)new ShowHideTaskAction(value));
        }

        public void setShowTasksTimeline(boolean value) {
            this.editorComponent.runAction((AbstractEditorAction)new ShowHideTaskTimelineAction(value));
        }

        public boolean isShowOrdering() {
            return this.editorComponent.getGraphComponent().isShowOrdering();
        }

        public void setShowOrdering(boolean value) {
            this.editorComponent.runAction((AbstractEditorAction)new ShowHideOrderingAction(value));
        }

        public boolean isShowPinned() {
            return this.editorComponent.getGraphComponent().isShowPinnedIcons();
        }

        public void setShowPinned(boolean value) {
            this.editorComponent.runAction((AbstractEditorAction)new ShowHidePinnedAction(value));
        }

        public boolean isShowGrid() {
            return this.editorComponent.getGraphComponent().isGridVisible();
        }

        public void setShowGrid(boolean value) {
            this.editorComponent.runAction((AbstractEditorAction)new ShowHideGridAction(value));
        }

        public boolean isShowControls() {
            return this.editorComponent.getGraphComponent().isShowControlPoints();
        }

        public void setShowControls(boolean value) {
            this.editorComponent.runAction((AbstractEditorAction)new ShowHideControlsAction(value));
        }

        public boolean isShowBranchPopup() {
            if (OSGiManager.getPreferencesService() != null) {
                try {
                    return OSGiManager.getPreferencesService().getCurrentUserPreferences().getBoolean(ShowShowAndHideSettingsAction.SHOW_BRANCH_EDITOR_PREFERENCE, false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        }

        public void setShowBranchPopup(boolean value) {
            try {
                OSGiManager.getPreferencesService().getCurrentUserPreferences().putBoolean(ShowShowAndHideSettingsAction.SHOW_BRANCH_EDITOR_PREFERENCE, value);
            }
            catch (Exception ex) {
                Logger.getLogger(this.getClass()).warn((Object)"Failed to set branch cell editor preference", (Object)ex.getMessage());
            }
        }
    }
}

