/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.actions;

import com.buzanonline.chaos.action.ActionManager;
import com.buzanonline.chaos.systemstate.ISystemState;
import com.thinkbuzan.gaia.action.AbstractOSGiAction;
import com.thinkbuzan.gaia.action.OSGiManager;
import com.thinkbuzan.gaia.editor.EditorManager;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.ui.MainFrameUtilities;
import com.thinkbuzan.pascal.services.ui.IMainFrame;
import java.awt.Frame;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.swing.JOptionPane;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;

public class ShutdownAction
extends AbstractOSGiAction {
    private static final transient org.apache.log4j.Logger LOGGER = org.apache.log4j.Logger.getLogger(ShutdownAction.class);
    private static final long DISPOSE_FRAMES_TIMEOUT = 4000L;
    private static final long SHUTDOWN_TIMEOUT = 10000L;
    private static final Logger SHUTDOWN_LOG = Logger.getLogger("SHUTDOWN");
    private static final String CLOSE_ACTION = "com.thinkbuzan.gaia.actions.CloseAction";

    public ShutdownAction(BundleContext context) {
        super(context);
    }

    public final String getId() {
        return ShutdownAction.class.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public final void runAction(Object ... parameters) {
        block24: {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Attempting to stop system bundle");
            }
            ((IMainFrame)MainFrameUtilities.getMainFrame()).exitFullScreen();
            try {
                int extended = MainFrameUtilities.getMainFrame().getExtendedState();
                Rectangle bounds = MainFrameUtilities.getMainFrame().getBounds();
                OSGiManager.getPreferencesService().getCurrentUserPreferences().putInt("FRAME_STATE", extended);
                OSGiManager.getPreferencesService().getCurrentUserPreferences().putInt("FRAME_POS_X", bounds.x);
                OSGiManager.getPreferencesService().getCurrentUserPreferences().putInt("FRAME_POS_Y", bounds.y);
                OSGiManager.getPreferencesService().getCurrentUserPreferences().putInt("FRAME_WIDTH", bounds.width);
                OSGiManager.getPreferencesService().getCurrentUserPreferences().putInt("FRAME_HEIGHT", bounds.height);
            }
            catch (Exception ex) {
                LOGGER.warn((Object)"Failed to store previous closing state");
            }
            if (this.closeAllEditorComponents()) {
                Object v0;
                Bundle systemBundle = this.getBundleContext().getBundle(0L);
                systemBundle.stop();
                Object var5_7 = null;
                try {
                    if (JOptionPane.getRootFrame() != null) {
                        JOptionPane.getRootFrame().dispose();
                    }
                    try {
                        String logLocation = System.getProperty("com.thinkbuzan.gaia.log.dir");
                        if (logLocation != null) {
                            FileHandler fileHandler = new FileHandler(logLocation + File.separator + "shutdown.log", false);
                            fileHandler.setFormatter(new SimpleFormatter());
                            SHUTDOWN_LOG.addHandler(fileHandler);
                        }
                    }
                    catch (IOException exception2) {
                        LOGGER.error((Object)exception2);
                    }
                    v0 = null;
                }
                catch (Throwable throwable) {
                    v0 = null;
                }
                Object var9_22 = v0;
                ((IMainFrame)MainFrameUtilities.getMainFrame()).stopJavaFX();
                this.startShutdownThread();
                {
                    break block24;
                    catch (BundleException exception) {
                        Object v1;
                        LOGGER.error((Object)"Exception thrown when stopping system bundle", (Throwable)exception);
                        Object var5_8 = null;
                        try {
                            if (JOptionPane.getRootFrame() != null) {
                                JOptionPane.getRootFrame().dispose();
                            }
                            try {
                                String logLocation = System.getProperty("com.thinkbuzan.gaia.log.dir");
                                if (logLocation != null) {
                                    FileHandler fileHandler = new FileHandler(logLocation + File.separator + "shutdown.log", false);
                                    fileHandler.setFormatter(new SimpleFormatter());
                                    SHUTDOWN_LOG.addHandler(fileHandler);
                                }
                            }
                            catch (IOException exception2) {
                                LOGGER.error((Object)exception2);
                            }
                            v1 = null;
                        }
                        catch (Throwable throwable) {
                            v1 = null;
                        }
                        Object var9_23 = v1;
                        ((IMainFrame)MainFrameUtilities.getMainFrame()).stopJavaFX();
                        this.startShutdownThread();
                    }
                }
                catch (Throwable throwable) {
                    Object v2;
                    Object var5_9 = null;
                    try {
                        if (JOptionPane.getRootFrame() != null) {
                            JOptionPane.getRootFrame().dispose();
                        }
                        try {
                            String logLocation = System.getProperty("com.thinkbuzan.gaia.log.dir");
                            if (logLocation != null) {
                                FileHandler fileHandler = new FileHandler(logLocation + File.separator + "shutdown.log", false);
                                fileHandler.setFormatter(new SimpleFormatter());
                                SHUTDOWN_LOG.addHandler(fileHandler);
                            }
                        }
                        catch (IOException exception2) {
                            LOGGER.error((Object)exception2);
                        }
                        v2 = null;
                    }
                    catch (Throwable throwable2) {
                        v2 = null;
                    }
                    Object var9_24 = v2;
                    ((IMainFrame)MainFrameUtilities.getMainFrame()).stopJavaFX();
                    this.startShutdownThread();
                    throw throwable;
                }
            }
        }
    }

    private void startShutdownThread() {
        Thread disposeFrames = new Thread(){

            public void run() {
                try {
                    Thread.sleep(4000L);
                }
                catch (InterruptedException ex) {
                    LOGGER.info((Object)"Shutdown timeout was interrupted.");
                }
                for (Frame unDisposedFrame : Frame.getFrames()) {
                    if (unDisposedFrame == null || !unDisposedFrame.isDisplayable()) continue;
                    SHUTDOWN_LOG.severe("There was a frame still displayable after shutdown, frame name: " + unDisposedFrame.getName() + " frame title: " + unDisposedFrame.getTitle() + " class:" + unDisposedFrame.getClass());
                    unDisposedFrame.dispose();
                }
            }
        };
        disposeFrames.setDaemon(true);
        disposeFrames.start();
        Thread shutdown = new Thread(){

            public void run() {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ex) {
                    SHUTDOWN_LOG.severe("Shutdown timeout was interrupted.");
                }
                this.dumpThreads();
                SHUTDOWN_LOG.severe("had to perform hard shutdown");
                System.exit(2);
            }

            private void dumpThreads() {
                for (Thread thread : Thread.getAllStackTraces().keySet()) {
                    if (!thread.isDaemon()) {
                        SHUTDOWN_LOG.severe("^^^^^^^^^^^^^^^^^^^^^^^^^^^");
                        SHUTDOWN_LOG.severe(thread.getName());
                        SHUTDOWN_LOG.severe("state" + (Object)((Object)thread.getState()));
                        SHUTDOWN_LOG.severe("priority" + thread.getPriority());
                        SHUTDOWN_LOG.severe(Arrays.toString(thread.getStackTrace()));
                        SHUTDOWN_LOG.severe("alive " + thread.isAlive());
                        SHUTDOWN_LOG.severe("deamon " + thread.isDaemon());
                        SHUTDOWN_LOG.severe("interrupted " + thread.isInterrupted());
                        SHUTDOWN_LOG.severe("-------------------------------");
                        continue;
                    }
                    LOGGER.debug((Object)("demon thread - " + thread.getName()));
                }
            }
        };
        shutdown.setDaemon(true);
        shutdown.start();
    }

    private boolean closeAllEditorComponents() {
        EditorManager editorManager = this.getEditorManager();
        ActionManager actionManager = this.getActionManager();
        ArrayList editorCompList = new ArrayList(editorManager.getAllEditorComponents());
        for (IEditorComponent editorComponent : editorCompList) {
            editorManager.switchFocusToEditorComponent(editorComponent.getId());
            actionManager.runAction(CLOSE_ACTION, new Object[]{editorComponent});
            if (editorComponent.isClosed() || !editorComponent.isModified()) continue;
            return false;
        }
        return true;
    }

    private EditorManager getEditorManager() {
        String editorManagerClassName = EditorManager.class.getName();
        ServiceReference serviceReference = this.getBundleContext().getServiceReference(editorManagerClassName);
        if (serviceReference == null) {
            throw new IllegalStateException("Could not get ServiceReference for " + editorManagerClassName);
        }
        EditorManager editorManager = (EditorManager)this.getBundleContext().getService(serviceReference);
        if (editorManager == null) {
            throw new IllegalStateException("Could not get service " + editorManagerClassName);
        }
        return editorManager;
    }

    private ActionManager getActionManager() {
        String actionManagerClassName = ActionManager.class.getName();
        ServiceReference serviceReference = this.getBundleContext().getServiceReference(actionManagerClassName);
        if (serviceReference == null) {
            throw new IllegalStateException("Could not get ServiceReference for " + actionManagerClassName);
        }
        ActionManager actionManager = (ActionManager)this.getBundleContext().getService(serviceReference);
        if (actionManager == null) {
            throw new IllegalStateException("Could not get service " + actionManagerClassName);
        }
        return actionManager;
    }

    public final void systemStateChanged(ISystemState systemState) {
    }
}

