/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.actions;

import com.buzanonline.chaos.systemstate.ISystemState;
import com.thinkbuzan.chaos.osgiutilities.service.OSGiService;
import com.thinkbuzan.gaia.action.AbstractOSGiAction;
import com.thinkbuzan.gaia.editor.EditorManager;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.editor.listeners.EditorListener;
import org.apache.log4j.Logger;
import org.osgi.framework.BundleContext;

public class SketchToolOpacityAction
extends AbstractOSGiAction {
    private IEditorComponent currentEditor;

    public SketchToolOpacityAction(BundleContext contextIn) {
        super(contextIn);
        OSGiService editorManagerService = new OSGiService(contextIn, EditorManager.class);
        ((EditorManager)editorManagerService.get()).addEditorListener(new EditorListener(){

            public void editorChanged(IEditorComponent editor) {
                SketchToolOpacityAction.this.editorChangedImpl(editor);
            }
        });
        editorManagerService.close();
        this.changeState(false);
    }

    private void editorChangedImpl(IEditorComponent editor) {
        if (editor == null) {
            this.changeState(false);
        } else {
            this.changeState(true);
        }
        this.currentEditor = editor;
    }

    public final String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public final void runAction(Object ... parameters) {
        if (this.currentEditor != null && this.currentEditor.getGraphComponent().getSketchHandler().isEnabled()) {
            Float opacity = this.getOpacity(parameters);
            if (opacity == null) {
                Logger.getLogger(((Object)((Object)this)).getClass()).warn((Object)"Need to pass in a valid opacity value");
            } else {
                this.currentEditor.getGraphComponent().getSketchHandler().setOpacity(opacity.floatValue());
            }
        }
    }

    private Float getOpacity(Object[] parameters) {
        if (parameters != null && parameters.length == 1 && parameters[0] instanceof Float) {
            return (Float)parameters[0];
        }
        return null;
    }

    public void systemStateChanged(ISystemState systemState) {
    }
}

