/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.actions;

import com.buzanonline.chaos.systemstate.ISystemState;
import com.thinkbuzan.chaos.osgiutilities.service.OSGiService;
import com.thinkbuzan.gaia.action.AbstractOSGiAction;
import com.thinkbuzan.gaia.editor.EditorManager;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.editor.listeners.EditorListener;
import java.awt.Color;
import org.apache.log4j.Logger;
import org.osgi.framework.BundleContext;

public class SketchToolStrokeColourAction
extends AbstractOSGiAction {
    private IEditorComponent currentEditor;

    public SketchToolStrokeColourAction(BundleContext contextIn) {
        super(contextIn);
        OSGiService editorManagerService = new OSGiService(contextIn, EditorManager.class);
        ((EditorManager)editorManagerService.get()).addEditorListener(new EditorListener(){

            public void editorChanged(IEditorComponent editor) {
                SketchToolStrokeColourAction.this.editorChangedImpl(editor);
            }
        });
        editorManagerService.close();
        this.changeState(false);
    }

    private void editorChangedImpl(IEditorComponent editor) {
        if (editor == null) {
            this.changeState(false);
        } else {
            this.changeState(true);
        }
        this.currentEditor = editor;
    }

    public final String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public final void runAction(Object ... parameters) {
        if (this.currentEditor != null && this.currentEditor.getGraphComponent().getSketchHandler().isEnabled()) {
            Color colour = this.getStrokeColour(parameters);
            if (colour == null) {
                Logger.getLogger(((Object)((Object)this)).getClass()).warn((Object)"Need to pass in a stroke colour tool");
            } else {
                this.currentEditor.getGraphComponent().getSketchHandler().setStrokeColour(colour);
            }
        }
    }

    private Color getStrokeColour(Object[] parameters) {
        if (parameters != null && parameters.length == 1 && parameters[0] instanceof Color) {
            return (Color)parameters[0];
        }
        return null;
    }

    public void systemStateChanged(ISystemState systemState) {
    }
}

