/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.actions;

import com.buzanonline.chaos.systemstate.ISystemState;
import com.thinkbuzan.chaos.osgiutilities.service.OSGiService;
import com.thinkbuzan.gaia.action.AbstractOSGiAction;
import com.thinkbuzan.gaia.editor.EditorManager;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.editor.listeners.EditorListener;
import com.thinkbuzan.pascal.sketch.model.SketchChild;
import com.thinkbuzan.pascal.sketch.util.IEdit;
import com.thinkbuzan.pascal.sketch.util.IEditListener;
import com.thinkbuzan.pascal.sketch.util.IUndoListener;
import java.awt.geom.Rectangle2D;
import org.osgi.framework.BundleContext;

public class SketchUndoAction
extends AbstractOSGiAction
implements IUndoListener,
IEditListener {
    private IEditorComponent currentEditor;

    public SketchUndoAction(BundleContext contextIn) {
        super(contextIn);
        OSGiService editorManagerService = new OSGiService(contextIn, EditorManager.class);
        ((EditorManager)editorManagerService.get()).addEditorListener(new EditorListener(){

            public void editorChanged(IEditorComponent editor) {
                SketchUndoAction.this.editorChangedImpl(editor);
            }
        });
        editorManagerService.close();
        this.changeState(false);
    }

    private void editorChangedImpl(IEditorComponent editor) {
        if (editor == null) {
            this.changeState(false);
        } else {
            this.changeState(editor.getGraphComponent().getSketchHandler() != null && editor.getGraphComponent().getSketchHandler().canUndo());
        }
        if (this.currentEditor != null) {
            this.currentEditor.getGraphComponent().getSketchHandler().removeUndoListener((IUndoListener)this);
            this.currentEditor.getGraphComponent().getSketchHandler().removeEditListener((IEditListener)this);
        }
        this.currentEditor = editor;
        if (this.currentEditor != null) {
            this.currentEditor.getGraphComponent().getSketchHandler().addUndoListener((IUndoListener)this);
            this.currentEditor.getGraphComponent().getSketchHandler().addEditListener((IEditListener)this);
        }
    }

    public final String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public final void runAction(Object ... parameters) {
        if (this.currentEditor != null) {
            if (!this.currentEditor.getGraphComponent().getSketchHandler().isEnabled()) {
                throw new IllegalStateException("The action can only be run when it is enabled");
            }
            this.currentEditor.getGraphComponent().getSketchHandler().undo();
        }
    }

    public void systemStateChanged(ISystemState systemState) {
    }

    public final void removed(SketchChild arg0) {
        this.updateState();
    }

    public final void updated(SketchChild arg0) {
        this.updateState();
    }

    public final void beginEdit() {
        this.updateState();
    }

    public final void endEdit() {
        this.updateState();
    }

    public final void addEdit(IEdit edit) {
        this.updateState();
    }

    public final void updateModelBounds(Rectangle2D bounds) {
        this.updateState();
    }

    private void updateState() {
        if (this.currentEditor != null) {
            this.changeState(this.currentEditor.getGraphComponent().getSketchHandler() != null && this.currentEditor.getGraphComponent().getSketchHandler().canUndo());
        }
    }
}

