/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.actions;

import com.buzanonline.chaos.systemstate.ISystemState;
import com.mxgraph.mindmap.model.mmCell;
import com.mxgraph.mindmap.model.mmIStructureCell;
import com.thinkbuzan.gaia.action.AbstractOSGiAction;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.editor.actions.AbstractEditorAction;
import com.thinkbuzan.gaia.editor.actions.SwapBranchLocationsAction;
import com.thinkbuzan.gaia.editor.actionsupport.SelectionSupport;
import com.thinkbuzan.gaia.editor.actionsupport.ViewTypeSupport;
import java.util.List;
import org.apache.log4j.Logger;
import org.osgi.framework.BundleContext;

public class SwapLocationsAction
extends AbstractOSGiAction {
    private final SelectionSupport selectionSupport;

    public SwapLocationsAction(BundleContext context) {
        super(context);
        this.selectionSupport = new SelectionSupport(context){

            public void updateState(IEditorComponent editorComponent, List<mmCell> selectionCells) {
                SwapLocationsAction.this.changeState(true);
            }
        };
    }

    public final String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public final void runAction(Object ... parameters) {
        if (parameters != null && parameters.length == 2) {
            Object cell1 = parameters[0];
            Object cell2 = parameters[1];
            String viewId = this.selectionSupport.getCurrentEditor().getView().getId();
            if (ViewTypeSupport.MIND_MAP_VIEW_ID.equalsIgnoreCase(viewId) || ViewTypeSupport.TD_VIEW_ID.equalsIgnoreCase(viewId)) {
                if (cell1 instanceof mmIStructureCell && cell2 instanceof mmIStructureCell) {
                    double rootX = ((mmIStructureCell)cell1).getParentStructure().getGeometry().getCenterX();
                    boolean left1 = ((mmIStructureCell)cell1).getTerminal(false).getGeometry().getCenterX() > rootX;
                    boolean left2 = ((mmIStructureCell)cell2).getTerminal(false).getGeometry().getCenterX() > rootX;
                    this.selectionSupport.getCurrentEditor().runSingleAction((AbstractEditorAction)new SwapBranchLocationsAction((mmIStructureCell)cell1, (mmIStructureCell)cell2, left1 != left2));
                }
            } else if (ViewTypeSupport.BRAINSTORM_VIEW.equalsIgnoreCase(viewId)) {
                Logger.getLogger(((Object)((Object)this)).getClass()).warn((Object)("Need a new action for brains " + viewId));
            } else if (ViewTypeSupport.FAST_CAPTURE_VIEW.equalsIgnoreCase(viewId)) {
                Logger.getLogger(((Object)((Object)this)).getClass()).warn((Object)("Need a new action for fast " + viewId));
            }
        }
    }

    public final void systemStateChanged(ISystemState systemState) {
    }
}

