/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.actions;

import com.buzanonline.chaos.systemstate.ISystemState;
import com.mxgraph.mindmap.model.mmBranchCell;
import com.mxgraph.mindmap.model.mmCell;
import com.mxgraph.mindmap.model.mmFloatingIdeaCell;
import com.mxgraph.mindmap.model.mmFloatingTextCell;
import com.mxgraph.mindmap.model.mmRelationshipCell;
import com.thinkbuzan.gaia.action.AbstractOSGiAction;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.editor.actions.AbstractEditorAction;
import com.thinkbuzan.gaia.editor.actions.SetEdgeLabelAlignStyleAction;
import com.thinkbuzan.gaia.editor.actionsupport.SelectionSupport;
import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextAlignAction
extends AbstractOSGiAction {
    private final transient SelectionSupport selectionSupport;
    private final transient String alignment;

    public TextAlignAction(BundleContext context, String alignmentIn) {
        super(context);
        this.alignment = alignmentIn;
        this.changeState(false);
        this.selectionSupport = new SelectionSupport(this.getBundleContext()){

            public void updateState(IEditorComponent editorComponent, List<mmCell> selectionCells) {
                boolean enabled = TextAlignAction.this.isEnabled(selectionCells, editorComponent);
                TextAlignAction.this.changeState(enabled);
            }
        };
    }

    private boolean isEnabled(List<mmCell> selectionCells, IEditorComponent editorComponent) {
        if (editorComponent == null || editorComponent.getView() == null) {
            return false;
        }
        boolean enabled = false;
        for (mmCell cell : selectionCells) {
            if (!this.isValidCell(cell)) continue;
            enabled = true;
            break;
        }
        return enabled;
    }

    protected boolean isValidCell(Object cell) {
        boolean valid = cell instanceof mmBranchCell ? true : (cell instanceof mmRelationshipCell ? true : (cell instanceof mmFloatingTextCell ? true : cell instanceof mmFloatingIdeaCell));
        return valid;
    }

    public final String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public final void runAction(Object ... parameters) {
        Object[] validCells = this.getValidCells();
        if (validCells != null && validCells.length > 0) {
            this.selectionSupport.getCurrentEditor().runSingleAction((AbstractEditorAction)new SetEdgeLabelAlignStyleAction(this.alignment, validCells));
        }
    }

    private Object[] getValidCells() {
        ArrayList<mmCell> validCells = new ArrayList<mmCell>();
        for (mmCell cell : this.selectionSupport.getCurrentEditor().getAllSelectionCells()) {
            if (!this.isValidCell(cell)) continue;
            validCells.add(cell);
        }
        return validCells.toArray();
    }

    public final void systemStateChanged(ISystemState systemState) {
    }
}

