/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.actions;

import com.buzanonline.chaos.action.ActionManager;
import com.buzanonline.chaos.systemstate.ISystemState;
import com.mxgraph.mindmap.model.mmBranchBoxCell;
import com.mxgraph.mindmap.model.mmBranchCell;
import com.mxgraph.mindmap.model.mmCell;
import com.mxgraph.mindmap.util.mmUtils;
import com.mxgraph.model.mxICell;
import com.mxgraph.util.mxConstants;
import com.mxgraph.view.mxGraph;
import com.thinkbuzan.gaia.action.AbstractFontChangeAction;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.editor.StyleUtils;
import java.util.List;
import org.apache.log4j.Logger;
import org.osgi.framework.BundleContext;

public class ToggleFontBoldAction
extends AbstractFontChangeAction {
    private final transient ActionManager actionManager;
    private static final Logger LOGGER = Logger.getLogger(ToggleFontBoldAction.class);

    public ToggleFontBoldAction(ActionManager actionManagerIn, BundleContext contextIn) {
        super(contextIn);
        if (actionManagerIn == null) {
            throw new IllegalArgumentException("ActionManager cannot be null!");
        }
        this.actionManager = actionManagerIn;
    }

    public final String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public final void runAction(Object ... parameters) {
        IEditorComponent editor = this.getSelectionSupport().getCurrentEditor();
        List selectionCells = mmUtils.filterFontChangeCells((List)editor.getAllSelectionCells());
        if (selectionCells != null && !selectionCells.isEmpty()) {
            int styleInt;
            String styleString;
            mmCell cell = (mmCell)selectionCells.get(0);
            if (cell instanceof mmBranchCell && ((mmBranchCell)cell).getBoxBranch() != null) {
                mmBranchBoxCell boxBranch = ((mmBranchCell)cell).getBoxBranch();
                styleString = (String)StyleUtils.getStyle((mxGraph)this.getSelectionSupport().getCurrentEditor().getGraphComponent().getGraph(), (mxICell)boxBranch, (String)mxConstants.STYLE_FONTSTYLE);
            } else {
                styleString = (String)StyleUtils.getStyle((mxGraph)this.getSelectionSupport().getCurrentEditor().getGraphComponent().getGraph(), (mxICell)cell, (String)mxConstants.STYLE_FONTSTYLE);
            }
            if (styleString == null) {
                styleInt = 0;
            } else {
                try {
                    styleInt = Integer.parseInt(styleString);
                }
                catch (NumberFormatException nfe) {
                    LOGGER.error((Object)("NumberFormatException: style string should be an integer: " + styleString));
                    throw new IllegalArgumentException("NumberFormatException trying to parse int from style string: " + styleString);
                }
            }
            boolean setBold = (styleInt & 1) != 1;
            this.actionManager.runAction("com.thinkbuzan.gaia.actions.SetFontBoldAction", new Object[]{setBold});
        }
    }

    public final void systemStateChanged(ISystemState systemState) {
    }
}

