/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.actions;

import com.buzanonline.chaos.systemstate.ISystemState;
import com.mxgraph.mindmap.model.mmBranchCell;
import com.mxgraph.mindmap.model.mmCell;
import com.mxgraph.mindmap.model.mmIStructureCell;
import com.thinkbuzan.gaia.action.AbstractOSGiAction;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.editor.actions.AbstractEditorAction;
import com.thinkbuzan.gaia.editor.actions.SetBranchPinnedStateAction;
import com.thinkbuzan.gaia.editor.actionsupport.SelectionSupport;
import com.thinkbuzan.gaia.editor.actionsupport.UndoRedoSupport;
import com.thinkbuzan.gaia.editor.actionsupport.ViewTypeSupport;
import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnPinBranchAction
extends AbstractOSGiAction {
    private final transient SelectionSupport selectionSupport;

    public UnPinBranchAction(BundleContext context) {
        super(context);
        this.changeState(false);
        this.selectionSupport = this.addSelectionSupport(context);
        this.addUndoRedoSupport(context);
    }

    private SelectionSupport addSelectionSupport(BundleContext context) {
        SelectionSupport selectionSupportIn = new SelectionSupport(context){

            public void updateState(IEditorComponent editorComponent, List<mmCell> selectionCells) {
                UnPinBranchAction.this.checkSelectionEnabled(selectionCells);
            }
        };
        return selectionSupportIn;
    }

    private UndoRedoSupport addUndoRedoSupport(BundleContext context) {
        UndoRedoSupport undoRedoSupport = new UndoRedoSupport(context){

            public void updateState(IEditorComponent editorComponent, List<mmCell> selectionCells) {
                UnPinBranchAction.this.checkSelectionEnabled(selectionCells);
            }
        };
        return undoRedoSupport;
    }

    private void checkSelectionEnabled(List<mmCell> selectionCells) {
        ArrayList<mmCell> selectedCells = new ArrayList<mmCell>();
        for (mmCell selectionCell : selectionCells) {
            if (!(selectionCell instanceof mmCell)) continue;
            selectedCells.add(selectionCell);
        }
        boolean enabled = this.isEnabled(selectedCells);
        this.changeState(enabled);
    }

    private boolean isEnabled(List<mmCell> selectionCells) {
        boolean enabled = false;
        if (selectionCells != null) {
            for (mmCell cell : selectionCells) {
                if (!(cell instanceof mmBranchCell) || !((mmBranchCell)cell).isPinnedBranch()) continue;
                enabled = true;
                break;
            }
        }
        return enabled && !this.selectionSupport.getCurrentEditor().getView().getId().equals(ViewTypeSupport.FAST_CAPTURE_VIEW);
    }

    public final String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public final void runAction(Object ... parameters) {
        this.validateRunAction(parameters);
        List selectionCells = this.selectionSupport.getCurrentEditor().getAllSelectionCells();
        if (!this.isEnabled(selectionCells)) {
            throw new IllegalStateException("The action can only be run when it is enabled");
        }
        this.selectionSupport.getCurrentEditor().runAction((AbstractEditorAction)new SetBranchPinnedStateAction(selectionCells, false));
        ArrayList<mmIStructureCell> newSelection = new ArrayList<mmIStructureCell>();
        this.selectionSupport.getCurrentEditor().setSelectionCells(newSelection);
        for (mmCell cell : selectionCells) {
            if (!(cell instanceof mmIStructureCell)) continue;
            newSelection.add((mmIStructureCell)cell);
        }
        this.selectionSupport.getCurrentEditor().setSelectionCells(newSelection);
    }

    private void validateRunAction(Object ... parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException("parameters must not be null");
        }
        if (parameters.length != 0) {
            throw new IllegalArgumentException("parameters.length must be 0 ");
        }
    }

    public final void systemStateChanged(ISystemState systemState) {
    }
}

