/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.actions;

import com.buzanonline.chaos.systemstate.ISystemState;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.thinkbuzan.chaos.osgiutilities.service.OSGiService;
import com.thinkbuzan.chaos.utilities.edtutilities.EDTUtilities;
import com.thinkbuzan.gaia.action.AbstractOSGiAction;
import com.thinkbuzan.gaia.editor.EditorManager;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.editor.listeners.EditorListener;
import org.osgi.framework.BundleContext;

public class UndoAction
extends AbstractOSGiAction
implements mxEventSource.mxIEventListener {
    private IEditorComponent currentEditor;

    public UndoAction(BundleContext context) {
        super(context);
        OSGiService editorManagerService = new OSGiService(context, EditorManager.class);
        ((EditorManager)editorManagerService.get()).addEditorListener(new EditorListener(){

            public void editorChanged(IEditorComponent editor) {
                UndoAction.this.editorChangedImpl(editor);
            }
        });
        editorManagerService.close();
        this.changeState(false);
    }

    private void editorChangedImpl(IEditorComponent editor) {
        if (editor == null) {
            this.changeState(false);
        } else {
            this.changeState(editor.getGraphComponent().getUndoManager().canUndo());
        }
        if (this.currentEditor != null) {
            this.currentEditor.getGraphComponent().getUndoManager().removeListener((mxEventSource.mxIEventListener)this);
        }
        this.currentEditor = editor;
        if (this.currentEditor != null) {
            this.currentEditor.getGraphComponent().getUndoManager().addListener(null, (mxEventSource.mxIEventListener)this);
        }
    }

    public final String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public final void runAction(Object ... parameters) {
        EDTUtilities.runOnEDT((Runnable)new Runnable(){

            public void run() {
                if (UndoAction.this.currentEditor != null) {
                    if (UndoAction.this.currentEditor.isInSketchMode()) {
                        if (UndoAction.this.currentEditor.getGraphComponent().getSketchHandler().canUndo()) {
                            UndoAction.this.currentEditor.getGraphComponent().getSketchHandler().undo();
                        }
                    } else if (UndoAction.this.currentEditor.getGraphComponent().getUndoManager().canUndo()) {
                        UndoAction.this.currentEditor.getGraphComponent().stopEditing(false);
                        UndoAction.this.currentEditor.getGraphComponent().getUndoManager().undo();
                    }
                }
            }
        });
    }

    public final void systemStateChanged(ISystemState systemState) {
    }

    public final void invoke(Object sender, mxEventObject evt) {
        if (this.currentEditor != null) {
            this.changeState(this.currentEditor.getGraphComponent().getUndoManager().canUndo());
        } else {
            this.changeState(false);
        }
    }
}

