/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.actions.open;

import com.buzanonline.chaos.systemstate.ISystemState;
import com.thinkbuzan.chaos.launcherservice.LauncherService;
import com.thinkbuzan.chaos.osgiutilities.service.OSGiService;
import com.thinkbuzan.gaia.actions.OpenActionConstants;
import com.thinkbuzan.gaia.actions.open.AbstractOpenAction;
import java.net.URI;
import org.apache.log4j.Logger;
import org.osgi.framework.BundleContext;

public final class OpenEmailExternalAction
extends AbstractOpenAction {
    private static final Logger LOG = Logger.getLogger(OpenEmailExternalAction.class);
    private final transient OSGiService<LauncherService> launcherService;

    public OpenEmailExternalAction(BundleContext contextIn) {
        super(contextIn);
        this.launcherService = new OSGiService(contextIn, LauncherService.class);
    }

    public String getId() {
        return OpenActionConstants.OPEN_EMAIL_EXTERNAL_ACTION_ID;
    }

    public void runAction(Object ... parameters) {
        this.validateRunActionEmailURIs(parameters);
        URI[] uris = new URI[parameters.length];
        System.arraycopy(parameters, 0, uris, 0, parameters.length);
        this.openEmailsUsingLauncherService(uris);
    }

    private void openEmailsUsingLauncherService(URI[] uris) {
        for (URI uri : uris) {
            LOG.debug((Object)("Opening email: " + uri.toString()));
            ((LauncherService)this.launcherService.get()).launchEmail(uri);
        }
    }

    public void systemStateChanged(ISystemState systemState) {
    }
}

