/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.actions.open;

import com.buzanonline.chaos.systemstate.ISystemState;
import com.thinkbuzan.chaos.launcherservice.LauncherService;
import com.thinkbuzan.chaos.osgiutilities.service.OSGiService;
import com.thinkbuzan.gaia.actions.OpenActionConstants;
import com.thinkbuzan.gaia.actions.open.AbstractOpenAction;
import java.io.File;
import org.apache.log4j.Logger;
import org.osgi.framework.BundleContext;

public final class OpenFileExternalAction
extends AbstractOpenAction {
    private static final Logger LOG = Logger.getLogger(OpenFileExternalAction.class);
    private final transient OSGiService<LauncherService> launcherService;

    public OpenFileExternalAction(BundleContext contextIn) {
        super(contextIn);
        this.launcherService = new OSGiService(contextIn, LauncherService.class);
    }

    public String getId() {
        return OpenActionConstants.OPEN_FILE_EXTERNAL_ACTION_ID;
    }

    public void runAction(Object ... parameters) {
        this.validateRunActionFiles(parameters);
        for (Object obj : parameters) {
            if (!(obj instanceof File)) continue;
            this.openFileUsingLauncherService((File)obj);
        }
    }

    private void openFileUsingLauncherService(File file) {
        LOG.debug((Object)("Open File: " + file.getAbsolutePath()));
        ((LauncherService)this.launcherService.get()).launchFile(file);
    }

    public void systemStateChanged(ISystemState systemState) {
    }
}

