/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.actions.open;

import com.buzanonline.chaos.systemstate.ISystemState;
import com.thinkbuzan.chaos.launcherservice.LauncherService;
import com.thinkbuzan.chaos.osgiutilities.service.OSGiService;
import com.thinkbuzan.gaia.actions.OpenActionConstants;
import com.thinkbuzan.gaia.actions.open.AbstractOpenAction;
import com.thinkbuzan.gaia.actions.open.OpenURIExternalAction;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.log4j.Logger;
import org.osgi.framework.BundleContext;

public final class OpenStringURIExternalAction
extends AbstractOpenAction {
    private static final Logger LOG = Logger.getLogger(OpenURIExternalAction.class);
    private final transient OSGiService<LauncherService> launcherService;

    public OpenStringURIExternalAction(BundleContext contextIn) {
        super(contextIn);
        this.launcherService = new OSGiService(contextIn, LauncherService.class);
    }

    public String getId() {
        return OpenActionConstants.OPEN_STRING_URL_EXTERNAL_ACTION_ID;
    }

    public void runAction(Object ... parameters) {
        this.validateRunActionWebStringURIs(parameters);
        String[] uris = new String[parameters.length];
        System.arraycopy(parameters, 0, uris, 0, parameters.length);
        this.openURLUsingLauncherService(uris);
    }

    protected void validateRunActionWebStringURIs(Object ... parameters) {
        if (null == parameters) {
            throw new IllegalArgumentException("Parameters are null.");
        }
        for (Object obj : parameters) {
            if (obj instanceof String) continue;
            throw new IllegalArgumentException("Only String can be opened in Open String URI Action");
        }
    }

    private void openURLUsingLauncherService(String[] uris) {
        for (String uri : uris) {
            LOG.debug((Object)("Opening URI: " + uri));
            try {
                ((LauncherService)this.launcherService.get()).launchWeb(new URI(uri));
            }
            catch (URISyntaxException exc) {
                LOG.error((Object)("Could not open URI for param=" + uri), (Throwable)exc);
            }
        }
    }

    public void systemStateChanged(ISystemState systemState) {
    }
}

