/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.actions.open;

import com.buzanonline.chaos.action.ActionManager;
import com.buzanonline.chaos.systemstate.ISystemState;
import com.jidesoft.utils.SystemInfo;
import com.thinkbuzan.gaia.actions.OpenActionConstants;
import com.thinkbuzan.gaia.actions.open.AbstractOpenAction;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.apache.commons.validator.GenericValidator;
import org.apache.log4j.Logger;
import org.osgi.framework.BundleContext;

public final class OpenURIAction
extends AbstractOpenAction {
    private static final Logger LOG = Logger.getLogger(OpenURIAction.class);
    private final transient ActionManager actionManager;

    public OpenURIAction(ActionManager actionManagerIn, BundleContext contextIn) {
        super(contextIn);
        this.validateActionManager(actionManagerIn);
        this.actionManager = actionManagerIn;
    }

    public String getId() {
        return OpenActionConstants.OPEN_URL_ACTION_ID;
    }

    public void runAction(Object ... parameters) {
        LOG.debug((Object)"Call OpenUrlExternalAction directly.");
        if (parameters != null && parameters.length > 0 && parameters[0] instanceof URI) {
            URI uri = (URI)parameters[0];
            String uriString = uri.toString();
            if (SystemInfo.isAnyMac() || this.isTextValidURL(uriString)) {
                this.actionManager.runAction(OpenActionConstants.OPEN_URL_EXTERNAL_ACTION_ID, parameters);
            } else {
                this.actionManager.runAction(OpenActionConstants.OPEN_FILE_EXTERNAL_ACTION_ID, new Object[]{new LinkFile(uriString)});
            }
        }
    }

    private final boolean isTextValidURL(String linkString) {
        if (null == linkString) {
            return false;
        }
        if (GenericValidator.isUrl((String)linkString)) {
            return true;
        }
        if (GenericValidator.isUrl((String)("http://" + linkString))) {
            return true;
        }
        return linkString.startsWith("http://") && GenericValidator.isUrl((String)linkString.substring("http://".length()));
    }

    public void systemStateChanged(ISystemState systemState) {
    }

    private class LinkFile
    extends File {
        private String path;

        public LinkFile(String pathname) {
            super(pathname);
            this.path = pathname;
        }

        public boolean exists() {
            return true;
        }

        public String getAbsolutePath() {
            return this.path;
        }

        public File getAbsoluteFile() {
            return this;
        }

        public String getCanonicalPath() throws IOException {
            return this.path;
        }

        public File getCanonicalFile() throws IOException {
            return this;
        }
    }
}

