/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.actions.open;

import com.buzanonline.chaos.systemstate.ISystemState;
import com.thinkbuzan.chaos.launcherservice.LauncherService;
import com.thinkbuzan.chaos.osgiutilities.service.OSGiService;
import com.thinkbuzan.gaia.actions.OpenActionConstants;
import com.thinkbuzan.gaia.actions.open.AbstractOpenAction;
import java.net.URI;
import org.apache.log4j.Logger;
import org.osgi.framework.BundleContext;

public final class OpenURIExternalAction
extends AbstractOpenAction {
    private static final Logger LOG = Logger.getLogger(OpenURIExternalAction.class);
    private final transient OSGiService<LauncherService> launcherService;

    public OpenURIExternalAction(BundleContext contextIn) {
        super(contextIn);
        this.launcherService = new OSGiService(contextIn, LauncherService.class);
    }

    public String getId() {
        return OpenActionConstants.OPEN_URL_EXTERNAL_ACTION_ID;
    }

    public void runAction(Object ... parameters) {
        this.validateRunActionWebURIs(parameters);
        URI[] uris = new URI[parameters.length];
        System.arraycopy(parameters, 0, uris, 0, parameters.length);
        this.openURLUsingLauncherService(uris);
    }

    private void openURLUsingLauncherService(URI[] uris) {
        for (URI uri : uris) {
            LOG.debug((Object)("Opening URI: " + uri.toString()));
            ((LauncherService)this.launcherService.get()).launchWeb(uri);
        }
    }

    public void systemStateChanged(ISystemState systemState) {
    }
}

