/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.actions.resources;

import com.thinkbuzan.apollo.ui.core.RetinaIcon;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public final class ResourceManager {
    private static final String DOT = ".";
    private static final String RETINA = "@2x.";

    private ResourceManager() {
    }

    public static InputStream getInputStream(String filename) {
        InputStream inputStream = ResourceManager.class.getResourceAsStream(filename);
        if (inputStream == null) {
            throw new IllegalStateException(String.format("Could not get InputStream for image %s", filename));
        }
        return inputStream;
    }

    public static ImageIcon getIcon(String filename) {
        return new ImageIcon(ResourceManager.class.getResource(filename));
    }

    public static BufferedImage getBufferedImage(String filename) {
        BufferedImage img = null;
        try {
            InputStream input = ResourceManager.class.getResourceAsStream(filename);
            img = ImageIO.read(input);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return img;
    }

    public static RetinaIcon getRetinaIcon(String filename) {
        BufferedImage img = ResourceManager.getBufferedImage(filename);
        String filename2x = filename.replace(DOT, RETINA);
        BufferedImage img2x = ResourceManager.getBufferedImage(filename2x);
        return new RetinaIcon((Image)img, (Image)img2x);
    }
}

