/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.actions.showhide;

import com.mxgraph.mindmap.model.mmCell;
import com.thinkbuzan.gaia.action.AbstractOSGiAction;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.editor.actions.AbstractEditorAction;
import com.thinkbuzan.gaia.editor.actions.ShowHideAudioNotesAction;
import com.thinkbuzan.gaia.editor.actions.ShowHideGridAction;
import com.thinkbuzan.gaia.editor.actions.ShowHideIconAction;
import com.thinkbuzan.gaia.editor.actions.ShowHideLinkAction;
import com.thinkbuzan.gaia.editor.actions.ShowHideNotesAction;
import com.thinkbuzan.gaia.editor.actions.ShowHidePinnedAction;
import com.thinkbuzan.gaia.editor.actions.ShowHideTaskAction;
import com.thinkbuzan.gaia.editor.actionsupport.SelectionSupport;
import java.util.Arrays;
import java.util.List;
import org.osgi.framework.BundleContext;

public abstract class AbstractShowHideAction
extends AbstractOSGiAction {
    private final transient SelectionSupport selectionSupport;
    private final transient ShowHideProperty property;

    public AbstractShowHideAction(BundleContext contextIn, ShowHideProperty propIn) {
        super(contextIn);
        if (propIn == null) {
            throw new IllegalArgumentException("ShowHideProperty cannot be null!");
        }
        this.property = propIn;
        this.changeState(false);
        this.selectionSupport = new SelectionSupport(this.getBundleContext()){

            public void updateState(IEditorComponent editorComponent, List<mmCell> selectionCells) {
                AbstractShowHideAction.this.changeState(editorComponent != null);
            }
        };
    }

    public final void runAction(Object ... parameters) {
        boolean value;
        IEditorComponent editor = this.selectionSupport.getCurrentEditor();
        if (editor == null) {
            throw new IllegalStateException("action should be disabled when there is a null editor component");
        }
        if (parameters == null || parameters.length == 0) {
            throw new IllegalArgumentException("expected 1 boolean or string argument, got none");
        }
        if (parameters[0] instanceof Boolean) {
            value = (Boolean)parameters[0];
        } else if (parameters[0] instanceof String) {
            value = Boolean.parseBoolean((String)parameters[0]);
        } else {
            throw new IllegalArgumentException("expected 1 boolean or string argument, got " + Arrays.toString(parameters));
        }
        switch (this.property) {
            case TASKS: {
                editor.runAction((AbstractEditorAction)new ShowHideTaskAction(value));
                break;
            }
            case LINKS: {
                editor.runAction((AbstractEditorAction)new ShowHideLinkAction(value));
                break;
            }
            case NOTES: {
                editor.runAction((AbstractEditorAction)new ShowHideNotesAction(value));
                break;
            }
            case AUDIO_NOTES: {
                editor.runAction((AbstractEditorAction)new ShowHideAudioNotesAction(value));
                break;
            }
            case ICONS: {
                editor.runAction((AbstractEditorAction)new ShowHideIconAction(value));
                break;
            }
            case COMMENTS: {
                editor.setCommentsVisible(value);
                break;
            }
            case PINS: {
                editor.runAction((AbstractEditorAction)new ShowHidePinnedAction(value));
                break;
            }
            case GRID_LINES: {
                editor.runAction((AbstractEditorAction)new ShowHideGridAction(value));
                break;
            }
            default: {
                throw new IllegalArgumentException("ShowHideProperty is not valid! prop=" + (Object)((Object)this.property));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ShowHideProperty {
        TASKS,
        LINKS,
        NOTES,
        AUDIO_NOTES,
        ICONS,
        COMMENTS,
        PINS,
        GRID_LINES;

    }
}

