/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.ui.v2.factory;

import com.thinkbuzan.gaia.ui.v2.factory.AbstractBranchArtDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;

public class BranchArtListItemRenderer
extends DefaultListCellRenderer {
    private static final long serialVersionUID = 8441920165005335868L;
    private final transient Border hoverPainter;
    private final transient Border selectionPainter;
    private transient int hoverIndex = -1;
    private transient int lastHoverIndex = -1;
    private transient boolean paintHover;
    private transient boolean paintSelected;
    private static final Color HIGHLIGHT = Color.decode("#dddddd");
    private final transient int width;
    private final transient int height;

    public BranchArtListItemRenderer(JList listIn, int widthIn, int heightIn) {
        this.setVerticalAlignment(0);
        this.setHorizontalAlignment(0);
        this.setHorizontalTextPosition(0);
        this.setVerticalTextPosition(3);
        LineBorder border = new LineBorder(Color.blue, 1, true);
        this.hoverPainter = border;
        this.selectionPainter = border;
        this.width = widthIn;
        this.height = heightIn;
        this.addListListeners(listIn);
    }

    public final Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent((JList<?>)list, value, index, false, cellHasFocus);
        this.paintHover = index == this.hoverIndex;
        this.paintSelected = list.isSelectedIndex(index);
        if (value instanceof AbstractBranchArtDialog.BranchArtItem) {
            this.setIcon(((AbstractBranchArtDialog.BranchArtItem)value).getImage());
            this.setText("");
        }
        this.setBackground(list.getBackground());
        this.setForeground(list.getForeground());
        this.setPreferredSize(new Dimension(this.width, this.height));
        return this;
    }

    protected final void paintComponent(Graphics graphics) {
        if (this.paintHover && this.hoverPainter != null) {
            this.setOpaque(true);
            this.setBackground(HIGHLIGHT);
        } else if (this.paintSelected && this.selectionPainter != null) {
            this.setOpaque(true);
            this.setBackground(HIGHLIGHT);
        } else {
            this.setOpaque(false);
            this.setBackground(Color.WHITE);
        }
        super.paintComponent(graphics);
    }

    private void addListListeners(final JList listIn) {
        listIn.addMouseListener(new MouseAdapter(){

            public void mouseExited(MouseEvent event) {
                BranchArtListItemRenderer.this.listMouseExited(listIn);
            }
        });
        listIn.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent event) {
                BranchArtListItemRenderer.this.listMousePressed(listIn, event);
            }
        });
        listIn.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent event) {
                BranchArtListItemRenderer.this.listMouseMoved(listIn, event);
            }
        });
    }

    protected final void listMousePressed(JList listIn, MouseEvent event) {
        listIn.setSelectedIndex(listIn.locationToIndex(event.getPoint()));
    }

    protected final void listMouseMoved(JList listIn, MouseEvent event) {
        this.hoverIndex = listIn.locationToIndex(event.getPoint());
        Rectangle cellBounds = listIn.getCellBounds(this.hoverIndex, this.hoverIndex);
        if (cellBounds != null && !cellBounds.contains(event.getPoint())) {
            this.hoverIndex = -1;
        }
        if (this.lastHoverIndex == this.hoverIndex) {
            return;
        }
        Rectangle lastCellBounds = listIn.getCellBounds(this.lastHoverIndex, this.lastHoverIndex);
        if (lastCellBounds != null) {
            listIn.repaint(lastCellBounds);
        }
        if (cellBounds != null) {
            listIn.repaint(cellBounds);
        }
        this.lastHoverIndex = this.hoverIndex;
    }

    protected final void listMouseExited(JList listIn) {
        this.lastHoverIndex = -1;
        this.hoverIndex = -1;
        listIn.repaint();
    }

    public final void resetSelection() {
        this.lastHoverIndex = -1;
        this.hoverIndex = -1;
    }
}

