/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.ui.v2.windows;

import com.mxgraph.mindmap.swing.popup.BranchArt;
import com.thinkbuzan.apollo.ui.core.RetinaIcon;
import com.thinkbuzan.apollo.ui.core.win.component.ModalDialog;
import com.thinkbuzan.chaos.internationalization.I18n;
import com.thinkbuzan.gaia.actions.resources.ResourceManager;
import com.thinkbuzan.gaia.ui.v2.factory.AbstractBranchArtDialog;
import com.thinkbuzan.gaia.ui.v2.factory.BranchArtListItemRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class BranchArtDialog
extends AbstractBranchArtDialog {
    private static final int CELL_DIM = 75;
    private static final int SPLIT_PANEL_INSET = 5;
    private static final int IMAGE_PANEL_INSET = 10;
    private static final int SPACING = 20;
    private static final int PANEL_DIM = 400;
    private static final int PANEL_HEIGHT = 460;
    private static final int LIST_DIM = 300;
    private static final String RESOURCE_PREFIX = "branchart/v2/";
    private static final Dimension modalDialogDimension = new Dimension(750, 560);
    private transient JLabel previewImage;
    private transient JList list;
    private ModalDialog modalDialog;

    public BranchArtDialog(Frame owner, AbstractBranchArtDialog.BranchArtController controllerIn, I18n i18n) {
        this.modalDialog = new ModalDialog(owner, i18n.getLocalizedText("com.thinkbuzan.i18n.common.branchArt"), false, true, Dialog.ModalityType.DOCUMENT_MODAL);
        DefaultListModel dataModel = this.createModel();
        ListSelectionListener listener = this.createSelectionListener(controllerIn);
        final ActionListener okListener = this.createOkActionListener(controllerIn);
        final ActionListener cancelListener = this.createCancelActionListener();
        this.createPopup(dataModel, listener, controllerIn);
        controllerIn.selectionChange(controllerIn.getCurrentBranchArtType());
        this.updatePreviewImage(controllerIn);
        this.modalDialog.addConfirmActionListener(i18n.getLocalizedText("com.thinkbuzan.i18n.common.ok"), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                okListener.actionPerformed(e);
                BranchArtDialog.this.modalDialog.setVisible(false);
            }
        });
        this.modalDialog.addCancelActionListener(i18n.getLocalizedText("com.thinkbuzan.i18n.common.cancel"), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                cancelListener.actionPerformed(e);
                BranchArtDialog.this.modalDialog.setVisible(false);
            }
        });
        this.modalDialog.setMinimumSize(modalDialogDimension);
        this.modalDialog.setMaximumSize(modalDialogDimension);
        this.modalDialog.setPreferredSize(modalDialogDimension);
        this.modalDialog.setSize(modalDialogDimension);
    }

    private void updatePreviewImage(AbstractBranchArtDialog.BranchArtController controllerIn) {
        ImageIcon icon = controllerIn.updatePreviewImage(380.0, 360.0);
        this.previewImage.setIcon(icon);
    }

    private DefaultListModel createModel() {
        DefaultListModel<AbstractBranchArtDialog.BranchArtItem> dataModel = new DefaultListModel<AbstractBranchArtDialog.BranchArtItem>();
        for (BranchArt art : BranchArt.values()) {
            dataModel.addElement(new AbstractBranchArtDialog.BranchArtItem(art, this.getImageIconForArt(art)));
        }
        return dataModel;
    }

    private Icon getImageIconForArt(BranchArt art) {
        RetinaIcon icon;
        switch (art) {
            case ARROW: {
                icon = ResourceManager.getRetinaIcon("branchart/v2/branch-art-arrow.png");
                break;
            }
            case ARROWS: {
                icon = ResourceManager.getRetinaIcon("branchart/v2/branch-art-arrows.png");
                break;
            }
            case ARM: {
                icon = ResourceManager.getRetinaIcon("branchart/v2/branch-art-arm.png");
                break;
            }
            case HAND_DRAWN: {
                icon = ResourceManager.getRetinaIcon("branchart/v2/branch-art-handdrawn.png");
                break;
            }
            case HAND_DRAWN_ARROW: {
                icon = ResourceManager.getRetinaIcon("branchart/v2/branch-art-handdrawn-arrow.png");
                break;
            }
            case LIGHTNING: {
                icon = ResourceManager.getRetinaIcon("branchart/v2/branch-art-lightning.png");
                break;
            }
            case OUTLINE_THICK: {
                icon = ResourceManager.getRetinaIcon("branchart/v2/branch-art-outline-thick.png");
                break;
            }
            case OUTLINE_THIN: {
                icon = ResourceManager.getRetinaIcon("branchart/v2/branch-art-outline-thin.png");
                break;
            }
            case PENCIL: {
                icon = ResourceManager.getRetinaIcon("branchart/v2/branch-art-pencil.png");
                break;
            }
            case ROAD: {
                icon = ResourceManager.getRetinaIcon("branchart/v2/branch-art-road.png");
                break;
            }
            case TEXTURE_LATTICE: {
                icon = ResourceManager.getRetinaIcon("branchart/v2/branch-art-texture-honeycomb.png");
                break;
            }
            case TEXTURE_SKETCHY: {
                icon = ResourceManager.getRetinaIcon("branchart/v2/branch-art-texture-sketchy.png");
                break;
            }
            case TEXTURE_SQUARES: {
                icon = ResourceManager.getRetinaIcon("branchart/v2/branch-art-texture-square.png");
                break;
            }
            case REGULAR: {
                icon = ResourceManager.getRetinaIcon("branchart/v2/branch-art-regular.png");
                break;
            }
            case BRUSH: {
                icon = ResourceManager.getRetinaIcon("branchart/v2/branch-art-brush.png");
                break;
            }
            case SPLASH: {
                icon = ResourceManager.getRetinaIcon("branchart/v2/branch-art-splash.png");
                break;
            }
            case DOTS: {
                icon = ResourceManager.getRetinaIcon("branchart/v2/branch-art-circles.png");
                break;
            }
            case LINES: {
                icon = ResourceManager.getRetinaIcon("branchart/v2/branch-art-lines.png");
                break;
            }
            default: {
                icon = ResourceManager.getRetinaIcon("branchart/v2/branch-art-regular.png");
            }
        }
        return icon;
    }

    private ListSelectionListener createSelectionListener(final AbstractBranchArtDialog.BranchArtController controllerIn) {
        ListSelectionListener listener = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent event) {
                if (!event.getValueIsAdjusting() && event.getSource() instanceof JList) {
                    AbstractBranchArtDialog.BranchArtItem item = (AbstractBranchArtDialog.BranchArtItem)((JList)event.getSource()).getSelectedValue();
                    controllerIn.selectionChange(item.getType());
                    BranchArtDialog.this.updatePreviewImage(controllerIn);
                }
            }
        };
        return listener;
    }

    private ActionListener createOkActionListener(final AbstractBranchArtDialog.BranchArtController controllerIn) {
        return new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                BranchArtDialog.this.doSetStyle(controllerIn);
                BranchArtDialog.this.modalDialog.setVisible(false);
            }
        };
    }

    public final void doSetStyle(AbstractBranchArtDialog.BranchArtController controllerIn) {
        Map<String, Object> styleChanges = controllerIn.updateStyleMapForBranchArt(false);
        for (String style : styleChanges.keySet()) {
            Object value = styleChanges.get(style);
            if (value instanceof String) {
                controllerIn.setCellStyles(style, (String)value, controllerIn.getCells().toArray());
                continue;
            }
            controllerIn.setCellStyles(style, null, controllerIn.getCells().toArray());
        }
    }

    private ActionListener createCancelActionListener() {
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                BranchArtDialog.this.modalDialog.setVisible(false);
            }
        };
        return listener;
    }

    private void createPopup(DefaultListModel dataModel, ListSelectionListener listener, AbstractBranchArtDialog.BranchArtController controllerIn) {
        this.list = new JList(dataModel);
        this.list.setPreferredSize(new Dimension(320, (dataModel.size() + dataModel.size() % 2) * 140 / 2));
        this.list.setSelectionMode(0);
        this.list.setLayoutOrientation(2);
        this.list.setFixedCellWidth(75);
        this.list.setFixedCellHeight(75);
        this.list.setVisibleRowCount(-1);
        this.list.setCellRenderer(new BranchArtListItemRenderer(this.list, 75, 75));
        this.list.setOpaque(false);
        this.list.addListSelectionListener(listener);
        JPanel listPanel = new JPanel();
        listPanel.add(this.list);
        listPanel.setOpaque(false);
        listPanel.setBorder(BorderFactory.createEmptyBorder());
        listPanel.setPreferredSize(new Dimension(320, 460));
        JPanel preview = new JPanel();
        preview.setOpaque(false);
        preview.setPreferredSize(new Dimension(400, 460));
        preview.setLayout(new BorderLayout());
        JPanel imagePanel = new JPanel();
        imagePanel.setOpaque(false);
        imagePanel.setLayout(new BorderLayout());
        imagePanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        this.previewImage = new JLabel();
        this.previewImage.setOpaque(false);
        this.previewImage.setHorizontalAlignment(0);
        imagePanel.add((Component)this.previewImage, "Center");
        preview.add((Component)imagePanel, "Center");
        JPanel split = new JPanel();
        split.setOpaque(false);
        split.setLayout(new BorderLayout());
        split.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        split.add((Component)listPanel, "West");
        split.add((Component)preview, "Center");
        this.modalDialog.setContent(split);
        this.modalDialog.setBounds(0, 0, this.modalDialog.getPreferredSize().width, this.modalDialog.getPreferredSize().height);
    }

    public final JList getList() {
        return this.list;
    }

    public final JDialog getDialog() {
        return this.modalDialog;
    }
}

