/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.dnd.handler.utils;

import com.thinkbuzan.gaia.dnd.handler.AbstractDropHandler;
import com.thinkbuzan.gaia.dnd.handler.utils.Validator;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.Sanselan;
import org.apache.sanselan.common.byteSources.ByteSource;
import org.apache.sanselan.common.byteSources.ByteSourceFile;
import org.apache.sanselan.formats.jpeg.JpegImageParser;
import org.apache.sanselan.formats.jpeg.segments.UnknownSegment;

public class JpegReader {
    public static final int COLOR_TYPE_RGB = 1;
    public static final int COLOR_TYPE_CMYK = 2;
    public static final int COLOR_TYPE_YCCK = 3;
    private int a = 1;
    private boolean b = false;
    private static final String z;

    public BufferedImage readImage(File file) throws IOException, ImageReadException {
        this.a = 1;
        this.b = false;
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(file);
        Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
        if (iterator.hasNext()) {
            BufferedImage bufferedImage;
            ImageReader imageReader = iterator.next();
            imageReader.setInput(imageInputStream);
            ICC_Profile iCC_Profile = null;
            try {
                bufferedImage = imageReader.read(0);
            }
            catch (IIOException iIOException) {
                this.a = 2;
                this.checkAdobeMarker(file);
                iCC_Profile = Sanselan.getICCProfile((File)file);
                WritableRaster writableRaster = (WritableRaster)imageReader.readRaster(0, null);
                if (this.a == 3) {
                    JpegReader.convertYcckToCmyk(writableRaster);
                }
                if (this.b) {
                    JpegReader.convertInvertedColors(writableRaster);
                }
                bufferedImage = JpegReader.convertCmykToRgb(writableRaster, iCC_Profile);
            }
            return bufferedImage;
        }
        return null;
    }

    public void checkAdobeMarker(File file) throws IOException, ImageReadException {
        JpegImageParser jpegImageParser = new JpegImageParser();
        ByteSourceFile byteSourceFile = new ByteSourceFile(file);
        ArrayList arrayList = jpegImageParser.readSegments((ByteSource)byteSourceFile, new int[]{65518}, true);
        if (arrayList != null && arrayList.size() >= 1) {
            UnknownSegment unknownSegment = (UnknownSegment)arrayList.get(0);
            byte[] byArray = unknownSegment.bytes;
            if (byArray.length >= 12 && byArray[0] == 65 && byArray[1] == 100 && byArray[2] == 111 && byArray[3] == 98 && byArray[4] == 101) {
                this.b = true;
                int n = unknownSegment.bytes[11] & 0xFF;
                if (n == 2) {
                    this.a = 3;
                }
            }
        }
    }

    public static void convertYcckToCmyk(WritableRaster writableRaster) {
        boolean bl = Validator.a;
        int n = writableRaster.getHeight();
        int n2 = writableRaster.getWidth();
        int n3 = n2 * 4;
        int[] nArray = new int[n3];
        for (int i = 0; i < n; ++i) {
            writableRaster.getPixels(0, i, n2, 1, nArray);
            for (int j = 0; j < n3; j += 4) {
                int n4;
                int n5;
                int n6;
                block19: {
                    block18: {
                        block17: {
                            block16: {
                                block15: {
                                    block14: {
                                        n6 = nArray[j];
                                        int n7 = nArray[j + 1];
                                        int n8 = nArray[j + 2];
                                        n5 = (int)((double)n6 + 1.402 * (double)n8 - 178.956);
                                        n4 = (int)((double)n6 - 0.34414 * (double)n7 - 0.71414 * (double)n8 + 135.95984);
                                        n6 = (int)((double)n6 + 1.772 * (double)n7 - 226.316);
                                        if (n5 >= 0) break block14;
                                        n5 = 0;
                                        if (!bl) break block15;
                                    }
                                    if (n5 > 255) {
                                        n5 = 255;
                                    }
                                }
                                if (n4 >= 0) break block16;
                                n4 = 0;
                                if (!bl) break block17;
                            }
                            if (n4 > 255) {
                                n4 = 255;
                            }
                        }
                        if (n6 >= 0) break block18;
                        n6 = 0;
                        if (!bl) break block19;
                    }
                    if (n6 > 255) {
                        n6 = 255;
                    }
                }
                nArray[j] = 255 - n5;
                nArray[j + 1] = 255 - n4;
                nArray[j + 2] = 255 - n6;
                if (!bl) continue;
            }
            writableRaster.setPixels(0, i, n2, 1, nArray);
            if (!bl) continue;
        }
    }

    public static void convertInvertedColors(WritableRaster writableRaster) {
        boolean bl = Validator.a;
        int n = writableRaster.getHeight();
        int n2 = writableRaster.getWidth();
        int n3 = n2 * 4;
        int[] nArray = new int[n3];
        for (int i = 0; i < n; ++i) {
            writableRaster.getPixels(0, i, n2, 1, nArray);
            for (int j = 0; j < n3; ++j) {
                nArray[j] = 255 - nArray[j];
                if (!bl) continue;
            }
            writableRaster.setPixels(0, i, n2, 1, nArray);
            if (!bl) continue;
        }
    }

    public static BufferedImage convertCmykToRgb(Raster raster, ICC_Profile iCC_Profile) throws IOException {
        Object object;
        boolean bl = Validator.a;
        if (iCC_Profile == null) {
            iCC_Profile = ICC_Profile.getInstance(JpegReader.class.getResourceAsStream(z));
        }
        if (iCC_Profile.getProfileClass() != 1 && (object = iCC_Profile.getData())[64] == 0) {
            JpegReader.a(1835955314, object, 12);
            iCC_Profile = ICC_Profile.getInstance(object);
        }
        object = new ICC_ColorSpace(iCC_Profile);
        BufferedImage bufferedImage = new BufferedImage(raster.getWidth(), raster.getHeight(), 1);
        WritableRaster writableRaster = bufferedImage.getRaster();
        ColorSpace colorSpace = bufferedImage.getColorModel().getColorSpace();
        ColorConvertOp colorConvertOp = new ColorConvertOp((ColorSpace)object, colorSpace, null);
        colorConvertOp.filter(raster, writableRaster);
        if (bl) {
            AbstractDropHandler.b = !AbstractDropHandler.b;
        }
        return bufferedImage;
    }

    static void a(int n, byte[] byArray, int n2) {
        boolean bl = Validator.a;
        byArray[n2] = (byte)(n >> 24);
        byArray[n2 + 1] = (byte)(n >> 16);
        byArray[n2 + 2] = (byte)(n >> 8);
        byArray[n2 + 3] = (byte)n;
        if (AbstractDropHandler.b) {
            Validator.a = !bl;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block10: {
            int n;
            int n2;
            char[] cArray2;
            int n3;
            block9: {
                Object var0 = null;
                char[] cArray3 = "\u0012<+<AR\u0014\f\u0016Fb\u0003J,\u0011\rE'\u0016AT[\u0011\u0010A".toCharArray();
                n3 = 0;
                int n4 = cArray3.length;
                cArray2 = cArray3;
                n2 = n4;
                if (n4 <= 1) break block9;
                cArray = cArray2;
                n = n2;
                if (n2 <= n3) break block10;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n5 = n3;
                while (true) {
                    int n6;
                    char c2 = cArray4[n5];
                    switch (n3 % 5) {
                        case 0: {
                            n6 = 61;
                            break;
                        }
                        case 1: {
                            n6 = 117;
                            break;
                        }
                        case 2: {
                            n6 = 120;
                            break;
                        }
                        case 3: {
                            n6 = 115;
                            break;
                        }
                        default: {
                            n6 = 34;
                        }
                    }
                    cArray4[n5] = (char)(c2 ^ n6);
                    ++n3;
                    cArray2 = cArray5;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray5 = cArray2;
                    n = n2;
                    n5 = n2;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n = n2;
            } while (n2 > n3);
        }
        z = new String(cArray).intern();
    }
}

