/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.importer.word;

import com.thinkbuzan.chaos.internationalization.I18n;
import com.thinkbuzan.chaos.internationalization.ITextBundle;
import com.thinkbuzan.chaos.osgiutilities.service.OSGiService;
import com.thinkbuzan.gaia.importer.word.WordImporter;
import com.thinkbuzan.gaia.importer.word.license.BundleLicenser;
import com.thinkbuzan.gaia.importmanager.IImporter;
import com.thinkbuzan.gaia.importmanager.ImportManager;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public final class Activator
implements BundleActivator {
    public void start(BundleContext context) throws Exception {
        this.registerWordImporter(context);
    }

    private void registerWordImporter(BundleContext context) {
        BundleLicenser licenser = new BundleLicenser(context);
        OSGiService importManagerService = new OSGiService(context, ImportManager.class);
        if (licenser.isWordImportLicensed()) {
            ((ImportManager)importManagerService.get()).register((IImporter)new WordImporter(this.getI18n(context)));
        } else {
            ((ImportManager)importManagerService.get()).registerUnlicensed((IImporter)new WordImporter(this.getI18n(context)));
        }
        importManagerService.close();
    }

    private I18n getI18n(BundleContext context) {
        I18n i18n = (I18n)new OSGiService(context, I18n.class).get();
        i18n.register(new ITextBundle(){

            public ClassLoader getClassLoader() {
                return Activator.class.getClassLoader();
            }

            public String getPropertyFileBaseName() {
                return "/i18nproperties/WordImporterMessages";
            }
        });
        return i18n;
    }

    public void stop(BundleContext context) throws Exception {
    }
}

